#ifndef __CONFIG_H
#define __CONFIG_H

#include "mbed.h"

#define MAXSTR 30
#define MAXTBL 30

union Value {
    double d;
    int i;
};
    
typedef struct {
    char key[MAXSTR];
    char format;
    Value value;
} ConfigEntry;

class Config {
public:
    enum{INT, DOUBLE} format;
    Config();
    int load(char *filename);
    int assign(char *key, char *value);
    void add(char *key, char format);
    void attach(Callback<void(char *)>, char *key, char format);
    int get(char *key, double *value);
    int get(char *key, int *value);
    template<typename T>
    T retrieve(char *key);
    
private:
    static const int MAXBUF=128;
    char buf[MAXBUF];
    ConfigEntry table[MAXTBL];
    int itable;
    int lookup(char *key);
};

#endif