#include "Config.h"
#include <ctype.h>


Config::Config()
{
    itable = 0;
    
    return;
}

char *trim(char *s) 
{
    char *t = s;

    // rtrim
    t = s + strlen(s) - 1;
    while (isspace(*t))
        *t = '\0';
    
    // ltrim
    while (*s && isspace(*s)) 
        s++;
    
    return s;
}


// convert character to an int
//
int ctoi(char c)
{
  int i=-1;
  
  if (c >= '0' && c <= '9') {
    i = c - '0';
  }

  //printf("char: %c  int %d\n", c, i); 
 
  return i;
}


// convert string to floating point
//
double cvstof(char *s)
{
  double f=0.0;
  double mult = 0.1;
  bool neg = false;
  //char dec = 1;
  
  // leading spaces
  while (*s == ' ' || *s == '\t') {
    s++;
    if (*s == 0) break;
  }

  // What about negative numbers?
  if (*s == '-') {
    neg = true;
    s++;
  }

  // before the decimal
  //
  while (*s != 0) {
    if (*s == '.') {
      s++;
      break;
    }
    f = (f * 10.0) + (double) ctoi(*s);
    s++;
  }
  // after the decimal
  while (*s != 0 && *s >= '0' && *s <= '9') {
    f += (double) ctoi(*s) * mult;
    mult /= 10;
    s++;
  }
  
  // if we were negative...
  if (neg) f = -f;
  
  return f;
}


int Config::load(char *filename) 
{
    char buf[MAXBUF];
    char *key;
    char *value;
    int status=0;
    FILE *fp;
    
    fp = fopen(filename, "r");
    if (fp == NULL) {
        status = -1;
    } else {
        while (!feof(fp)) {
            fgets(buf, MAXBUF-1, fp);

            char *t = buf;
            char *s = buf;
            // trim spaces and terminate at #
            while (*t) {
                if (isspace(*buf)) {
                    s = t;
                } else if (*t == '#') {
                    *t = '\0';
                }
                t++;
            }
            
            key = strtok(s, ":#");
            value = strtok(NULL, ":#");
            if (key && value && *key && *value) {
                key = trim(key);
                value = trim(value);
                assign(key, value);
            }
        }
        fclose(fp);
    }
    
    for (int i=0; i < itable; i++) {
        printf("%s = ", table[i].key);
        switch (table[i].format) {
        case DOUBLE:
            printf("%f\n", table[i].value.d);
            break;
        case INT:
            printf("%d\n", table[i].value.i);
            break;
        default:
            break;
        }
        
    }
    return status;
}


void Config::add(char *key, char format)
{
    if (key && itable < MAXTBL) {
        strncpy(table[itable].key, key, MAXSTR);
        table[itable].format = format;
        itable++;
    }
    
    return;
}


int Config::assign(char *key, char *value)
{
    int found = 0;
    int status = 0;
    char format = 0;

    // lookup
    for (int i=0; i < itable; i++) {
        if (!strncmp(table[i].key, key, MAXSTR)) {
            found = 1;
            format = table[i].format;
            // assignment
            switch (format) {
            case DOUBLE :
                table[i].value.d = atof(value);
                break;
            case INT :
                table[i].value.i = atoi(value);
                break;
            default:
                break;
            }
            break;
        }
    }

    if (!found) {    
        status = 1;
        printf("key not found: %s\n", key);
    }
    
    return status;
}


int Config::get(char *key, double *value)
{
    int status = 0;
    
    return status;
}

int Config::get(char *key, int *value)
{
    int status = 0;
    
    return status;
}