// ADC128S   a library for the National Semiconductor ADC128S family of ADCs
//
// by Michael Shimniok - http://www.bot-thoughts.com/
//
#include "mbed.h"
#include "ADC128S.h"

ADC128S::ADC128S(PinName mosi, PinName miso, PinName sck, PinName cs) : _adc(mosi, miso, sck), _cs(cs), _channel(0) {
    _adc.format(16,3);
    _adc.frequency(8000000);
}

int ADC128S::getChannel() {
    return _channel;
}

void ADC128S::setChannel(int channel) {
    _cs = 0;
    _adc.write(channel<<11); // send channel for next acquisition; XXXAAAXX XXXXXXXX
    _adc.write(channel<<11); // send channel for next acquisition; XXXAAAXX XXXXXXXX
    _cs = 1;
    _channel = channel;
}

unsigned int ADC128S::read() {
    unsigned int result = 0;
    _cs = 0;
    // get next acquisition, send next channel: XXXAAAXX XXXXXXXX
    _channel++;
    _channel %= 8;
    result = _adc.write(_channel<<11);
    _cs = 1;
    
    return result;
}

unsigned int ADC128S::read(int channel) {
    unsigned int result = 0;
    _cs = 0;
    _adc.write(channel<<11); // send channel for next acquisition; XXXAAAXX XXXXXXXX
    _cs = 1;
    wait_us(50);
    _cs = 0;
    result = _adc.write(channel<<11); // get next acquisition
    _cs = 1;
    
    return result;
}
