#include "mbed.h"
#include "string"
#include "RoboClaw.h"
//1272552550b00000001\n受信例

#define ruto_3 1.73205080757//√3
#define MAX_QPPS1 40960/3
#define MAX_QPPS2 40960/3
#define ADRS1 130
#define ADRS2 129
#define TIME 0.02

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

RawSerial reciv(p9,p10,115200);
RawSerial recivsome(p28,p27,115200);
RoboClaw MD(115200,p13,p14);
RawSerial pc (USBTX,USBRX,115200);

Ticker trans;//trasからtransへ変更予定trans=transmission（送信）

char motoX;//モーターX軸
char motoY;//モーターY軸
char motoR;//モーター回転数
char button;//ボタン信号 上半身へ送信
char reciv_c;

string reciv_str = "";//trasからtransへ変更予定

void atrans(){//読み取り処理
    reciv_c = reciv.getc();//シリアル受信
    reciv_str += reciv_c;
    led1 = 1;
    led2 = 0;
    led3 = 0;
    led4 = 0;
    if(reciv_c == '\n'){//末尾改行コード（\n）感知
        motoY = reciv_str[0];
        motoX = reciv_str[1];
        motoR = reciv_str[2];
        button = reciv_str[3];
        reciv_str = "";
        led1 = 0;
        led2 = 1;
        led3 = 0;
        led4 = 0;
        
        
    }
}
void aUSBtx(){//書き込み処理
    pc.printf("=%d,%d,%d",motoX,motoY,motoR);
    //pc.printf(",%d",button);
    recivsome.putc(button);//上半身送信
    recivsome.putc('\n');
    pc.printf("\n");
    int motoXV = motoX - 127;
    int motoYV = motoY - 127;
    int motoRV = motoR - 127;
    
    double V1 = (double)motoXV + (double)motoRV;
    double V2 = -0.5*(double)motoXV + ruto_3*0.5*(double)motoYV + (double)motoRV;
    double V3 = -0.5*(double)motoXV - ruto_3*0.5*(double)motoYV + (double)motoRV;
    pc.printf("v1=%d,v2=%d,v3=%d",int(V1),int(V2),int(V3));
    led1 = 0;
    led2 = 0;
    led3 = 1;
    led4 = 0;
}
void Roboclaw_send(double V1, double V2, double V3){
    MD.SpeedM1(ADRS1,int(V3*MAX_QPPS1));
    MD.SpeedM2(ADRS1,int(V2*MAX_QPPS1));
    MD.SpeedM1(ADRS2,int(V1*MAX_QPPS2));
    led1 = 0;
    led2 = 0;
    led3 = 0;
    led4 = 1;
}
int main()
{
        trans.attach(&aUSBtx,TIME);//タイマー割込み
        
        reciv.attach(&atrans,RawSerial::RxIrq);//受信割込み
    while(1) {
    }
}