#include "mbed.h"
#include "nexpaq_mdk.h"
#include "ds3231.h"
#include "algorithm.h"
#include "MAX30102.h"

#define I2C_SDA P1_6
#define I2C_SCL P1_7

#define		FUNCTION_TABLE_NUM					2
#define		UUID_NUM							16			// UUID number is 16, don't change it
#define     LOOP_DELAY                          1000

DigitalOut ledR(P2_4, LED_OFF);
DigitalOut ledG(P2_5, LED_OFF);
DigitalOut ledB(P2_6, LED_OFF);

uint32_t aun_ir_buffer[500]; //IR LED sensor data
int32_t n_ir_buffer_length;    //data length
uint32_t aun_red_buffer[500];    //Red LED sensor data
int32_t n_sp02; //SPO2 value
int8_t ch_spo2_valid;   //indicator to show if the SP02 calculation is valid
int32_t n_heart_rate;   //heart rate value
int8_t  ch_hr_valid;    //indicator to show if the heart rate calculation is valid
uint8_t uch_dummy;

DigitalIn INT(P4_1);

AnalogIn aIn0(AIN_0);
AnalogIn aIn1(AIN_1);
AnalogIn aIn2(AIN_2);
AnalogIn aIn3(AIN_3);
AnalogIn aIn4(AIN_4);
AnalogIn aIn5(AIN_5);
DigitalInOut digPin[] = {DigitalInOut(P0_1),DigitalInOut(P0_0),DigitalInOut(P1_2),DigitalInOut(P1_1),
                         DigitalInOut(P1_0),DigitalInOut(P1_3),DigitalInOut(P1_7),DigitalInOut(P1_6),
                         DigitalInOut(P3_0),DigitalInOut(P3_1),DigitalInOut(P3_4),DigitalInOut(P3_5),
                         DigitalInOut(P0_2),DigitalInOut(P0_3),DigitalInOut(P4_0),DigitalInOut(P4_1)
                        };

/***** Definitions *****/
#define		FUNCTION_TABLE_NUM					2
#define		UUID_NUM							16			// UUID number is 16, don't change it
#define     LOOP_DELAY                          1000

/***** Globals *****/
void my_function_CMD_2700(unsigned char *pData, unsigned char len);
void my_function_CMD_2702(unsigned char *pData, unsigned char len);
const MDK_REGISTER_CMD my_cmd_func_table[FUNCTION_TABLE_NUM] = {
    {0x2700, my_function_CMD_2700},		// Command -> function
    {0x2702, my_function_CMD_2702},		// Command -> function
};

unsigned char dataOut[10];
Ds3231 temp_sense(P3_4, P3_5); 
DigitalOut cs(P1_3);
//vitals
int spo2=50,heart_rate=120,Resp_rate=12,tmp=25;
/***** Functions *****/
void my_function_CMD_2700(unsigned char *pData, unsigned char len)
{
    unsigned char response = 0x00;
/*    ledR = 1.0f - (pData[0] / 255.0f);
    ledG = 1.0f - (pData[1] / 255.0f);
    ledB = 1.0f - (pData[2] / 255.0f);*/
    np_api_upload(0x2701, &response, 1);
}

void my_function_CMD_2702(unsigned char *pData, unsigned char len)
{
    unsigned char response = 0x00;
    int pinIndex = pData[0];
    int pinMode = pData[1];
    switch(pinMode) {
        case 0:
        case 1:
            digPin[pinIndex].mode(PullNone);
            digPin[pinIndex].input();
            break;
        case 2:
            digPin[pinIndex].mode(PullDown);
            digPin[pinIndex].input();
            break;
        case 3:
            digPin[pinIndex].mode(PullUp);
            digPin[pinIndex].input();
            break;
        case 4:
            digPin[pinIndex]=0;
            digPin[pinIndex].output();
            break;
        case 5:
            digPin[pinIndex]=1;
            digPin[pinIndex].output();
            break;
    }
    np_api_upload(0x2703, &response, 1);
}

void sendStatus()
{
    np_api_upload(0x2800, dataOut, 10);
}

/******************************************************************************/
void app_setup()
{
    int i = 0;
//	np_api_set_app_version(0, 0, 3);
    if ( np_api_register((MDK_REGISTER_CMD*)my_cmd_func_table, FUNCTION_TABLE_NUM) == MDK_REGISTER_FAILD ) {
        // Register failed handle code
    }
/*    ledR = 1.0f;
    ledG = 1.0f;
    ledB = 1.0f;
    for (i = 0; i < 16; i++) {
        digPin[i].mode(PullUp);
        digPin[i].input();
    }
    for (i = 0; i < 10; i++) {
        dataOut[i] = 0xFF;
    }*/ 
   
     //instantiate rtc object
 	

}

void app_loop()
{	
	if((n_heart_rate>20)&&(n_heart_rate<220))
		heart_rate=n_heart_rate;
	if((n_sp02>60)&&(n_sp02<120))
	    spo2=n_sp02;
 
    tmp = temp_sense.get_temperature();
    dataOut[0] = heart_rate;
    dataOut[1] = heart_rate>>8;
    dataOut[2] = tmp;
    dataOut[3] = tmp>>8;
    dataOut[4] = spo2;
    dataOut[5] = spo2>>8;
    dataOut[6] = Resp_rate;
    dataOut[7] = Resp_rate>>8;

    dataOut[8] = (digPin[7].read()<<7) +
                 (digPin[6].read()<<6) +
                 (digPin[5].read()<<5) +
                 (digPin[4].read()<<4) +
                 (digPin[3].read()<<3) +
                 (digPin[2].read()<<2) +
                 (digPin[1].read()<<1) +
                 (digPin[0].read());
    dataOut[9] = (digPin[15].read()<<7) +
                 (digPin[14].read()<<6) +
                 (digPin[13].read()<<5) +
                 (digPin[12].read()<<4) +
                 (digPin[11].read()<<3) +
                 (digPin[10].read()<<2) +
                 (digPin[9].read()<<1) +
                 (digPin[8].read());
                 
    sendStatus();
}

int main(void)
{
    uint32_t un_min, un_max, un_prev_data;  //variables to calculate the on-board LED brightness that reflects the heartbeats
    int i;
    maxim_max30102_reset();
    maxim_max30102_read_reg(0,&uch_dummy);
    maxim_max30102_init();
    un_min=0x3FFFF;
    un_max=0;
    n_ir_buffer_length=500;
    np_api_init();
    app_setup();
    np_api_start();
    
    for(i=0;i<n_ir_buffer_length;i++)
    {
        while(INT.read()==1);   //wait until the interrupt pin asserts
        
        maxim_max30102_read_fifo((aun_red_buffer+i), (aun_ir_buffer+i));  //read from MAX30102 FIFO
            
        if(un_min>aun_red_buffer[i])
            un_min=aun_red_buffer[i];    //update signal min
        if(un_max<aun_red_buffer[i])
            un_max=aun_red_buffer[i];
    }
    un_prev_data=aun_red_buffer[i];
    maxim_heart_rate_and_oxygen_saturation(aun_ir_buffer, n_ir_buffer_length, aun_red_buffer, &n_sp02, &ch_spo2_valid, &n_heart_rate, &ch_hr_valid); 
    
    while(1) {
                i=0;
        un_min=0x3FFFF;
        un_max=0;
        
        //dumping the first 100 sets of samples in the memory and shift the last 400 sets of samples to the top
        for(i=100;i<500;i++)
        {
            aun_red_buffer[i-100]=aun_red_buffer[i];
            aun_ir_buffer[i-100]=aun_ir_buffer[i];
            
            //update the signal min and max
            if(un_min>aun_red_buffer[i])
            un_min=aun_red_buffer[i];
            if(un_max<aun_red_buffer[i])
            un_max=aun_red_buffer[i];
        }
    
    	for(i=400;i<500;i++)
        {
            un_prev_data=aun_red_buffer[i-1];
            while(INT.read()==1);
            maxim_max30102_read_fifo((aun_red_buffer+i), (aun_ir_buffer+i));
        
          /*  if(aun_red_buffer[i]>un_prev_data)
            {
                f_temp=aun_red_buffer[i]-un_prev_data;
                f_temp/=(un_max-un_min);
                f_temp*=MAX_BRIGHTNESS;
                n_brightness-=(int)f_temp;
                if(n_brightness<0)
                    n_brightness=0;
            }
            else
            {
                f_temp=un_prev_data-aun_red_buffer[i];
                f_temp/=(un_max-un_min);
                f_temp*=MAX_BRIGHTNESS;
                n_brightness+=(int)f_temp;
                if(n_brightness>MAX_BRIGHTNESS)
                    n_brightness=MAX_BRIGHTNESS;
            }*/
        
    		//led.write(1-(float)n_brightness/256);

            //send samples and calculation result to terminal program through UART

        }
//        ledR=LED_OFF;
//        ledG=LED_ON;
        maxim_heart_rate_and_oxygen_saturation(aun_ir_buffer, n_ir_buffer_length, aun_red_buffer, &n_sp02, &ch_spo2_valid, &n_heart_rate, &ch_hr_valid); 

        ledR = LED_ON;
        app_loop();
        np_api_bsl_chk();
        Thread::wait(LOOP_DELAY);
    }
    return 0;
}
