#include "mbed.h"
#include "USBCDCMSC.h"
#include "SDFileSystem.h"
#include <new>

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
SDFileSystem sd(p5, p6, p7, p8, "sd");
USBCDCMSC cdcmsc(&sd);

extern "C"
void HardFault_Handler() {
    printf("Hard Fault!\n");
    exit(-1);
}

void no_memory () {
    printf("panic: can't allocate to memory!\r\n");
    exit(-1);
}

void listdir (Stream *st) {
#if 0
    // probrem: readdir() Hard Fault
    DIR *dir;
    struct dirent *ent;
    
    if ((dir = opendir("/sd")) != NULL) {
        st->printf("dir opened\r\n");
        while ((ent = readdir(dir)) != NULL) {
            st->printf("%s\r\n", ent->d_name);
        }
    } else {
        st->printf("dir open error\r\n");
    }
    closedir(dir);
#else
    // direct FatFs
    FILINFO fno;
    DIR_t dir;
    char *fn;
#if _USE_LFN
    static char lfn[_MAX_LFN + 1];
    fno.lfname = lfn;
    fno.lfsize = sizeof(lfn);
#endif

    if (f_opendir(&dir, "") == FR_OK) {
        for (;;) {
            if (f_readdir(&dir, &fno) != FR_OK) break;
            if (fno.fname[0] == 0) break;
#if _USE_LFN
            fn = *fno.lfname ? fno.lfname : fno.fname;
#else
            fn = fno.fname;
#endif
            st->printf("%s\r\n", fn);            
        }
    }
#endif
}

void readfile (char *filename) {
    FILE *fp = fopen(filename, "r");
    if (fp) {
        int c;
        pc.printf("file: ");
        for (;;) {
            c = fgetc(fp);
            if (feof(fp)) break;
            pc.printf("%c", c);
        }
        pc.printf("\r\n");
        fclose(fp); 
    }
}

int main() {
    int c, u = 0;
    Timer timer;

    set_new_handler(no_memory); // new handler function

    readfile("/sd/test.txt");

    timer.start();
    while(1) {
        if (timer.read_ms() > 500) {
            myled = myled ? 0 : 1;
            timer.reset();
        }
        
        if (u != cdcmsc.configured()) {
            u = cdcmsc.configured();
            printf("configured %d\r\n", u);
        }
    
        if (u && cdcmsc.available()) {
            // CDC -> pc serial
            c = cdcmsc.getc();
            if (c == '?') {
                listdir(&cdcmsc);
            } else {
                pc.putc(c);
            }
        }
        if (pc.readable()) {
            // PC serial -> CDC
            c = pc.getc();
            if (c == '?') {
                listdir(&pc);
            } else {
                if (u) {
                    cdcmsc.putc(c);
                } else {
                    pc.putc(c);
                }
            }
        }
    }
}
