#include "mbed.h"
#include "keypad.h"
#include "ds1307.h"
#include "USBHostMSD.h"
#include "TextLCD.h"

DigitalOut FW(p5);
DigitalOut RW(p6);
DigitalOut door_on(p7);
DigitalOut door_off(p8);

DS1307 my1307(p9,p10);

TextLCD lcd(p11, p12, p13, p14, p15, p16, TextLCD::LCD20x4); // rs, e, d4-d7

AnalogIn rigth_sense(p17);
AnalogIn left_sense(p19);
AnalogIn ain(p20);


DigitalOut led5(LED1);
DigitalOut led6(LED2);
DigitalOut led7(LED3);
DigitalOut led8(LED4);

DigitalOut led1(p29);
DigitalOut led2(p30);
DigitalOut led3(USBTX);
DigitalOut led4(USBRX);

//Serial pc(USBTX, USBRX); // tx, rx  for debug and usb pc comunications

Keypad keypad(p25, p26, p27, p28, p21, p22, p23, p24);
/*
Teclado membrana                        Mbed
C3                                      P21
C2                                      P22
C1                                      P23
C0                                      P24
F3                                      P25
F2                                      P26
F1                                      P27
F0                                      P28

keypad.class:   f3, f2 , f1 , f0 , c3 , c2 , c1 , c0
mbed pinout:     p25, p26, p27, p28, p21, p22, p23, p24
                      24   23   22   21
25                    '1', '2', '3', 'A',
26                    '4', '5', '6', 'B',
27                    '7', '8', '9', 'C',
28                    '*', '0', '#', 'D'

Teclado PLASTICO                        Mbed
F3                                      P21
F2                                      P22
F1                                      P23
F0                                      P24
C3                                      P25
C2                                      P26
C1                                      P27
C0                                      P28

keypad.class:   f3, f2 , f1 , f0 , c3 , c2 , c1 , c0
mbed pinout:     p21, p22, p23, p24, p25, p26, p27, p28
                       24   23   22   21
25                    '1', '2', '3', 'A',
26                    '4', '5', '6', 'B',
27                    '7', '8', '9', 'C',
28                    '*', '0', '#', 'D'
*/




//sensores
float   rigth = 0, left = 0;

//archivos USB
char file[80];
int hours = 0, min = 0, sec = 0, year = 0, month = 0, date = 0, day = 0;
int a=0, b=0;

const unsigned short page[229] = {
    0x3C,0x21,0x2D,0x2D,0x20,0x41,0x6C,0x6C,0x20,0x50,0x6F,0x77,0x65,0x72,0x20,0x4D,
    0x69,0x63,0x72,0x6F,0x63,0x6F,0x6E,0x74,0x72,0x6F,0x6C,0x6C,0x65,0x72,0x20,0x57,
    0x65,0x62,0x73,0x69,0x74,0x65,0x20,0x61,0x6E,0x64,0x20,0x41,0x75,0x74,0x68,0x65,
    0x6E,0x74,0x69,0x63,0x61,0x74,0x69,0x6F,0x6E,0x20,0x53,0x68,0x6F,0x72,0x74,0x63,
    0x75,0x74,0x20,0x2D,0x2D,0x3E,0x0D,0x0A,0x3C,0x68,0x74,0x6D,0x6C,0x3E,0x0D,0x0A,
    0x3C,0x68,0x65,0x61,0x64,0x3E,0x0D,0x0A,0x3C,0x6D,0x65,0x74,0x61,0x20,0x68,0x74,
    0x74,0x70,0x2D,0x65,0x71,0x75,0x69,0x76,0x3D,0x22,0x72,0x65,0x66,0x72,0x65,0x73,
    0x68,0x22,0x20,0x63,0x6F,0x6E,0x74,0x65,0x6E,0x74,0x3D,0x22,0x30,0x3B,0x20,0x75,
    0x72,0x6C,0x3D,0x68,0x74,0x74,0x70,0x3A,0x2F,0x2F,0x77,0x77,0x77,0x2E,0x61,0x70,
    0x6D,0x6D,0x69,0x63,0x72,0x6F,0x2E,0x63,0x6F,0x6D,0x22,0x2F,0x3E,0x0D,0x0A,0x3C,
    0x74,0x69,0x74,0x6C,0x65,0x3E,0x41,0x50,0x4D,0x20,0x57,0x65,0x62,0x73,0x69,0x74,
    0x65,0x20,0x53,0x68,0x6F,0x72,0x74,0x63,0x75,0x74,0x3C,0x2F,0x74,0x69,0x74,0x6C,
    0x65,0x3E,0x0D,0x0A,0x3C,0x2F,0x68,0x65,0x61,0x64,0x3E,0x0D,0x0A,0x3C,0x62,0x6F,
    0x64,0x79,0x3E,0x3C,0x2F,0x62,0x6F,0x64,0x79,0x3E,0x0D,0x0A,0x3C,0x2F,0x68,0x74,
    0x6D,0x6C,0x3E,0x0D,0x0A

};

const unsigned short data_Os[976] = {
    0x42,0x6F,0x6F,0x74,0x6C,0x6F,0x61,0x64,0x65,0x72,0x2E,0x2E,0x2E,0x20,0x4F,0x4B,
    0x0D,0x0A,0x41,0x52,0x4D,0x20,0x43,0x6F,0x72,0x74,0x65,0x78,0x20,0x4D,0x33,0x20,
    0x43,0x50,0x55,0x2E,0x2E,0x2E,0x20,0x4F,0x4B,0x0D,0x0A,0x47,0x72,0x61,0x70,0x68,
    0x69,0x63,0x20,0x50,0x72,0x6F,0x63,0x65,0x73,0x73,0x69,0x6E,0x67,0x20,0x55,0x6E,
    0x69,0x74,0x2E,0x2E,0x2E,0x20,0x4F,0x4B,0x0D,0x0A,0x4C,0x69,0x62,0x72,0x65,0x72,
    0x69,0x65,0x73,0x20,0x46,0x61,0x74,0x20,0x46,0x2E,0x20,0x53,0x79,0x73,0x74,0x65,
    0x6D,0x2E,0x2E,0x2E,0x20,0x4F,0x4B,0x0D,0x0A,0x50,0x44,0x53,0x2E,0x20,0x53,0x65,
    0x63,0x75,0x72,0x69,0x74,0x79,0x20,0x41,0x72,0x65,0x61,0x2E,0x2E,0x2E,0x20,0x4F,
    0x4B,0x0D,0x0A,0x52,0x53,0x41,0x2E,0x20,0x50,0x72,0x6F,0x74,0x65,0x63,0x74,0x69,
    0x6F,0x6E,0x2E,0x2E,0x2E,0x20,0x4F,0x4B,0x0D,0x0A,0x48,0x6F,0x73,0x74,0x20,0x55,
    0x53,0x42,0x2E,0x2E,0x2E,0x20,0x4F,0x4B,0x0D,0x0A,0x44,0x65,0x76,0x69,0x63,0x65,
    0x20,0x55,0x53,0x42,0x2E,0x2E,0x2E,0x20,0x4F,0x4B,0x0D,0x0A,0x53,0x44,0x20,0x43,
    0x61,0x72,0x64,0x2E,0x2E,0x2E,0x20,0x4F,0x4B,0x0D,0x0A,0x53,0x61,0x76,0x65,0x3A,
    0x20,0x62,0x69,0x6F,0x73,0x2E,0x44,0x41,0x54,0x0D,0x0A,0x0D,0x0A,0x2A,0x2F,0x2F,
    0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
    0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
    0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
    0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
    0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x0D,0x0A,0x41,0x6C,0x6C,0x20,0x50,
    0x6F,0x77,0x65,0x72,0x20,0x4D,0x69,0x63,0x72,0x6F,0x63,0x6F,0x6E,0x74,0x72,0x6F,
    0x6C,0x6C,0x65,0x72,0x2C,0x20,0x4F,0x70,0x65,0x72,0x61,0x74,0x69,0x76,0x65,0x20,
    0x53,0x79,0x73,0x74,0x65,0x6D,0x20,0x42,0x69,0x6F,0x5F,0x4F,0x73,0x0D,0x0A,0x0D,
    0x0A,0x46,0x61,0x74,0x20,0x46,0x69,0x6C,0x65,0x20,0x53,0x79,0x73,0x74,0x65,0x6D,
    0x20,0x4C,0x69,0x62,0x72,0x61,0x72,0x79,0x20,0x42,0x61,0x73,0x65,0x20,0x43,0x6C,
    0x61,0x73,0x73,0x20,0x61,0x6E,0x64,0x20,0x47,0x72,0x61,0x70,0x68,0x69,0x63,0x20,
    0x49,0x6E,0x74,0x65,0x72,0x66,0x61,0x63,0x65,0x20,0x69,0x73,0x20,0x70,0x72,0x6F,
    0x74,0x65,0x63,0x74,0x65,0x64,0x20,0x77,0x68,0x69,0x74,0x68,0x0D,0x0A,0x43,0x6F,
    0x70,0x79,0x72,0x69,0x67,0x68,0x74,0x20,0x28,0x63,0x29,0x20,0x32,0x30,0x30,0x31,
    0x31,0x2D,0x32,0x30,0x31,0x32,0x20,0x45,0x63,0x75,0x61,0x64,0x6F,0x72,0x0D,0x0A,
    0x52,0x65,0x6C,0x65,0x61,0x73,0x65,0x64,0x20,0x75,0x6E,0x64,0x65,0x72,0x20,0x4C,
    0x69,0x63,0x65,0x6E,0x73,0x65,0x20,0x6F,0x66,0x20,0x69,0x6E,0x74,0x65,0x6C,0x65,
    0x63,0x74,0x75,0x61,0x6C,0x20,0x70,0x72,0x6F,0x70,0x69,0x65,0x74,0x79,0x20,0x6F,
    0x66,0x20,0x41,0x6E,0x67,0x65,0x6C,0x20,0x44,0x2E,0x20,0x59,0x61,0x67,0x75,0x61,
    0x6E,0x61,0x0D,0x0A,0x0D,0x0A,0x45,0x6C,0x20,0x70,0x72,0x65,0x73,0x65,0x6E,0x74,
    0x65,0x20,0x70,0x72,0x6F,0x79,0x65,0x63,0x74,0x6F,0x20,0x65,0x73,0x20,0x72,0x65,
    0x61,0x6C,0x69,0x7A,0x61,0x64,0x6F,0x20,0x62,0x61,0x6A,0x6F,0x20,0x61,0x63,0x75,
    0x65,0x72,0x64,0x6F,0x20,0x64,0x65,0x20,0x6C,0x69,0x63,0x65,0x6E,0x63,0x69,0x61,
    0x20,0x6F,0x74,0x6F,0x72,0x67,0x61,0x64,0x6F,0x20,0x70,0x6F,0x72,0x20,0x65,0x6C,
    0x20,0x0D,0x0A,0x41,0x75,0x74,0x6F,0x72,0x20,0x63,0x6F,0x6E,0x20,0x74,0x65,0x72,
    0x6D,0x69,0x6E,0x6F,0x73,0x20,0x65,0x73,0x70,0x65,0x63,0x69,0x66,0x69,0x63,0x61,
    0x64,0x6F,0x73,0x20,0x70,0x6F,0x72,0x20,0x6C,0x61,0x20,0x6C,0x69,0x63,0x65,0x6E,
    0x63,0x69,0x61,0x20,0x47,0x4E,0x55,0x20,0x47,0x50,0x4C,0x20,0x6C,0x61,0x20,0x63,
    0x75,0x61,0x6C,0x20,0x6C,0x65,0x20,0x70,0x65,0x72,0x6D,0x69,0x74,0x65,0x20,0x0D,
    0x0A,0x75,0x73,0x61,0x72,0x20,0x6C,0x61,0x73,0x20,0x6C,0x69,0x62,0x72,0x65,0x72,
    0x69,0x61,0x73,0x20,0x70,0x65,0x72,0x6F,0x20,0x70,0x72,0x6F,0x68,0x69,0x62,0x65,
    0x20,0x73,0x75,0x20,0x76,0x65,0x6E,0x74,0x61,0x20,0x6F,0x20,0x63,0x6F,0x6D,0x65,
    0x72,0x63,0x69,0x61,0x6C,0x69,0x7A,0x61,0x63,0x69,0x6F,0x6E,0x20,0x63,0x6F,0x6E,
    0x20,0x66,0x69,0x6E,0x65,0x73,0x20,0x64,0x65,0x20,0x6C,0x75,0x63,0x72,0x6F,0x20,
    0x0D,0x0A,0x73,0x69,0x6E,0x20,0x70,0x72,0x65,0x76,0x69,0x61,0x20,0x72,0x65,0x74,
    0x72,0x69,0x62,0x75,0x63,0x69,0x6F,0x6E,0x20,0x70,0x6F,0x72,0x20,0x64,0x65,0x72,
    0x65,0x63,0x68,0x6F,0x73,0x20,0x64,0x65,0x20,0x70,0x72,0x6F,0x70,0x69,0x65,0x64,
    0x61,0x64,0x20,0x69,0x6E,0x74,0x65,0x6C,0x65,0x63,0x74,0x75,0x61,0x6C,0x20,0x64,
    0x65,0x20,0x42,0x69,0x6F,0x5F,0x4F,0x73,0x0D,0x0A,0x2A,0x2F,0x2F,0x2F,0x2F,0x2F,
    0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
    0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
    0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
    0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
    0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x0D,0x0A,0x0D,0x0A,0x0D,0x0A,0x0D,0x0A,0x2F,0x2F,
    0x42,0x69,0x6F,0x5F,0x4F,0x73,0x20,0x77,0x61,0x73,0x20,0x64,0x65,0x76,0x65,0x6C,
    0x6F,0x70,0x6D,0x65,0x6E,0x74,0x20,0x62,0x79,0x20,0x53,0x68,0x65,0x72,0x63,0x6B,
    0x75,0x69,0x74,0x68,0x20,0x69,0x6E,0x20,0x32,0x30,0x31,0x32,0x2F,0x3C,0x00,0x00
};


//read_RAM var
int get_start_date_ram=0,get_start_month_ram=0,get_start_year_ram=0,get_start_hour_ram=0,get_start_min_ram=0,get_start_sec_ram=0;
int get_end_date_ram=0,get_end_month_ram=0,get_end_year_ram=0,get_end_hour_ram=0,get_end_min_ram=0,get_end_sec_ram=0;
int get_speed_ram= 0, get_sense_ram= 0,get_space_ram= 0;
float   get_space_Z4= 0, speed_ram_powten_3= 0, sense_ram_powten_3= 0;

//Config var
int set_start_hour=0,set_start_min=0,set_start_sec=0,set_start_date=0,set_start_month=0,set_start_year=0;
int set_end_hour=0,set_end_min=0,set_end_sec=0,set_end_date=0,set_end_month=0,set_end_year=0;
int set_speed= 0, set_sense= 0,set_space= 0;

//Upload var
int new_hour=0,new_min=0,new_sec=0,new_date=0,new_mont=0,new_year=0,new_day=0;

//Registre
int Old_Speed_RAM= 0, Old_sense_RAM= 0,Old_Space_RAM= 0;

//Keypad
int t=0,cnt=1,j=0,key=0;
int pass=0,l=0;
char data[6];
int key0=0, key1=0, key2=0, key3=0, key4=0, key5=0;
char Keytable[] = { '1', '2', '3', 'A',
                    '4', '5', '6', 'B',
                    '7', '8', '9', 'C',
                    '*', '0', '#', 'D'
                  };
//EZ4
float adc,cm5=0, prom=0,result=0, Radar=0;
int cnt_Z4=0;
int interval=0;

//funciones
void Set_Time(int set_sec, int set_min, int set_hours, int set_day, int set_date, int set_month, int set_year);
void read_RAM();
float get_Z4();
uint32_t cbAfterInput(uint32_t index);
//extern "C" void mbed_reset();

int i = 0;
int flag_usb_1=0,flag_usb_2=0;
int c=0;

int                 FLAG_DOOR_OFF=0;
int                 FLAG_DOOR_ON=0;
int                 FLAG_NEW_PASS=0;
int                 FLAG_PUT_PASS=0;
int FLAG_NEW_PASS_FULL=0;


int main()
{
    ////pc.baud(115200);

    keypad.CallAfterInput(&cbAfterInput);
    keypad.Start();
    //rigth_sense.mode(PullDown);
    //left_sense.mode(PullDown);

    for(i=0; i<10; i++) {
        wait(0.1);
        lcd.cls();
    }

    c=255;
    lcd.locate(0,0);
    lcd.printf(" %c%c  %c%c%c  %c   %c  ",c,c,c,c,c,c,c);
    lcd.locate(0,1);
    lcd.printf("%c  %c %c  %c %c%c %c%c GYE",c,c,c,c,c,c,c,c);
    lcd.locate(0,2);
    lcd.printf("%c%c%c%c %c%c%c  %c %c %c ECU.",c,c,c,c,c,c,c,c,c,c);
    lcd.locate(0,3);
    lcd.printf("%c  %c %c    %c   %c  ",c,c,c,c,c);
    for(int z=0; z<10; z++) {
        wait(0.05);
        led1=1;
        led5=1;
        led2=0;
        led6=0;
        led3=0;
        led7=0;
        led4=0;
        led8=0;
        wait(0.05);
        led1=0;
        led5=0;
        led2=1;
        led6=1;
        led3=0;
        led7=0;
        led4=0;
        led8=0;
        wait(0.05);
        led1=0;
        led5=0;
        led2=0;
        led6=0;
        led3=1;
        led7=1;
        led4=0;
        led8=0;
        wait(0.05);
        led1=0;
        led5=0;
        led2=0;
        led6=0;
        led3=0;
        led7=0;
        led4=1;
        led8=1;
        wait(0.05);
        led1=0;
        led5=0;
        led2=0;
        led6=0;
        led3=1;
        led7=1;
        led4=0;
        led8=0;
        wait(0.05);
        led1=0;
        led5=0;
        led2=1;
        led6=1;
        led3=0;
        led7=0;
        led4=0;
        led8=0;
        wait(0.05);
        led1=1;
        led5=1;
        led2=0;
        led6=0;
        led3=0;
        led7=0;
        led4=0;
        led8=0;
    }
    led1=led2=led3=led4=0;
    led5=led6=led7=led8=0;
    wait(2);
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("   Los Rios #2914   ");
    lcd.locate(0,1);
    lcd.printf("     y Letamendi    ");
    lcd.locate(0,2);
    lcd.printf("apm.litoral@gmail.co");
    lcd.locate(0,3);
    lcd.printf("  Cell: 0991439123  ");
    wait(5);

    for(i=0; i<5; i++) {
        wait(0.1);
        lcd.cls();
    }

    //pc.printf("Angel D. Yaguana...\r\n");
    //pc.printf("Proyecto Datafast de la vida...\r\n");
    //pc.printf("Artista: Patricio Barberan\r\n");

    lcd.locate(0,0);
    lcd.printf(" Proyecto \"Datafast\" ");
    lcd.locate(0,1);
    lcd.printf("  Patricio Barberan  ");
    wait(2);
    lcd.locate(0,3);
    lcd.printf("    Iniciando...    ");
    wait(3);

    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Conecte una memoria ");
    lcd.locate(0,1);
    lcd.printf("USB para ingresar la");
    lcd.locate(0,2);
    lcd.printf("nueva configuracion!");
    wait(5);
    led1=led2=led3=led4=0;
    led5=led6=led7=led8=0;


    USBHostMSD msd("host");

    lcd.cls();
    lcd.locate(0,1);
    lcd.printf("  Buscando");

    for(i=0; i<5; i++) {
        wait(0.5);
        msd.connect();
        lcd.printf(".");
    }

    if(msd.connected()) {
        wait(1);
        lcd.printf("!");
        led1=led2=led3=led4=1;
        led5=led6=led7=led8=1;
        wait(1);
        lcd.cls();
        lcd.locate(0,1);
        lcd.printf("      USB Stick     ");
        lcd.locate(0,2);
        lcd.printf("     encontrado!    ");
        wait(1);
    }
    led1=led2=led3=led4=0;
    led5=led6=led7=led8=0;

    if(!msd.connected()) {
        lcd.printf("?");
        wait(1);
        lcd.cls();
        lcd.locate(0,1);
        lcd.printf("      USB Stick     ");
        lcd.locate(0,2);
        lcd.printf("    No encontrado!  ");
        wait(1);
    }
    led1=led2=led3=led4=0;
    led5=led6=led7=led8=0;

    if(msd.connected()) {
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Generando archivo de");
        lcd.locate(0,1);
        lcd.printf("ayuda en menoria USB");
        wait(1);
        FILE *fp1;
        if ((fp1 = fopen( "/host/Manual de ayuda.rtf", "w"))!=NULL) {
            fprintf(fp1,"Archivos de configuracion:");//Start:14-03-2013  08:30:00
            fprintf(fp1,"\r\n\r\nClock.txt\r\n\r\n\r\n");
            fprintf(fp1,"Contenido:\r\n\r\n");
            fprintf(fp1,"Start:14-03-2013  08:30:00\r\n");
            fprintf(fp1,"End:01-12-2013  22:30:00\r\n");
            fprintf(fp1,"Speed:80\r\n");
            fprintf(fp1,"Sense:30\r\n");
            fprintf(fp1,"Space:90\r\n");
            fprintf(fp1,"\r\nExplicacion:\r\n\r\n");
            fprintf(fp1,"Start:(Fecha de inicio)  (hora de inicio diaria)\r\n");
            fprintf(fp1,"End:(Fecha de finalizacion)  (hora de finalizacion diaria)\r\n");
            fprintf(fp1,"Speed:(porcentaje de velocidad de desplazamiento del cuadro)\r\n");
            fprintf(fp1,"Sense:(Intervalo en segundos entre detecciones)\r\n");
            fprintf(fp1,"Space:(Distancia entre 30 y 300 para deteccion)\r\n");
            fprintf(fp1,"\r\n\r\n\r\nTimer.txt\r\n\r\n\r\n");
            fprintf(fp1,"Contenido:\r\n\r\n");
            fprintf(fp1,"7  29-05-2013  17:35:00\r\n");
            fprintf(fp1,"\r\nExplicacion:\r\n\r\n");
            fprintf(fp1,"7:(Dia de la semana)\r\n");
            fprintf(fp1,"29-05-2013:(Fecha actual para cargar)\r\n");
            fprintf(fp1,"17:35:00:(Hora actual para cargar)\r\n");
            fprintf(fp1,"\r\nFirmware propiedad de:\r\n");
            fprintf(fp1,"Angel D. Yaguana H. & Ivan A. Sanchez\r\n");
            fprintf(fp1,"All Power Microcontroller Litoral.\r\n");
            fprintf(fp1,"Los Rios 2912 y Letamendi\r\n");
            fprintf(fp1,"Cell: 0992430921-0991439123-0989200942\r\n");
            fprintf(fp1,"Email: apm.litoral@gmail.com\r\n");
            //pc.printf("\r\nPrint Help OK\r\n");
            fclose(fp1);
            lcd.locate(0,2);
            lcd.printf("       Listo!      ");
            wait(1);
        } else {
            //pc.printf("\r\nPrint Help fail\r\n");
            lcd.locate(0,2);
            lcd.printf("       Error!      ");
            wait(1);
        }

        FILE *binary = fopen("/host/All Power Microcontroller Litoral.html", "w");
        while (a<=229) {
            fprintf(binary,(const char *)&page[a]);
            a++;
        }
        fclose(binary);

        FILE *octal = fopen("/host/Status Bio_Os.rtf", "w");
        while (b<=976) {
            fprintf(octal,(const char *)&data_Os[b]);
            b++;
        }
        fclose(octal);

        FILE *fp2 = fopen( "/host/Clock_ejemplo.txt", "w");
        fprintf(fp1,"Start:14-03-2013  08:30:00\r\n");
        fprintf(fp1,"End:01-12-2013  22:30:00\r\n");
        fprintf(fp1,"Speed:80\r\n");
        fprintf(fp1,"Sense:30\r\n");
        fprintf(fp1,"Space:90\r\n");
        fclose(fp1);

        FILE *fp3 = fopen( "/host/Timer_ejemplo.txt", "w");
        fprintf(fp1,"7  29-05-2013  17:35:00\r\n");
        fclose(fp1);
    }
    led1=led2=led3=led4=0;
    led5=led6=led7=led8=0;



    if(msd.connected()) {
        flag_usb_1=1;
        lcd.cls();
        lcd.locate(0,1);
        lcd.printf(" Actualizando Reloj ");
        my1307.gettime( &sec, &min, &hours, &day, &date, &month, &year);
        wait(1);
        FILE *fp2;
        if ((fp2 = fopen( "/host/Clock.txt", "r"))!=NULL) {
            fscanf(fp2,"%2d %2d-%2d-20%2d %2d:%2d:%2d",&new_day,&new_date,&new_mont,&new_year,&new_hour,&new_min,&new_sec);
            lcd.locate(0,2);
            lcd.printf("       Listo!      ");
            //pc.printf("USB Time: %2d %2d/%2d/20%2d %2d:%2d:%2d\r\n",new_day,new_date,new_mont,new_year,new_hour,new_min,new_sec);
            wait(1);

            Set_Time( new_sec, new_min, new_hour, new_day, new_date, new_mont, new_year);    // Set the time on the DS1307
            //pc.printf("Old Time: %2d %2d/%2d/20%2d %2d:%2d:%2d\r\n",day,date,month,year,hours,min,sec);
            lcd.locate(0,0);
            lcd.printf("Temporizador actual");
            lcd.locate(0,1);
            lcd.printf(" %02d-%02d-%02d  %02d:%02d:%02d ",date,month,year,hours,min,sec);

            my1307.gettime( &sec, &min, &hours, &day, &date, &month, &year);
            //pc.printf("New Time: %2d %2d/%2d/20%2d %2d:%2d:%2d\r\n",day,date,month,year,hours,min,sec);
            lcd.locate(0,2);
            lcd.printf("Temporizador nuevo ");
            lcd.locate(0,3);
            lcd.printf(" %02d-%02d-%02d  %02d:%02d:%02d ",date,month,year,hours,min,sec);
            wait(5);
            //pc.printf("\r\nTime Uploaded succesfully!\r\n");
            fclose(fp2);
            wait(1);
        } else {
            my1307.gettime( &sec, &min, &hours, &day, &date, &month, &year);
            //pc.printf("Time: %2d %2d-%2d-20%2d %2d:%2d:%2d\r\n",day,date,month,year,hours,min,sec);
            lcd.cls();
            lcd.locate(0,2);
            lcd.printf("       Error!      ");
            wait(1);
        }
    }
    led1=led2=led3=led4=0;
    led5=led6=led7=led8=0;


    if(msd.connected()) {
        flag_usb_2=1;
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("    Configurando    ");
        lcd.locate(0,1);
        lcd.printf("    temporizador    ");

        FILE *fp2;
        if ((fp2 = fopen( "/host/Timer.txt", "r"))!=NULL) {
            fscanf(fp2,"Start:%2d-%2d-20%2d %2d:%2d:%2d End:%2d-%2d-20%2d %2d:%2d:%2d Speed:%d Sense:%d Space:%d",&set_start_date,&set_start_month,&set_start_year,&set_start_hour,&set_start_min,&set_start_sec,&set_end_date,&set_end_month,&set_end_year,&set_end_hour,&set_end_min,&set_end_sec,&set_speed,&set_sense,&set_space);
            lcd.locate(0,1);
            lcd.printf("       Listo!     ");
            //pc.printf( "Start:%2d/%2d/20%2d %2d:%2d:%2d End:%2d/%2d/20%2d %2d:%2d:%2d Speed:%3d Sense:%3d Space:%3d\n",set_start_date,set_start_month,set_start_year,set_start_hour,set_start_min,set_start_sec,set_end_date,set_end_month,set_end_year,set_end_hour,set_end_min,set_end_sec,set_speed,set_sense,set_space);

            my1307.write( 0x08, set_start_date);
            my1307.write( 0x09, set_start_month);
            my1307.write( 0x0A, set_start_year);
            my1307.write( 0x0B, set_start_hour);
            my1307.write( 0x0C, set_start_min);
            my1307.write( 0x0D, set_start_sec);

            my1307.write( 0x0E, set_end_date);
            my1307.write( 0x0F, set_end_month);
            my1307.write( 0x10, set_end_year);
            my1307.write( 0x11, set_end_hour);
            my1307.write( 0x12, set_end_min);
            my1307.write( 0x13, set_end_sec);

            my1307.write( 0x14, set_speed);
            my1307.write( 0x15, set_sense);
            my1307.write( 0x16, set_space);

            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("F.Inicio: %02d-%02d-20%02d",set_start_date,set_start_month,set_start_year);
            lcd.locate(0,1);
            lcd.printf("F.Fin   : %02d-%02d-20%02d",set_end_date,set_end_month,set_end_year);
            lcd.locate(0,2);
            lcd.printf("H.Inicio:   %02d:%02d:%02d",set_start_hour,set_start_min,set_start_sec);
            lcd.locate(0,3);
            lcd.printf("H.Fin   :   %02d:%02d:%02d",set_end_hour,set_end_min,set_end_sec);
            wait(5);

            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("Configuracion nueva");
            lcd.locate(0,1);
            lcd.printf("Velocidad    :  %3d%",set_speed);
            lcd.locate(0,2);
            lcd.printf("Sencibilidad :  %3d%",set_sense);
            lcd.locate(0,3);
            lcd.printf("Distancia max:  %3d",set_space);
            wait(5);
            //pc.printf("\nSet Timer succesfully\n");
            fclose(fp2);
        } else {
            //pc.printf("Set Timer fail\n");
            lcd.cls();
            lcd.locate(0,2);
            lcd.printf("       Error!      ");
            wait(1);
        }
    }
    led1=led2=led3=led4=0;
    led5=led6=led7=led8=0;


    lcd.cls();
    lcd.locate(0,1);
    lcd.printf("Iniciando aplicacion");
    wait(2);

    read_RAM();

    my1307.gettime( &sec, &min, &hours, &day, &date, &month, &year);
    my1307.read( 0x14, &Old_Speed_RAM);
    my1307.read( 0x15, &Old_sense_RAM);
    my1307.read( 0x16, &Old_Space_RAM);
    led1=led2=led3=led4=0;
    led5=led6=led7=led8=0;

    if(msd.connected()) {
        FILE *fp1;
        if ((fp1 = fopen( "/host/Registro.csv", "a"))!=NULL) {
            fprintf(fp1,"%2d    %2d/%2d/20%2d    %2d:%2d:%2d    %3d    %3d    %3d;\n",day,date,month,year,hours,min,sec,Old_Speed_RAM,Old_sense_RAM,Old_Space_RAM);
            //pc.printf( "Dia:%2d  Fecha:%2d/%2d/20%2d  Hora:%2d:%2d:%2d  Speed RAM:%3d  Sense RAM:%3d  Space RAM:%3d;\r\n",day,date,month,year,hours,min,sec,Old_Speed_RAM,Old_sense_RAM,Old_Space_RAM);
            //pc.printf("\r\nRegistro OK\r\n");
            fclose(fp1);
        } else {
            //pc.printf("\r\nRegistre fail\r\n");
            //pc.printf( "Dia:%2d  Fecha:%2d/%2d/20%2d  Hora:%2d:%2d:%2d  Speed RAM:%3d  Sense RAM:%3d  Space RAM:%3d;\r\n",day,date,month,year,hours,min,sec,Old_Speed_RAM,Old_sense_RAM,Old_Space_RAM);
        }
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("       Nueva        ");
        lcd.locate(0,1);
        lcd.printf("   configuracion    ");
        lcd.locate(0,2);
        lcd.printf("   satisfactoria    ");
        wait(3);
        lcd.cls();
        lcd.locate(0,1);
        lcd.printf("Por favor remueva la");
        lcd.locate(0,2);
        lcd.printf(" memoria USB ahora! ");
        wait(5);
    }
    led1=led2=led3=led4=0;
    led5=led6=led7=led8=0;


    //pc.printf("\r\nRun_app Start\r\n");
    /*
        PwmOut led1(LED1);
        PwmOut led2(LED2);
        PwmOut led3(LED3);
        PwmOut led4(LED4);
    */
    led1=led2=led3=led4=0;
    led5=led6=led7=led8=0;
    wait(0.5);

    FW=0;
    RW=0;
    lcd.cls();
    int lcd_reset=0;

    while(1) {
/*
        if(FLAG_DOOR_OFF==1) {
            FLAG_DOOR_OFF=0;
            lcd.locate(0,1);
            lcd.printf("  Cerrando  puerta  ");
            wait(2);
        }

        if(FLAG_DOOR_ON==1) {
            FLAG_DOOR_ON=0;
            lcd.locate(0,1);
            lcd.printf("  Abriendo  puerta  ");
            wait(2);
        }

        if(FLAG_NEW_PASS==1) {
            FLAG_NEW_PASS=0;
            lcd.locate(0,1);
            lcd.printf("    Nueva clave    ");
            wait(2);
        }

        if(FLAG_PUT_PASS==1) {
            FLAG_PUT_PASS=0;
            lcd.locate(0,1);
            lcd.printf("   Ingrese clave   ");
            wait(2);
        }

        if(FLAG_NEW_PASS_FULL==1) {
            FLAG_NEW_PASS_FULL=0;
            lcd.locate(0,1);
            lcd.printf("    Nueva clave    ");
            lcd.locate(0,2);
            lcd.printf("guardada en memoria!");
            wait(2);
        }
*/
        if(lcd_reset<=65535) {
            if(lcd_reset==65535) {
                lcd_reset=0;
                TextLCD lcd(p11, p12, p13, p14, p15, p16, TextLCD::LCD20x4); // rs, e, d4-d7
                wait(0.10);
                lcd.cls();
                wait(0.10);
            }
        }

        lcd_reset++;

        wait(0.25);
        //pc.printf("\r\nObstaculo 1: %8.6fcm\n",get_Z4());
        my1307.gettime( &sec, &min, &hours, &day, &date, &month, &year);
        //pc.printf("RTC: [%2d:%.2d:%2d   %2d/%2d/20%2d]\n",hours,min,sec,date,month,year);
        Radar=get_Z4();

        lcd.locate(0,3);
        lcd.printf("Deteccion: %3.3fcm  ",Radar);
        lcd.locate(0,0);
        lcd.printf(" %02d-%02d-%02d  %02d-%02d-%02d ",get_start_date_ram, get_start_month_ram, get_start_year_ram, get_end_date_ram,get_end_month_ram,get_end_year_ram);
        lcd.locate(0,1);
        lcd.printf(" %02d:%02d:%02d  %02d:%02d:%02d ",get_start_hour_ram, get_start_min_ram, get_start_sec_ram,get_end_hour_ram,get_end_min_ram,get_end_sec_ram);
        lcd.locate(0,2);
        lcd.printf(" %02d-%02d-%02d  %02d:%02d:%02d ",date,month,year,hours,min,sec);

        int time_sec_onclock = 0, time_sec_start = 0, time_sec_end = 0;

        time_sec_onclock = (hours*60*60)+(min*60)+sec;
        time_sec_start = (get_start_hour_ram*60*60)+(get_start_min_ram*60)+get_start_sec_ram;
        time_sec_end = (get_end_hour_ram*60*60)+(get_end_min_ram*60)+get_end_sec_ram;

        float time_day_onclock = 0,time_day_start = 0,time_day_end = 0;

        time_day_onclock = (month*30.4166)-30.4166+date;
        time_day_start = (get_start_month_ram*30.4166)-30.4166+get_start_date_ram;
        time_day_end = (get_end_month_ram*30.4166)-30.4166+get_end_date_ram;

        if(time_day_onclock<=time_day_end && time_day_onclock>=time_day_start) {
            if(time_sec_onclock<time_sec_end && time_sec_onclock>time_sec_start) {
                //ejecucion de sensor de obstaculos
                if(Radar<=get_space_ram*1.5) {
                    //pc.printf("Obstaculo 2: %8.6fcm\n",Radar);
                    lcd.locate(0,2);
                    lcd.printf("   Detectando...!   ");
                    wait(1-sense_ram_powten_3);
                    Radar=get_Z4();
                    if(Radar<=get_space_ram) {
                        lcd.locate(0,2);
                        lcd.printf(" Desplazando cuadro ");
                        //pc.printf("Obstaculo 3: %8.6fcm\n",Radar);
                        led1=1;
                        led5=1;
                        led2=0;
                        led6=0;
                        led3=0;
                        led7=0;
                        led4=0;
                        led8=0;
                        wait(0.025);
                        led1=0;
                        led5=0;
                        led2=1;
                        led6=1;
                        led3=0;
                        led7=0;
                        led4=0;
                        led8=0;
                        wait(0.025);
                        led1=0;
                        led5=0;
                        led2=0;
                        led6=0;
                        led3=1;
                        led7=1;
                        led4=0;
                        led8=0;
                        wait(0.025);
                        do {
                            FW=1;
                            RW=0;
                            led1=0;
                            led5=0;
                            led2=0;
                            led6=0;
                            led3=0;
                            led7=0;
                            led4=1;
                            led8=1;
                            lcd.locate(0,3);
                            lcd.printf(">>> >>> >>> >>> >>> ");
                            wait(0.025);
                            led1=0;
                            led5=0;
                            led2=0;
                            led6=0;
                            led3=1;
                            led7=1;
                            led4=0;
                            led8=0;
                            lcd.locate(0,3);
                            lcd.printf(" >>> >>> >>> >>> >>>");
                            wait(0.025);
                            led1=0;
                            led5=0;
                            led2=1;
                            led6=1;
                            led3=0;
                            led7=0;
                            led4=0;
                            led8=0;
                            lcd.locate(0,3);
                            lcd.printf("> >>> >>> >>> >>> >>");
                            wait(0.025);
                            led1=1;
                            led5=1;
                            led2=0;
                            led6=0;
                            led3=0;
                            led7=0;
                            led4=0;
                            led8=0;
                            lcd.locate(0,3);
                            lcd.printf(">> >>> >>> >>> >>> >");
                            wait(0.025);
                            rigth=rigth_sense.read();
                        } while(rigth<1);
                        //pc.printf("\r\nRIGHT_______: %8.6f\n",rigth);
                        FW=0;
                        RW=0;
                        wait(0.025);
                        led1=0;
                        led5=0;
                        led2=0;
                        led6=0;
                        led3=1;
                        led7=1;
                        led4=0;
                        led8=0;
                        wait(0.025);
                        led1=0;
                        led5=0;
                        led2=1;
                        led6=1;
                        led3=0;
                        led7=0;
                        led4=0;
                        led8=0;
                        wait(0.025);
                        //wait(3-sense_ram_powten_3);
                        do {
                            FW=0;
                            RW=1;
                            led1=1;
                            led5=1;
                            led2=0;
                            led6=0;
                            led3=0;
                            led7=0;
                            led4=0;
                            led8=0;
                            lcd.locate(0,3);
                            lcd.printf("<<< <<< <<< <<< <<< ");
                            wait(0.025);
                            led1=0;
                            led5=0;
                            led2=0;
                            led6=0;
                            led3=0;
                            led7=0;
                            led4=1;
                            led8=1;
                            lcd.locate(0,3);
                            lcd.printf(" <<< <<< <<< <<< <<<");
                            wait(0.025);
                            led1=0;
                            led5=0;
                            led2=0;
                            led6=0;
                            led3=1;
                            led7=1;
                            led4=0;
                            led8=0;
                            lcd.locate(0,3);
                            lcd.printf("< <<< <<< <<< <<< <<");
                            wait(0.025);
                            led1=0;
                            led5=0;
                            led2=1;
                            led6=1;
                            led3=0;
                            led7=0;
                            led4=0;
                            led8=0;
                            lcd.locate(0,3);
                            lcd.printf("<< <<< <<< <<< <<< <");
                            wait(0.025);
                            left=left_sense.read();
                        } while(left<1);
                        //pc.printf("\r\nLEFT_______: %8.6f\n",left);
                        FW=0;
                        RW=0;
                        //wait(1-sense_ram_powten_3);
                        led1=led2=led3=led4=0;
                        led5=led6=led7=led8=0;
                    }
                }
            }
        }
    }

}

float get_Z4()
{
    prom=0;
    cnt_Z4=0;
    result=0;
    for(interval=0; interval<5; interval++) {
        wait(1/20);
        adc = ain.read();           // read analog as a float
        if(adc >= 0 && adc <= 0.508) {
            cm5  = ((adc * 5)*2.54)*100;
            prom=prom+(cm5-10);
            cnt_Z4++;
        }
    }
    result=prom/cnt_Z4;
    //pc.printf("#:%2d  P:%5.3f  D:%3.3f cm\n", cnt_Z4, prom, result);
    //led1=led2=led3=led4=1;led5=led6=led7=led8=1;
    //wait(1/20);
    return result;
}


void read_RAM()
{
    lcd.cls();
    lcd.locate(0,1);
    lcd.printf("Leyendo datos desde");
    lcd.locate(0,2);
    lcd.printf("la memoria...");
    wait(1);

    //pc.printf("\r\nVariables leidas:\r\n");

    my1307.read( 0x08, &get_start_date_ram);
    my1307.read( 0x09, &get_start_month_ram);
    my1307.read( 0x0A, &get_start_year_ram);
    my1307.read( 0x0B, &get_start_hour_ram);
    my1307.read( 0x0C, &get_start_min_ram);
    my1307.read( 0x0D, &get_start_sec_ram);

    my1307.read( 0x0E, &get_end_date_ram);
    my1307.read( 0x0F, &get_end_month_ram);
    my1307.read( 0x10, &get_end_year_ram);
    my1307.read( 0x11, &get_end_hour_ram);
    my1307.read( 0x12, &get_end_min_ram);
    my1307.read( 0x13, &get_end_sec_ram);

    my1307.read( 0x14, &get_speed_ram);
    my1307.read( 0x15, &get_sense_ram);
    my1307.read( 0x16, &get_space_ram);

    //pc.printf( "Start:%2d/%2d/20%2d %2d:%2d:%2d \r\nEnd:%2d/%2d/20%2d %2d:%2d:%2d \r\nSpeed:%3d \r\nSense:%3d \r\nSpace:%3d\r\n",get_start_date_ram,get_start_month_ram,get_start_year_ram,get_start_hour_ram,get_start_min_ram,get_start_sec_ram,get_end_date_ram,get_end_month_ram,get_end_year_ram,get_end_hour_ram,get_end_min_ram,get_end_sec_ram,get_speed_ram,get_sense_ram,get_space_ram);
    if(flag_usb_1 == 0 && flag_usb_2 ==0) {
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("F.Inicio: %02d-%02d-20%02d",get_start_date_ram,get_start_month_ram,get_start_year_ram);
        lcd.locate(0,1);
        lcd.printf("F.Fin   : %02d-%02d-20%02d",get_end_date_ram,get_end_month_ram,get_end_year_ram);
        lcd.locate(0,2);
        lcd.printf("H.Inicio:   %02d:%02d:%02d",get_start_hour_ram,get_start_min_ram,get_start_sec_ram);
        lcd.locate(0,3);
        lcd.printf("H.Fin   :   %02d:%02d:%02d",get_end_hour_ram,get_end_min_ram,get_end_sec_ram);
        wait(5);

        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Configuracion actual");
        lcd.locate(0,1);
        lcd.printf("Velocidad    :  %3d%",get_speed_ram);
        lcd.locate(0,2);
        lcd.printf("Sencibilidad :  %3d%",get_sense_ram);
        lcd.locate(0,3);
        lcd.printf("Distancia max:  %3d",get_space_ram);
        wait(5);
    }
    if (get_speed_ram<100) {
        speed_ram_powten_3 = get_speed_ram%100;
        speed_ram_powten_3 = speed_ram_powten_3/100;
    } else
        speed_ram_powten_3 = get_speed_ram/get_speed_ram;

    if (get_sense_ram<100) {
        sense_ram_powten_3 = get_sense_ram%100;
        sense_ram_powten_3 = sense_ram_powten_3/100;
    } else
        sense_ram_powten_3 = get_sense_ram/get_sense_ram;

    //pc.printf("\r\nSpeed result: %f\r\n",speed_ram_powten_3);
    //pc.printf("Sense result: %f\r\n",sense_ram_powten_3);
    //pc.printf("Space result: %d\r\n",get_space_ram);
    //pc.printf("/******************************************************************************************************************/\r\n");
}


void Set_Time(int set_sec, int set_min, int set_hours, int set_day, int set_date, int set_month, int set_year)
{
    my1307.twentyfour_hour();
    my1307.settime( set_sec, set_min, set_hours, set_day, set_date, set_month, set_year);    // Set the time on the DS1307
    my1307.write(0x07,0x10);
}



uint32_t cbAfterInput(uint32_t index)
{
    //lcd.printf("TEST\n");
    ////pc.printf("Indice: %d\n", index);
    ////pc.printf("Tecla:  %c\n", Keytable[index]);
    //led3!=led3;

    if (index == 12 || cnt>=5) {
        ////pc.printf("cnt:%i\n",cnt);
        if(cnt==5) {
            FLAG_NEW_PASS=1;
        }
        led1=1;
        led5=1; //Show that we are alive
        wait(0.5);
        led1=0;
        led5=0;
        cnt++;
        if (cnt>=7 && j<=6) {
            ////pc.printf("Index2:%d ===> Key2:%c\n", index, Keytable[index]);
            j++;
            my1307.write( 24+j, index);
            led2=1;
            led6=1; //Show that we are alive
            wait(0.2);
            led2=0;
            led6=0;

            my1307.read( 24+j, &key);
            ////pc.printf("J:%d, Key EEprom:%d, cnt:%i\n",j, key,cnt);

            if(j==6) {
                FLAG_NEW_PASS_FULL=1;
                ////pc.printf("New Pass was completed\n");
                j=0;
                cnt=1;
                led1=led2=led3=led4=1;
                led5=led6=led7=led8=1;
                wait(3);
                led1=led2=led3=led4=0;
                led5=led6=led7=led8=0;

            }
        }
    } else if (index == 14 || pass>0) {
        FLAG_PUT_PASS=1;
        ////pc.printf("index:%i, pass:%i\n", index,pass);
        led1=1;
        led5=1; //Show that we are alive
        wait(0.5);
        led1=0;
        led5=0;
        pass++;
        if (pass>1 && l<=6) {
            data[pass-2]= index;
            ////pc.printf("J:%d, data[%d] = %d;\n", l, pass-2, index);
            led2=1;
            led6=1; //Show that we are alive
            wait(0.2);
            led2=0;
            led6=0;

            l++;
            if(l==6) {
                ////pc.printf("Pass was completed\n");
                l=0;
                pass=0;
                //comprobar clave
                my1307.read( 25, &key0);
                my1307.read( 26, &key1);
                my1307.read( 27, &key2);
                my1307.read( 28, &key3);
                my1307.read( 29, &key4);
                my1307.read( 30, &key5);

                if(data[0]==key0 && data[1]==key1 && data[2]==key2 && data[3]==key3 && data[4]==key4 && data[5]==key5) {
                    led1=led3=1;
                    led5=led7=1;
                    door_off = 1;
                    wait(1.200);
                    door_off = 0;
                    FLAG_DOOR_OFF=1;
                    ////pc.printf("Door OPEN\n");
                    wait(2);
                    led1=led3=0;
                    led5=led7=0;
                } else {
                    led2=led4=1;
                    led6=led8=1;
                    door_on = 1;
                    wait(1.200);
                    door_on = 0;
                    FLAG_DOOR_ON=1;
                    ////pc.printf("Door Closed\n");
                    wait(2);
                    led2=led4=0;
                    led6=led8=0;
                }
            }
        }
    }

    return 0;
}
