#ifndef MBED_GENERATOR_RGB_H
#define MBED_GENERATOR_RGB_H

#include "mbed.h"

class Generator_RGB {
public:

    Generator_RGB();
    virtual unsigned int RGB888_to_RGB565 (unsigned long rgb,const char* color);
    virtual unsigned int RGB565CONVERT(int r,int g,int b,const char* color);
};

#endif

/*
Example:

#include "mbed.h"
#include "Generator_RGB.h"

Serial pc(USBTX,USBRX);
Generator_RGB rgb;

int main() {
    //Para usar colores mediante variables:
    //long color = rgb.RGB888_to_RGB565(0x0000ff,"BRIGHTBLUE");
    //pc.printf("Color en RGB565 es 0x%0.4X\n",color);

    rgb.RGB888_to_RGB565(0x0000ff,"BRIGHTBLUE");
    rgb.RGB565CONVERT(0,0,0,"NEGRO");
    rgb.RGB565CONVERT(0,0,255,"BRIGHTBLUE");
    rgb.RGB565CONVERT(0,255,0,"BRIGHTGREEN");
    rgb.RGB565CONVERT(0,255,255,"BRIGHTCYAN");
    rgb.RGB565CONVERT(255,0,0,"BRIGHTRED");
    rgb.RGB565CONVERT(255,0,255,"BRIGHTMAGENTA");
    rgb.RGB565CONVERT(255,255,0,"BRIGHTYELLOW");
    rgb.RGB565CONVERT(0,0,128,"AZUL");
    rgb.RGB565CONVERT(0,128,0,"VERDE");
    rgb.RGB565CONVERT(0,128,128,"CIAN");
    rgb.RGB565CONVERT(128,0,0,"ROJO");
    rgb.RGB565CONVERT(128,0,128,"MAGENTA");
    rgb.RGB565CONVERT(255,128,0,"BROWN");
    rgb.RGB565CONVERT(128,128,128,"gris_claro");
    rgb.RGB565CONVERT(64,64,64,"gris_oscuro");
    rgb.RGB565CONVERT(128,128,255,"lightblue");
    rgb.RGB565CONVERT(128,255,128,"verde_claro");
    rgb.RGB565CONVERT(128,255,255,"LIGHTCYAN");
    rgb.RGB565CONVERT(255,128,128,"LIGHTRED");
    rgb.RGB565CONVERT(255,128,255,"LIGHTMAGENTA");
    rgb.RGB565CONVERT(255,255,128,"AMARILLO");
    rgb.RGB565CONVERT(255,255,255,"BLANCO");
    rgb.RGB565CONVERT(224,224,224,"GRAY0");
    rgb.RGB565CONVERT(192,192,192,"GRAY1");
    rgb.RGB565CONVERT(160,160,160,"GRAY2");
    rgb.RGB565CONVERT(128,128,128,"GRAY3");
    rgb.RGB565CONVERT(96,96,96,"GRAY4");
    rgb.RGB565CONVERT(64,64,64,"GRAY5");
    rgb.RGB565CONVERT(32,32,32,"GRAY6");
    rgb.RGB565CONVERT(51,51,51,"GRAY20");
    rgb.RGB565CONVERT(102,102,102,"GRAY40");
    rgb.RGB565CONVERT(204,204,204,"GRAY80");
    rgb.RGB565CONVERT(229,229,229,"GRAY90");
    rgb.RGB565CONVERT(242,242,242,"GRAY95");
    rgb.RGB565CONVERT(139,0,0,"RED4");
    rgb.RGB565CONVERT(255,48,48,"FIREBRICK1");
    rgb.RGB565CONVERT(0,100,0,"DARKGREEN");
    rgb.RGB565CONVERT(152,251,152,"PALEGREEN");
    rgb.RGB565CONVERT(238,221,130,"LIGHTYELLOW");
    rgb.RGB565CONVERT(255,215,0,"GOLD");
    rgb.RGB565CONVERT(255,140,0,"DARKORANGE");
}



Output:

#define  BRIGHTBLUE      0x001F
#define  NEGRO      0x0000
#define  BRIGHTBLUE      0x001F
#define  BRIGHTGREEN      0x07E0
#define  BRIGHTCYAN      0x07FF
#define  BRIGHTRED      0xF800
#define  BRIGHTMAGENTA      0xF81F
#define  BRIGHTYELLOW      0xFFE0
#define  AZUL      0x0010
#define  VERDE      0x0400
#define  CIAN      0x0410
#define  ROJO      0x8000
#define  MAGENTA      0x8010
#define  BROWN      0xFC00
#define  gris_claro      0x8410
#define  gris_oscuro      0x4208
#define  lightblue      0x841F
#define  verde_claro      0x87F0
#define  LIGHTCYAN      0x87FF
#define  LIGHTRED      0xFC10
#define  LIGHTMAGENTA      0xFC1F
#define  AMARILLO      0xFFF0
#define  BLANCO      0xFFFF
#define  GRAY0      0xE71C
#define  GRAY1      0xC618
#define  GRAY2      0xA514
#define  GRAY3      0x8410
#define  GRAY4      0x630C
#define  GRAY5      0x4208
#define  GRAY6      0x2104
#define  GRAY20      0x3186
#define  GRAY40      0x632C
#define  GRAY80      0xCE79
#define  GRAY90      0xE73C
#define  GRAY95      0xF79E
#define  RED4      0x8800
#define  FIREBRICK1      0xF986
#define  DARKGREEN      0x0320
#define  PALEGREEN      0x9FD3
#define  LIGHTYELLOW      0xEEF0
#define  GOLD      0xFEA0
#define  DARKORANGE      0xFC60


*/