#ifndef MBED_SDFILESYSTEM_H
#define MBED_SDFILESYSTEM_H

#include "mbed.h"
#include "FATFileSystem.h"

extern "C" void mbed_reset();

class SDFileSystem : public FATFileSystem {
public:

    SDFileSystem(PinName mosi, PinName miso, PinName sclk, PinName cs, const char* name);
    virtual int disk_initialize();
    void init_bios();
    virtual int disk_write(const char *buffer, int block_number);
    virtual int disk_read(char *buffer, int block_number);    
    virtual int disk_status();
    virtual int disk_sync();
    virtual int disk_sectors();

protected:

    int _cmd(int cmd, int arg);
    int _cmdx(int cmd, int arg);
    int _cmd8();
    int _cmd58();
    int initialise_card();
    int initialise_card_v1();
    int initialise_card_v2();
    
    int _read(char *buffer, int length);
    int _write(const char *buffer, int length);
    int _sd_sectors();
    int _sectors;
    
    SPI _spi;
    DigitalOut _cs;     
};

#endif
