#include "mbed.h"
#include "CAN.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
CAN can1(p9, p10);
CAN can2(p30, p29);
Serial pc(USBTX,USBRX); //tx. rx

int main()
{
    char a[8] = {0x6D,0x62,0x65,0x64,0x00,0x00,0x00,0x00};
    char b[5] = "hola";
    char c[8] = {"1234567"};
    const char d[8] = {0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x00};
    CANMessage msg;
    pc.baud(9600);
    can1.frequency(125000);
    can2.frequency(125000);
    while(1) {
        if(can1.read(msg))
            led1 = 1;
        if(can2.read(msg))
            led2 = 1;

        /***********inicio de comunicacion CAN1 -> CAN2 ****************************/
        pc.printf("************************************\n\r");
        can1.write(CANMessage(01, &a[0], 8));
        pc.printf("write a: %s    ",&a[0]);
        if(can2.read(msg)) {
            led1 = 1;led2 = 0;led3 = 0;led4 = 0;
            pc.printf("read a:-%s-\n",&msg.data[0]);
        }
        else {
        printf("CAN1 RD error: %d, TD error: %d\r\n", can1.rderror(), can1.tderror() );
        printf("CAN2 RD error: %d, TD error: %d\r\n", can2.rderror(), can2.tderror() );
        }
        
        can1.write(CANMessage(01, &b[0], 4));
        pc.printf("write b: %s    ",&b[0]);
        if(can2.read(msg)) {
            led1 = 0;led2 = 1;led3 = 0;led4 = 0;
            pc.printf("read b:-%s-\n",&msg.data[0]);
        }
        else {
        printf("CAN1 RD error: %d, TD error: %d\r\n", can1.rderror(), can1.tderror() );
        printf("CAN2 RD error: %d, TD error: %d\r\n", can2.rderror(), can2.tderror() );
        }
        
        can1.write(CANMessage(01, &c[0], 8));
        pc.printf("write c: %s    ",&c[0]);
        if(can2.read(msg)) {
            led1 = 0;led2 = 0;led3 = 1;led4 = 0;
            pc.printf("read c:-%s-\n",&msg.data[0]);
        }
        else {
        printf("CAN1 RD error: %d, TD error: %d\r\n", can1.rderror(), can1.tderror() );
        printf("CAN2 RD error: %d, TD error: %d\r\n", can2.rderror(), can2.tderror() );
        }
        
        can1.write(CANMessage(01, &d[0], 8));
        pc.printf("write d: %s    ",&d[0]);
        if(can2.read(msg)) {
            led1 = 0;led2 = 0;led3 = 0;led4 = 1;
            pc.printf("read d:-%s-\n",&msg.data[0]);
        }
        else {
        printf("CAN1 RD error: %d, TD error: %d\r\n", can1.rderror(), can1.tderror() );
        printf("CAN2 RD error: %d, TD error: %d\r\n", can2.rderror(), can2.tderror() );
        }
        
        //wait(1);
        led1 = 0;led2 = 0;led3 = 0;led4 = 0;
        
        /************************fin**********************************/
        
        /***********inicio de comunicacion CAN2 -> CAN1 ****************************/
        pc.printf("************************************\n\r");
        can2.write(CANMessage(01, &a[0], 8));
        pc.printf("write a: %s    ",&a[0]);
        if(can1.read(msg)) {
            led1 = 0;led2 = 0;led3 = 0;led4 = 1;
            pc.printf("read a:-%s-\n",&msg.data[0]);
        }
        else {
        printf("CAN1 RD error: %d, TD error: %d\r\n", can1.rderror(), can1.tderror() );
        printf("CAN2 RD error: %d, TD error: %d\r\n", can2.rderror(), can2.tderror() );
        }
        
        can2.write(CANMessage(01, &b[0], 4));
        pc.printf("write b: %s    ",&b[0]);
        if(can1.read(msg)) {
            led1 = 0;led2 = 0;led3 = 1;led4 = 0;
            pc.printf("read b:-%s-\n",&msg.data[0]);
        }
        else {
        printf("CAN1 RD error: %d, TD error: %d\r\n", can1.rderror(), can1.tderror() );
        printf("CAN2 RD error: %d, TD error: %d\r\n", can2.rderror(), can2.tderror() );
        }
        
        can2.write(CANMessage(01, &c[0], 8));
        pc.printf("write c: %s    ",&c[0]);
        if(can1.read(msg)) {
            led1 = 0;led2 = 1;led3 = 0;led4 = 0;
            pc.printf("read c:-%s-\n",&msg.data[0]);
        }
        else {
        printf("CAN1 RD error: %d, TD error: %d\r\n", can1.rderror(), can1.tderror() );
        printf("CAN2 RD error: %d, TD error: %d\r\n", can2.rderror(), can2.tderror() );
        }
        
        can2.write(CANMessage(01, &d[0], 8));
        pc.printf("write d: %s    ",&d[0]);
        if(can1.read(msg)) {
            led1 = 1;led2 = 0;led3 = 0;led4 = 0;
            pc.printf("read d:-%s-\n",&msg.data[0]);
        }
        else {
        printf("CAN1 RD error: %d, TD error: %d\r\n", can1.rderror(), can1.tderror() );
        printf("CAN2 RD error: %d, TD error: %d\r\n", can2.rderror(), can2.tderror() );
        }
        
        //wait(1);
        led1 = 0;led2 = 0;led3 = 0;led4 = 0;
        
        /************************fin**********************************/
    }
}


/*
        (NXP TJA 1051/3)
mbed    TJA1    TJA2
----------------------
5V      Vcc     Vcc
GND     GND     GND
p9      RXD     -
p10     TXD     -
p29     -       TXD
p30     -       RXD
-       CANL    CANL
-       CANH    CANH
3.3v    Vio     Vio

GND -> 60Ohm-CANL 
GND -> 60Ohm-CANH
GND -> 10KOhm-S-TJA1
GND -> 10KOhm-S-TJA2
*/