/*--------------------------------------------------------Reading Writing MIFARE Tags---------------------------------------------------------------

1.This program is for reading and writing from /to MIFARE Classic 1k ,MIFARE Ultralight MF0ICU1,MIFARE Ultralight NTAG213,MIFARE Ultralight NTAG203
2.Generally we are using MBED model WIZnet WIZWiki W7500 to interfacng with MFRC522 Rader and writer device using SPI protocol
3.This program is designed such a way that it will take input 1,2 for reading or writing from serial monitor
4.Once user can entering input based on input it will call read and write function respectively...

----------------------------------------------------------------------------------------------------------------------------------------------------*/

/*Test of cheap 13.56Mhz RFID-RC522 module
Connect as follows:
RFID pins        ->  WIZWiki-W7500 header CN5 (Arduino-compatible header)
--------------------------------------------------------------------------
1.RFID IRQ    ->   Not used. Leave open
2.RFID MISO   ->   WIZWiki-W7500 SPI_MISO     =D12
3.RFID MOSI   ->   WIZWiki-W7500 SPI_MOSI     =D11
4.RFID SCK    ->   WIZWiki-W7500 SPI_SCK      =D13
5.RFID SDA    ->   WIZWiki-W7500 SPI_CS       =D10
6.RFID RST    ->   WIZWiki-W7500              =D9
3.3V and Gnd to the respective pins
-------------------------------------------------------------------------*/




//Adding Library for Mbed
#include "mbed.h"
//Adding Library for MFRC522
#include "MFRC522.h"
//Adding Library for SPI protocol
#include "SPI.h"

//Define RFID version and date
#define VERSION "RFID_2017_03_20"
//Define board
#define BOARD "WIZWIKI_W7500"
//Adding Library for RFID tags read and Write
#include "RFIDRW.h"


// ARMmbed WIZwiki W7500 Pin for MFRC522 SPI Communication
#define SPI_MOSI    D11
#define SPI_MISO    D12
#define SPI_SCLK    D13
#define SPI_CS      D10

// WIZWiki-W7500 Pin for MFRC522 reset(pick another D pin if you need D8)
#define MF_RESET    D9

//Define led for identification
DigitalOut LedGreen(D7);

//Serial connection to cp for output
Serial cp(USBTX, USBRX);

//Creating MFRC522 class abject  and passing pin as a argument
MFRC522 RfChip(SPI_MOSI, SPI_MISO, SPI_SCLK, SPI_CS, MF_RESET);

/**
 * Dumps debug info about the selected PICC to Serial.
 * On success the PICC is halted after dumping the data.
 * For MIFARE Classic the factory default key of 0xFFFFFFFFFFFF is tried.
 */
//Declaring MIFARE Classic 1k key
MFRC522::MIFARE_Key key;

void DumpToSerial(MFRC522::Uid *uid)
{


    // Print Card UID
    printf("Card UID: ");
    for (uint8_t i = 0; i < RfChip.uid.size; i++) {
        printf(" %X", RfChip.uid.uidByte[i]);
    }
    printf("\n\r");

    // Print Card type
    uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
    printf("PICC Type: %s \n\r", RfChip.PICC_GetTypeName(piccType));
    wait_ms(50);

    // Dump contents
    switch (piccType) {
        case MFRC522::PICC_TYPE_MIFARE_MINI:
        case MFRC522::PICC_TYPE_MIFARE_1K:
        case MFRC522::PICC_TYPE_MIFARE_4K:
            // All keys are set to FFFFFFFFFFFFh at chip delivery from the factory.
            for (uint8_t i = 0; i < 6; i++) {
                key.keyByte[i] = 0xFF;
            }
            //Calling MIFARE Classic 1k memory block and sector
            DumpMifareClassicToSerial(uid, piccType, &key);
            break;

        case MFRC522::PICC_TYPE_MIFARE_UL:
            //Calling MIFARE Ultralight memory block,block data and sector,sector data
            DumpMifareUltralightToSerial();
            break;

        default:
            break; // No memory dump here
    }

    printf("\n\r");

    RfChip.PICC_HaltA(); // Instructs a PICC in state ACTIVE(*) to go to state HALT.
} // End PICC_DumpToSerial()


/**
 * Dumps memory contents of a MIFARE Ultralight PICC.
 */

//Create function for writting data
void WriteToRfidTag(MFRC522::Uid *uid)
{

    // Print Card UID
    printf("Card UID: ");
    for (uint8_t i = 0; i < RfChip.uid.size; i++) {
        printf(" %X", RfChip.uid.uidByte[i]);
    }
    printf("\n\r");

    // Print Card type
    uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
    printf("PICC Type: %s \n\r", RfChip.PICC_GetTypeName(piccType));
    wait_ms(50);

    // Dump contents
    switch (piccType) {
        case MFRC522::PICC_TYPE_MIFARE_MINI:
        case MFRC522::PICC_TYPE_MIFARE_1K:
        case MFRC522::PICC_TYPE_MIFARE_4K:
            // All keys are set to FFFFFFFFFFFFh at chip delivery from the factory.
            for (uint8_t i = 0; i < 6; i++) {
                key.keyByte[i] = 0xFF;
            }
            writeDataClassic1k(uid);  // WriteToRfidTag(&(RfChip.uid))
            break;

        case MFRC522::PICC_TYPE_MIFARE_UL:
            writeDataUL(uid);
            break;
        default:
            break; // No memory dump here
    }
    printf("\n\r");
}

int main()
{
    /* Set debug UART speed */
    printf("\n\rUART 9600 baud\n\r");
    cp.baud(9600);
    printf("\n\r%s %s\n\r",VERSION,BOARD);

    /* Init. RC522 Chip */
    RfChip.PCD_Init();

    /* Read RC522 version */
    uint8_t temp = RfChip.PCD_ReadRegister(MFRC522::VersionReg);
    printf("MFRC522 version: %d\n\r", temp);
    printf("\n\r");
    cp.printf("Enter 1 Reading \n");
    cp.printf("Enter 2 Writing \n");


    while(true) {

        LedGreen = 1;

        // Look for new cards
        if ( ! RfChip.PICC_IsNewCardPresent()) {
            wait_ms(50);
            continue;
        }
        LedGreen   = 0;
        wait_ms(50);
        // Select one of the cards
        if ( ! RfChip.PICC_ReadCardSerial()) {
            wait_ms(50);
            continue;
        }
        LedGreen = 1;
        wait_ms(50);
        char ch=cp.getc();
        if(ch=='1') {
            cp.printf("reading..........\n");
            // Dump debug info about the card. PICC_HaltA() is automatically called.
            DumpToSerial(&(RfChip.uid));
            wait_ms(20);
        } else if(ch=='2') {
            cp.printf("Writing..... \n");
            //Calling WriteToRfidTag()
            WriteToRfidTag(&(RfChip.uid));
            wait_ms(50);

        }

    }
}