#include "mbed.h"

#define EXAMPLE_TCPCLIENT
//#define EXAMPLE_TCPSERVER
//#define EXAMPLE_UDPTEST
//#define EXAMPLE_WIFITEST

//Serial pc(USBTX, USBRX);
extern void setup(void);
extern void loop(void);

int main () {
    setup();
    while(1) {
        loop();
    }
}

#ifdef EXAMPLE_TCPCLIENT

#define SSID       "ITEAD"
#define PASSWORD   "12345678"


#include "ESP8266.h"

ESP8266 wifi(p28, p27);
const char *server = "www.163.com";
char message[4096];

void setup()
{
    printf("setup begin\r\n");
    
    if(wifi.reset()) {
        printf("reset ok\r\n");
    } else {
        printf("reset err\r\n");
    }
    
    if(wifi.setStationMode(SSID, PASSWORD)) {
        printf("setStationMode ok\r\n");
        printf("AP:%s\r\n", wifi.showJAP().c_str());
        printf("IP:%s\r\n", wifi.showIP().c_str());
    } else {
        printf("setStationMode err\r\n");
    }
    
    printf("setup end\r\n");
}

void loop()
{   
    unsigned long t;
    if (wifi.ipConfig(ESP8266_COMM_TCP, server, 80)) {
        printf("connected and get /\r\n");
        wifi.send("GET / HTTP/1.1\r\n\r\n");
        t = millis();
        printf("Recv:\r\n[");
        while(millis() - t <= 10000) {
            if(wifi.recvData(message)) {
                printf("%s", message);
                message[0] = 0;
            }
        }
        printf("]\r\n");
        
    } else {
        printf("connect failed\r\n");
    }
    while(1);
}

#endif

#ifdef EXAMPLE_TCPSERVER
#define SSID       "ITEAD"
#define PASSWORD   "12345678"

#include "ESP8266.h"


ESP8266 wifi(p28, p27);


void setup()
{
    wifi.reset();
    if(!wifi.setStationMode(SSID, PASSWORD)) {
        printf("init error\r\n");
    }
    delay(8000);
    printf("IP address:%s\r\n", wifi.showIP().c_str());
    printf("Access Point:%s\r\n", wifi.showJAP().c_str());
    
    delay(1000);
    wifi.confMux(1);
    delay(100);
    if(wifi.confServer(1, 80)) {
        printf("Server is set up\r\n");
    }
}

void loop()
{   
    char buf[500];
    int iLen = wifi.recvData(buf);
    if(iLen > 0) {
    
        printf("Recv:[%s]\r\n", buf);
        delay(100);
        
        String cmd;
        cmd = "HTTP/1.1 200 OK\r\n";
        cmd += "Content-Type: text/html\r\n";
        cmd += "Connection: close\r\n";
        cmd += "\r\n";
        cmd += "This is a test server.";
        
        wifi.send(wifi.getMuxID(),cmd);
        delay(300);
        wifi.closeMux(wifi.getMuxID());
        delay(1000);
    }
}    

#endif

#ifdef EXAMPLE_UDPTEST
#define SSID       "ITEAD"
#define PASSWORD   "12345678"


#include "ESP8266.h"

ESP8266 wifi(p28, p27);
DigitalOut led1(LED1);

void setup()
{
    wifi.reset();
    if(!wifi.setStationMode(SSID, PASSWORD)) {
        printf("init error\r\n");
    }
    delay(8000);
    printf("IP address:%s\r\n", wifi.showIP().c_str());
    printf("Access Point:%s\r\n", wifi.showJAP().c_str());
    
    if (wifi.ipConfig(ESP8266_UDP, "172.16.5.12", 5416)) {  //Connect to your server
        printf("Register UDP ok\r\n");
    } else {
        printf("Register UDP err\r\n");
    }
    wifi.send("setup done\r\n");
    printf("setup done\r\n");
}



void loop() {
    char buf[10];
    int iLen = 0;
    iLen = wifi.recvData(buf);
    if(iLen > 0) {
        //if you receive "HIGH" message, set the D13 to high voltage; and vice versa
        if (strcmp(buf, "HIGH") == 0) {
            printf("Set HIGH\r\n");
            led1 = 1;
        }
        else if (strcmp(buf, "LOW") == 0) {
            printf("Set LOW\r\n");
            led1 = 0;
        }
    }
}

#endif

#ifdef EXAMPLE_WIFITEST
#include "ESP8266.h"

#define SSID       "ITEAD"
#define PASSWORD   "12345678"

ESP8266 wifi(p28, p27);

void setup(void) {
    wifi.reset();
    if(!wifi.setStationMode(SSID, PASSWORD)) {
        printf("init error\r\n");
    }
    delay(8000);
    printf("IP address:%s\r\n", wifi.showIP().c_str());
    printf("Access Point:%s\r\n", wifi.showJAP().c_str());
}

void loop(void) {
}

#endif