#ifndef __DEBUG_H__
#define __DEBUG_H__

#include "mbed.h"

#define LOG_OUTPUT_ERROR              (1)
#define LOG_OUTPUT_WARN               (1)
#define LOG_OUTPUT_INFO               (1)
#define LOG_OUTPUT_DEBUG              (1)
#define LOG_OUTPUT_VERBOSE            (1)

#define LOG_OUTPUT_ERROR_PREFIX       (1)
#define LOG_OUTPUT_WARN_PREFIX        (1)
#define LOG_OUTPUT_INFO_PREFIX        (0)
#define LOG_OUTPUT_DEBUG_PREFIX       (0)
#define LOG_OUTPUT_VERBOSE_PREFIX     (0)

extern Serial pc;

#define log_out pc.printf

#define logError(fmt, args...)\
    do {\
        if (LOG_OUTPUT_ERROR)\
        {\
            if(LOG_OUTPUT_ERROR_PREFIX)\
                log_out("[LOG Error:%s,%d,%s] ",__FILE__,__LINE__,__FUNCTION__);\
            log_out(fmt, ##args);\
            log_out("\r\n");\
        }\
    } while(0)

#define logWarn(fmt, args...)\
    do {\
        if (LOG_OUTPUT_WARN)\
        {\
            if(LOG_OUTPUT_WARN_PREFIX)\
                log_out("[LOG Warn:%s,%d,%s] ",__FILE__,__LINE__,__FUNCTION__);\
            log_out(fmt, ##args);\
            log_out("\r\n");\
        }\
    } while(0)

#define logDebug(fmt, args...)\
    do {\
        if (LOG_OUTPUT_DEBUG)\
        {\
            if (LOG_OUTPUT_DEBUG_PREFIX)\
                log_out("[LOG Debug:%s,%d,%s] ",__FILE__,__LINE__,__FUNCTION__);\
            log_out(fmt, ##args);\
            log_out("\r\n");\
        }\
    } while(0)

#define logInfo(fmt, args...)\
    do {\
        if (LOG_OUTPUT_INFO)\
        {\
            if (LOG_OUTPUT_INFO_PREFIX)\
                log_out("[LOG Info:%s,%d,%s] ",__FILE__,__LINE__,__FUNCTION__);\
            log_out(fmt, ##args);\
            log_out("\r\n");\
        }\
    } while(0)
        

#define logVerbose(fmt, args...)\
    do {\
        if (LOG_OUTPUT_VERBOSE)\
        {\
            if (LOG_OUTPUT_VERBOSE_PREFIX)\
                log_out("[LOG Verbose:%s,%d,%s] ",__FILE__,__LINE__,__FUNCTION__);\
            log_out(fmt, ##args);\
            log_out("\r\n");\
        }\
    } while(0)


#endif /* #ifndef __DEBUG_H__ */