#include "ESP8266.h"


ESP8266::ESP8266(PinName tx, PinName rx, int baud_rate):m_uart(tx, rx) {
    m_uart.begin(baud_rate);
    m_uart.flush();
    m_uart.setTimeout(1000);
}

int ESP8266::getMuxID(void) {
    return m_mux_id;
}

bool ESP8266::reset(void)
{
    unsigned long start;
    m_uart.setTimeout(100);
    m_uart.flush();
    m_uart.println("AT+RST");
    if (!m_uart.find("OK")) {
        return false;
    }
    
    delay(2000);
    
    start = millis();
    while (millis() - start < 3000) {
        m_uart.flush();
        m_uart.println("AT");
        if (m_uart.find("OK")) {
            delay(500);
            return true;
        }
        delay(100);
    }
    return false;
}

bool ESP8266::setStationMode(String ssid, String pwd)
{
    if (!confMode(ESP8266_MODE_STA))
    {
        return false;
    }
    return confJAP(ssid, pwd);
}

bool ESP8266::setSoftAPMode(String sap_ssid, String sap_pwd, int chl, ESP8266Encrypstion ecn)
{
    if (!confMode(ESP8266_MODE_SAP))
    {
        return false;
    }
    return confSAP(sap_ssid, sap_pwd, chl, ecn);
}

bool ESP8266::setStationSoftAPMode(String ssid, String pwd, String sap_ssid, String sap_pwd ,
        int chl, ESP8266Encrypstion ecn)
{
    if (!confMode(ESP8266_MODE_STA_SAP))
    {
        return false;
    }
    if (confJAP(ssid, pwd) && confSAP(sap_ssid, sap_pwd, chl, ecn)) {
        return true;
    } else {
        return false;
    }
}

bool ESP8266::ipConfig(ESP8266CommType type, String addr, int port, ESP8266Mux mux, int id)
{
    bool result = false;
    if (mux == ESP8266_MUX_SINGLE)
    {
        confMux(mux);
        delay(5000);
        result = newMux(type, addr, port);
    }
    else if (mux == ESP8266_MUX_MULTIPLE)
    {
        confMux(mux);
        delay(5000);
        result = newMux(id, type, addr, port);
    }
    return result;
}

int ESP8266::recvData(char *buf)
{
    String data = "";
    if (m_uart.available()>0)
    {
        
        unsigned long start;
        start = millis();
        char c0 = m_uart.readChr();
        if (c0 == '+')
        {
            
            while (millis()-start<5000) 
            {
                if (m_uart.available()>0)
                {
                    char c = m_uart.readChr();
                    data += c;
                }
                if (data.indexOf("\nOK")!=-1)
                {
                    break;
                }
            }

            int sLen = strlen(data.c_str());
            int i,j;
            for (i = 0; i <= sLen; i++)
            {
                if (data[i] == ':')
                {
                    break;
                }
                
            }
            bool found = false;
            for (j = 4; j <= i; j++)
            {
                if (data[j] == ',')
                {
                    found = true;
                    break;
                }
                
            }
            int iSize;
            if(found ==true)
            {
            String _id = data.substring(4, j);
            m_mux_id = _id.toInt();
            String _size = data.substring(j+1, i);
            iSize = _size.toInt();
            
            String str = data.substring(i+1, i+1+iSize);
            strcpy(buf, str.c_str());   
            
                        
            }
            else
            {           
            String _size = data.substring(4, i);
            iSize = _size.toInt();
            
            
            String str = data.substring(i+1, i+1+iSize);
            strcpy(buf, str.c_str());
            
            }
            return iSize;
        }
    }
    
    return 0;
}

String ESP8266::showMode()
{
    String data;
    m_uart.println("AT+CWMODE?");  
    unsigned long start;
    start = millis();
    while (millis()-start<2000) {
     if(m_uart.available()>0)
     {
     char a =m_uart.readChr();
     data=data+a;
     }
     if (data.indexOf("OK")!=-1)
     {
         break;
     }
  }
    if(data.indexOf("1")!=-1)
    {
        return "Station";
    }else if(data.indexOf("2")!=-1)
    {
            return "AP";
    }else if(data.indexOf("3")!=-1)
    {
         return "AP+Station";
    }else{
        return "Invalid Mode!";
    }
}

bool ESP8266::confMode(ESP8266WorkMode mode)
{
    String data;
    m_uart.flush();
    m_uart.print("AT+CWMODE=");  
    m_uart.println(String(mode));
    unsigned long start;
    start = millis();
    while (millis()-start<2000) {
        while(m_uart.available()>0) {
            char c = m_uart.readChr();
            data += c;
        }
        if (data.indexOf("OK")!=-1 || data.indexOf("no change")!=-1)
        {
            return true;
        } else if (data.indexOf("ERROR")!=-1 || data.indexOf("busy")!=-1)
        {
            return false;
        }
    }
    return false;     
}

String ESP8266::showAP(void)
{
    String data;
    m_uart.flush();
    m_uart.print("AT+CWLAP\r\n");  
    delay(5000);
    
    unsigned long start;
    start = millis();
    while (millis()-start<8000) {
   if(m_uart.available()>0)
   {
     char a =m_uart.readChr();
     data=data+a;
   }
     if (data.indexOf("OK")!=-1 || data.indexOf("ERROR")!=-1 )
     {
         break;
     }
  }
    if(data.indexOf("ERROR")!=-1)
    {
        return "ERROR";
    }
    else{
       char head[4] = {0x0D,0x0A};   
       char tail[7] = {0x0D,0x0A,0x0D,0x0A};        
       data.replace("AT+CWLAP","");
       data.replace("OK","");
       data.replace("+CWLAP","ESP8266");
       data.replace(tail,"");
       data.replace(head,"");

        return data;
        }
 }

String ESP8266::showJAP(void)
{
    bool ret = false;
    m_uart.flush();
    m_uart.println("AT+CWJAP?");  
    
    String data;
    unsigned long start;
    start = millis();
    while (millis()-start < 3000) {
        while(m_uart.available() > 0) {
            char a = m_uart.readChr();
            data += a;
            //printf("%c", a);
        }      
        if (data.indexOf("OK") != -1) {
            ret = true;
            break;
        } else if (data.indexOf("ERROR") != -1) {
            ret = false;
            break;
        }     
    }
    if (ret) {
        int index1 = data.indexOf(":\"");
        int index2 = data.indexOf("\"\r\n");
        if (index1 != -1 && index2 != -1) {
            return data.substring(index1 + 2, index2);
        } else {
            return "not found";
        }
    } else {
        return "null";
    }  
}

bool ESP8266::confJAP(String ssid , String pwd)
{
    bool ret = false;
    m_uart.flush();
    m_uart.print("AT+CWJAP=");
    m_uart.print("\"");     //"ssid"
    m_uart.print(ssid);
    m_uart.print("\"");

    m_uart.print(",");

    m_uart.print("\"");      //"pwd"
    m_uart.print(pwd);
    m_uart.println("\"");

    String data;
    unsigned long start;
    start = millis();
    while (millis() - start < 10000) {        
        while (m_uart.available() > 0) {
            char c = m_uart.readChr();
            data += c;
        }
        if(data.indexOf("OK") != -1) {
            ret = true;
            break;
        } else if (data.indexOf("ERROR") != -1) {
            ret = false;
            break;
        }
    }
    
    if (ret) {
        return true;
    } else {
        return false;
    }
}

bool ESP8266::quitAP(void)
{
    m_uart.println("AT+CWQAP");
    unsigned long start;
    start = millis();
    while (millis()-start<3000) {                            
        if(m_uart.find("OK")==true)
        {
           return true;
           
        }
    }
    return false;

}

String ESP8266::showSAP()
{
    m_uart.println("AT+CWSAP?");  
      String data;
      unsigned long start;
    start = millis();
    while (millis()-start<3000) {
       if(m_uart.available()>0)
       {
       char a =m_uart.readChr();
       data=data+a;
       }
       if (data.indexOf("OK")!=-1 || data.indexOf("ERROR")!=-1 )
       {
           break;
       }
    }
      char head[4] = {0x0D,0x0A};   
      char tail[7] = {0x0D,0x0A,0x0D,0x0A};        
      data.replace("AT+CWSAP?","");
      data.replace("+CWSAP","mySAP");
      data.replace("OK","");
      data.replace(tail,"");
      data.replace(head,"");
      
          return data;
}

bool ESP8266::confSAP(String ssid , String pwd , int chl , int ecn)
{
    m_uart.print("AT+CWSAP=");  
    m_uart.print("\"");     //"ssid"
    m_uart.print(ssid);
    m_uart.print("\"");

    m_uart.print(",");

    m_uart.print("\"");      //"pwd"
    m_uart.print(pwd);
    m_uart.print("\"");

    m_uart.print(",");
    m_uart.print(String(chl));

    m_uart.print(",");
    m_uart.println(String(ecn));
    unsigned long start;
    start = millis();
    while (millis()-start<3000) {                            
        if(m_uart.find("OK")==true )
        {
           return true;
        }
     }
     
     return false;

}


String ESP8266::showStatus(void)
{
    m_uart.println("AT+CIPSTATUS");  
      String data;
    unsigned long start;
    start = millis();
    while (millis()-start<3000) {
       if(m_uart.available()>0)
       {
       char a =m_uart.readChr();
       data=data+a;
       }
       if (data.indexOf("OK")!=-1)
       {
           break;
       }
    }

          char head[4] = {0x0D,0x0A};   
          char tail[7] = {0x0D,0x0A,0x0D,0x0A};        
          data.replace("AT+CIPSTATUS","");
          data.replace("OK","");
          data.replace(tail,"");
          data.replace(head,"");
          
          return data;
}

String ESP8266::showMux(void)
{
    String data;
    m_uart.println("AT+CIPMUX?");  

      unsigned long start;
    start = millis();
    while (millis()-start<3000) {
       if(m_uart.available()>0)
       {
       char a =m_uart.readChr();
       data=data+a;
       }
       if (data.indexOf("OK")!=-1)
       {
           break;
       }
    }
          char head[4] = {0x0D,0x0A};   
          char tail[7] = {0x0D,0x0A,0x0D,0x0A};        
          data.replace("AT+CIPMUX?","");
          data.replace("+CIPMUX","showMux");
          data.replace("OK","");
          data.replace(tail,"");
          data.replace(head,"");
          
          return data;
}

bool ESP8266::confMux(ESP8266Mux mux)
{
    m_uart.print("AT+CIPMUX=");
    m_uart.println(mux);           
    unsigned long start;
    start = millis();
    while (millis()-start<3000) {                            
        if(m_uart.find("OK")==true )
        {
           return true;
        }
     }
     
     return false;
}

bool ESP8266::newMux(ESP8266CommType type, String addr, int port)

{
    String data;
    m_uart.flush();
    m_uart.print("AT+CIPSTART=");
    if(ESP8266_COMM_TCP == type) {
        m_uart.print("\"TCP\"");
    } else if (ESP8266_COMM_UDP == type) {
        m_uart.print("\"UDP\"");
    }
    m_uart.print(",");
    m_uart.print("\"");
    m_uart.print(addr);
    m_uart.print("\"");
    m_uart.print(",");
    m_uart.println(String(port));
    unsigned long start;
    start = millis();
    while (millis()-start<10000) { 
     if(m_uart.available()>0)
     {
     char a =m_uart.readChr();
     data=data+a;
     }
     if (data.indexOf("OK")!=-1 || data.indexOf("ALREAY CONNECT")!=-1 || data.indexOf("ERROR")!=-1)
     {
         return true;
     }
  }
  return false;
}

bool ESP8266::newMux( int id, ESP8266CommType type, String addr, int port)
{
    m_uart.print("AT+CIPSTART=");
    m_uart.print("\"");
    m_uart.print(String(id));
    m_uart.print("\"");
    if(ESP8266_COMM_TCP == type) {
        m_uart.print("\"TCP\"");
    } else if (ESP8266_COMM_UDP == type) {
        m_uart.print("\"UDP\"");
    }
    m_uart.print(",");
    m_uart.print("\"");
    m_uart.print(addr);
    m_uart.print("\"");
    m_uart.print(",");
    m_uart.println(String(port));
    String data;
    unsigned long start;
    start = millis();
    while (millis()-start<3000) { 
     if(m_uart.available()>0)
     {
     char a =m_uart.readChr();
     data=data+a;
     }
     if (data.indexOf("OK")!=-1 || data.indexOf("ALREAY CONNECT")!=-1 )
     {
         return true;
     }
  }
  return false;
  

}

bool ESP8266::send(String str)
{
    m_uart.flush();
    m_uart.print("AT+CIPSEND=");
    m_uart.println(str.length());
    unsigned long start;
    start = millis();
    bool found = false;
    while (millis()-start<5000) {                            
        if(m_uart.find(">")==true )
        {
            found = true;
           break;
        }
     }
     if(found)
        m_uart.print(str);
    else
    {
        closeMux();
        return false;
    }


    String data;
    start = millis();
    while (millis()-start<5000) {
     if(m_uart.available()>0)
     {
     char a =m_uart.readChr();
     data=data+a;
     }
     if (data.indexOf("SEND OK")!=-1)
     {
         return true;
     }
  }
  return false;
}

bool ESP8266::send(int id, String str)
{
    m_uart.print("AT+CIPSEND=");

    m_uart.print(String(id));
    m_uart.print(",");
    m_uart.println(str.length());
    unsigned long start;
    start = millis();
    bool found = false;
    while (millis()-start<5000) {                          
        if(m_uart.find(">")==true )
        {
            found = true;
           break;
        }
     }
     if(found)
        m_uart.print(str);
    else
    {
        closeMux(id);
        return false;
    }


    String data;
    start = millis();
    while (millis()-start<5000) {
     if(m_uart.available()>0)
     {
     char a =m_uart.readChr();
     data=data+a;
     }
     if (data.indexOf("SEND OK")!=-1)
     {
         return true;
     }
  }
  return false;
}


void ESP8266::closeMux(void)
{
    m_uart.println("AT+CIPCLOSE");

    String data;
    unsigned long start;
    start = millis();
    while (millis()-start<3000) {
     if(m_uart.available()>0)
     {
     char a =m_uart.readChr();
     data=data+a;
     }
     if (data.indexOf("Linked")!=-1 || data.indexOf("ERROR")!=-1 || data.indexOf("we must restart")!=-1)
     {
         break;
     }
  }
}

void ESP8266::closeMux(int id)
{
    m_uart.print("AT+CIPCLOSE=");
    m_uart.println(String(id));
    String data;
    unsigned long start;
    start = millis();
    while (millis()-start<3000) {
     if(m_uart.available()>0)
     {
     char a =m_uart.readChr();
     data=data+a;
     }
     if (data.indexOf("OK")!=-1 || data.indexOf("Link is not")!=-1 || data.indexOf("Cant close")!=-1)
     {
         break;
     }
  }

}

String ESP8266::showIP(void)
{
    bool ret = false;
    m_uart.flush();
    m_uart.println("AT+CIFSR");  
    
    String data;
    unsigned long start;
    start = millis();
    while (millis()-start < 3000) {
        while(m_uart.available() > 0) {
            char a = m_uart.readChr();
            data += a;
        }
        if (data.indexOf("OK") != -1) {
            ret = true;
            break;
        } else if (data.indexOf("ERROR") != -1) {
            ret = false;
            break;
        }
    }
    //printf("data = [%s]\r\n", data.c_str());
    if (ret) {
        int index1 = data.indexOf("AT+CIFSR\r\r\n");
        int index2 = data.indexOf("\r\n\r\nOK");
        if (index1 != -1 && index2 != -1) {
            return data.substring(index1 + strlen("AT+CIFSR\r\r\n"), index2);
        } else {
            return "not found";
        }
    } else {
        return "null";
    }  
}

bool ESP8266::confServer(int mode, int port)
{
    m_uart.print("AT+CIPSERVER=");  
    m_uart.print(String(mode));
    m_uart.print(",");
    m_uart.println(String(port));

    String data;
    unsigned long start;
    start = millis();
    bool found = false;
    while (millis()-start<3000) {
     if(m_uart.available()>0)
     {
     char a =m_uart.readChr();
     data=data+a;
     }
     if (data.indexOf("OK")!=-1 || data.indexOf("no charge")!=-1)
     {
        found = true;
         break;
     }
  }
  m_uart.flush();
  return found;
}
