#include "mbed.h"
#include "Keepad.h"
#include "LCDs.h"
//#include "Decoder.h"
#include "steps.h"
#include "interface.h"

interface::interface(){}

void interface::startup()
{
    LCDs lcd;    
    lcd.lcdcmd(0x01);  
    lcd.putString("   IRRIGATION    SYSTEM STARTED");
    wait_ms(2000);
    lcd.lcdcmd(0x01);  
}

char interface::scr1cnt()
{   
    int k1=0;
    char at = 'z';
    screen1();
    steps s;
    while(k1!=11 && k1!=21 && k1!=31)
    {
        k1 = keyInp();
    }
    int r = s.step1(k1);
    k1=0;
    while(k1==0)
    {
        k1 = keyInp();
        if( k1 == 33)
            screen1();
        else if( k1 == 21 && r==1)
            screenManual();
        else if( k1 == 11 && r==1)
        {
            at = screenAuto();
            if(at=='s')
                scr1cnt();
        }
        else
            k1=0;
    }
    return(at);
}

void interface::screen1()
{
    LCDs lcd2;
    lcd2.lcdcmd(0x01);
    lcd2.putString("PRESS: 1->MODES 2->TEMP 3->MOIST");    
}

void interface::screenManual()
{
    int k4=0;
    LCDs lcd3;
    lcd3.lcdcmd(0x01);
    lcd3.putString("Enter Irrigationtime (min): >>>");
    while( k4 != 41)
    {
        k4 = keyInp();
        if(k4==34)
            scr1cnt();
    }
    lcd3.lcdcmd(0x01);
    string k3 = convNum();
    lcd3.lcdcmd(0x01);
    lcd3.putString(k3);
}

int interface::screenAuto()
{
    int k3=0;
    LCDs lcd4;
    lcd4.lcdcmd(0x01);
    lcd4.putString("Enter crop :");
    lcd4.lcdcmd(0xC0);
    lcd4.putString(">Press Right Key");        
    while( k3 != 41)
    {
        k3 = keyInp();
        if(k3==34)
            scr1cnt();
    }
    lcd4.lcdcmd(0x01);
    lcd4.putString("1.Wheat  2.Maize");
    lcd4.lcdcmd(0xC0);
    lcd4.putString("3.Onion 4.Potato");
    k3=0;
    while(k3==0)
    {
        k3 = keyInp();
        if( k3 == 11)
        {
            //Wheat();
            return('w');
        }
        else if( k3 == 21)
        {
            //Maize();
            return('m');
        }
        else if( k3 == 31)
        {
            //Onion();
            return('o');
        }
        else if( k3 == 12)
        {
            //Potato();
            return('p');
        }
        else if( k3 == 34)        
            return('s');
        else
            k3=0;
    }
    return('z');
}

int interface::keyInp()
{
    int kp=0;
    Keepad kpd;
    while(kp==0){
        kp=0;
        kp=kpd.keypad();
    }
    return(kp);
}

string interface::convNum()
{
    int cv[10];
    int i = 0, j = 0, sum = 0;    
    while(j != 34)
    {
        j = keyInp();        
        switch(j)
        {
            case 11:
                cv[i] = 1;
                break;
            case 21:
                cv[i] = 2;
                break;
            case 31:
                cv[i] = 3;
                break;
            case 12:
                cv[i] = 4;
                break;
            case 22:
                cv[i] = 5;
                break;
            case 32:
                cv[i] = 6;
                break;
            case 13:
                cv[i] = 7;
                break;
            case 23:
                cv[i] = 8;
                break;
            case 24:
                cv[i] = 9;
                break;
            case 14:
                cv[i] = 0;
                break;
            default:
                break;
        }
        i++;
    }
    j=1;
    i=i-2;
    sum = cv[i];
    for(int t = 1; t <= i; t++)
    {
        j=j*10;
    }
    
    for(int tv = 0; tv <i; tv++)
    {
        sum = sum + (cv[tv]*j);
        j=j/10;
    }
    
    char dis[16];
    sprintf(dis,"%d",sum);
    return(dis);
}