#include "mbed.h"
#include "LCDs.h"
#include <string>

DigitalOut rs(PA_6);
DigitalOut en(PB_6);
DigitalOut rw(PA_7);
DigitalOut db0(PC_7);
DigitalOut db1(PA_9);
DigitalOut db2(PA_8);
DigitalOut db3(PB_10);
DigitalOut db4(PB_4);
DigitalOut db5(PB_5);
DigitalOut db6(PB_3);
DigitalInOut db7(PA_10);

LCDs::LCDs()
{}

void LCDs::lcdinit()
{
    db7.output();
    db7=0;    
    en=0;
    wait_ms(250);
}

void LCDs::putString(string disp)
{
    for(int j = 0; j < disp.length(); j++)
    {
        if(j==16)
            lcdcmd(0xC0);
        putData((unsigned char)disp.at(j));
        rs=1;
        rw=0;
        en=1;
        wait_ms(1);
        en=0;
        lcdReady();
    }
}

void LCDs::lcdReady()
{
    db7.input();
    rs=0;
    rw=1;
    do
    {
        en=1;
        wait_ms(1);
        en=0;
    }while(db7==1);
    db7.output();
}

void LCDs::putData(unsigned char value)
{
    unsigned char newValue = value;
    for(int i = 0; i<=7; i++)
    {    
        newValue = value>>i;       
        newValue = newValue & 0x01;
        switch(i)
        {
            case 0:
               db0=(int)newValue;
               break;
            case 1:
               db1=(int)newValue;
               break;
            case 2:
               db2=(int)newValue;
               break;
            case 3:
               db3=(int)newValue;
               break;
            case 4:
               db4=(int)newValue;
               break;
            case 5:
               db5=(int)newValue;
               break;
            case 6:
               db6=(int)newValue;
               break;
            case 7:
               db7=(int)newValue;
               break;
            default:
                break;
        }         
    }
}

void LCDs::lcdcmd(unsigned char value)
{
    putData(value);
    rs=0;
    rw=0;
    en=1;
    wait_ms(1);
    en=0;
    lcdReady();
}
