#include "beacon.h"
Serial pc(USBTX, USBRX);          // tx, rx
SPI spi(D11, D12, D13);              // mosi, miso, sclk
DigitalOut cs(D10);                //slave select or chip select

void writereg(uint8_t reg,uint8_t val)
{
    cs = 0;__disable_irq();spi.write(reg | 0x80);spi.write(val);__enable_irq();cs = 1;
}
uint8_t readreg(uint8_t reg)
{
    int val;cs = 0;__disable_irq();spi.write(reg & ~0x80);val = spi.write(0);__enable_irq();cs = 1;return val;
}
void clearTxBuf()
{
    writereg(RF22_REG_08_OPERATING_MODE2,0x01);
    writereg(RF22_REG_08_OPERATING_MODE2,0x00);
}
void clearRxBuf()
{
    writereg(RF22_REG_08_OPERATING_MODE2,0x02);
    writereg(RF22_REG_08_OPERATING_MODE2,0x00);
}
int setFrequency(float centre,float afcPullInRange)
{
//freq setting begins 
    uint8_t fbsel = 0x40;
    uint8_t afclimiter;
    if (centre >= 480.0) {
        centre /= 2;
        fbsel |= 0x20;
        afclimiter = afcPullInRange * 1000000.0 / 1250.0;
    } else {
        if (afcPullInRange < 0.0 || afcPullInRange > 0.159375)
            return false;
        afclimiter = afcPullInRange * 1000000.0 / 625.0;
    }
    centre /= 10.0;
    float integerPart = floor(centre);
    float fractionalPart = centre - integerPart;
 
    uint8_t fb = (uint8_t)integerPart - 24; // Range 0 to 23
    fbsel |= fb;
    uint16_t fc = fractionalPart * 64000;
    writereg(RF22_REG_73_FREQUENCY_OFFSET1, 0);  // REVISIT
    writereg(RF22_REG_74_FREQUENCY_OFFSET2, 0);
    writereg(RF22_REG_75_FREQUENCY_BAND_SELECT, fbsel);
    writereg(RF22_REG_76_NOMINAL_CARRIER_FREQUENCY1, fc >> 8);
    writereg(RF22_REG_77_NOMINAL_CARRIER_FREQUENCY0, fc & 0xff);
    writereg(RF22_REG_2A_AFC_LIMITER, afclimiter);
    return 0;
}

void init_short()
{
    //reset()
    writereg(RF22_REG_07_OPERATING_MODE1,0x80);        //sw_reset
    wait(1);                    //takes time to reset                                  

    clearTxBuf();                                                             
    clearRxBuf();                                                             
    //txfifoalmostempty
    writereg(RF22_REG_7D_TX_FIFO_CONTROL2,10);
    //rxfifoalmostfull
    writereg(RF22_REG_7E_RX_FIFO_CONTROL,20);
    //Packet-engine registers
    writereg(RF22_REG_30_DATA_ACCESS_CONTROL,0x8E);    //RF22_REG_30_DATA_ACCESS_CONTROL, RF22_ENPACRX | RF22_ENPACTX | RF22_ENCRC | RF22_CRC_CRC_16_IBM
    //&0x77 = diasable packet rx-tx handling
    writereg(RF22_REG_32_HEADER_CONTROL1,0x88);    //RF22_REG_32_HEADER_CONTROL1, RF22_BCEN_HEADER3 | RF22_HDCH_HEADER3
    writereg(RF22_REG_33_HEADER_CONTROL2,0x42);    //RF22_REG_33_HEADER_CONTROL2, RF22_HDLEN_4 | RF22_SYNCLEN_2
    writereg(RF22_REG_34_PREAMBLE_LENGTH,8);       //RF22_REG_34_PREAMBLE_LENGTH, nibbles); preamble length = 8;
    writereg(RF22_REG_36_SYNC_WORD3,0x2D);    //syncword3=2D
    writereg(RF22_REG_37_SYNC_WORD2,0xD4);    //syncword2=D4
    writereg(RF22_REG_3F_CHECK_HEADER3,0);    //RF22_REG_3F_CHECK_HEADER3, RF22_DEFAULT_NODE_ADDRESS
    writereg(RF22_REG_3A_TRANSMIT_HEADER3,0xab);    //header_to
    writereg(RF22_REG_3B_TRANSMIT_HEADER2,0xbc);    //header_from 
    writereg(RF22_REG_3C_TRANSMIT_HEADER1,0xcd);    //header_ids
    writereg(RF22_REG_3D_TRANSMIT_HEADER0,0xde);    //header_flags
    writereg(RF22_REG_3F_CHECK_HEADER3,0xab);   
    writereg(RF22_REG_40_CHECK_HEADER2,0xbc);   
    writereg(RF22_REG_41_CHECK_HEADER1,0xcd);   
    writereg(RF22_REG_42_CHECK_HEADER0,0xde);
    
    //RSSI threshold for clear channel indicator
    writereg(RF22_REG_27_RSSI_THRESHOLD,0xA5);         //55 for -80dBm, 2D for -100dBm, 7D for -60dBm, A5 for -40dBm, CD for -20 dBm
    
    writereg(RF22_REG_0B_GPIO_CONFIGURATION0,0x15); // TX state                        ??
    writereg(RF22_REG_0C_GPIO_CONFIGURATION1,0x12); // RX state                        ??
    
    //interrupts
    // spiWrite(RF22_REG_05_INTERRUPT_ENABLE1, RF22_ENTXFFAEM |RF22_ENRXFFAFULL | RF22_ENPKSENT |RF22_ENPKVALID| RF22_ENCRCERROR);
    // spiWrite(RF22_REG_06_INTERRUPT_ENABLE2, RF22_ENPREAVAL);
    
    setFrequency(435.0, 0.05);
    
    //return !(statusRead() & RF22_FREQERR);
    if((readreg(RF22_REG_02_DEVICE_STATUS)& 0x08)!= 0x00)
    pc.printf("frequency not set properly\n");
    //frequency set

    //setModemConfig(FSK_Rb2_4Fd36);       FSK_Rb2_4Fd36,       ///< FSK, No Manchester, Rb = 2.4kbs,  Fd = 36kHz
    //setmodemregisters
    //0x1b, 0x03, 0x41, 0x60, 0x27, 0x52, 0x00, 0x07, 0x40, 0x0a, 0x1e, 0x80, 0x60, 0x13, 0xa9, 0x2c, 0x22, 0x3a = FSK_RB2_4FD36
    //0xc8, 0x03, 0x39, 0x20, 0x68, 0xdc, 0x00, 0x6b, 0x2a, 0x08, 0x2a, 0x80, 0x60, 0x13, 0xa9, 0x2c, 0x21, 0x08 = OOK,2.4, 335
    writereg(RF22_REG_1C_IF_FILTER_BANDWIDTH,0xdf);
    writereg(RF22_REG_1F_CLOCK_RECOVERY_GEARSHIFT_OVERRIDE,0x03);
    writereg(RF22_REG_20_CLOCK_RECOVERY_OVERSAMPLING_RATE,0x39);
    writereg(RF22_REG_21_CLOCK_RECOVERY_OFFSET2,0x20);                     
    writereg(RF22_REG_22_CLOCK_RECOVERY_OFFSET1,0x68);           //updated 20 to 25 reg values from excel sheet for 1.2 Khz freq. deviation,fsk
    writereg(RF22_REG_23_CLOCK_RECOVERY_OFFSET0,0xdc);
    writereg(RF22_REG_24_CLOCK_RECOVERY_TIMING_LOOP_GAIN1,0x00);
    writereg(RF22_REG_25_CLOCK_RECOVERY_TIMING_LOOP_GAIN0,0x6B);
    writereg(RF22_REG_2C_OOK_COUNTER_VALUE_1,0x2C);
    writereg(RF22_REG_2D_OOK_COUNTER_VALUE_2,0x11);    //not required for fsk (OOK counter value)
    writereg(RF22_REG_2E_SLICER_PEAK_HOLD,0x2A);         //??
    writereg(RF22_REG_58,0x80);
    writereg(RF22_REG_69_AGC_OVERRIDE1,0x60);
    writereg(RF22_REG_6E_TX_DATA_RATE1,0x09);
    writereg(RF22_REG_6F_TX_DATA_RATE0,0xd5);
    writereg(RF22_REG_70_MODULATION_CONTROL1,0x2c);
    writereg(RF22_REG_71_MODULATION_CONTROL2,0x21);//ook = 0x21 //fsk = 0x22
    writereg(RF22_REG_72_FREQUENCY_DEVIATION,0x50);
    //set tx power
    writereg(RF22_REG_6D_TX_POWER,0x07);    //20dbm
    writereg(RF22_REG_3E_PACKET_LENGTH,TX_DATA_SHORT); //packet length     
}
void init_long()
{
    //modem config
    writereg(RF22_REG_1C_IF_FILTER_BANDWIDTH,0xDF);
    writereg(RF22_REG_1F_CLOCK_RECOVERY_GEARSHIFT_OVERRIDE,0x03);
    writereg(RF22_REG_20_CLOCK_RECOVERY_OVERSAMPLING_RATE,0x71);
    writereg(RF22_REG_21_CLOCK_RECOVERY_OFFSET2,0x40);                     
    writereg(RF22_REG_22_CLOCK_RECOVERY_OFFSET1,0x34);           //updated 20 to 25 reg values from excel sheet for 1.2 Khz freq. deviation,fsk
    writereg(RF22_REG_23_CLOCK_RECOVERY_OFFSET0,0x6E);
    writereg(RF22_REG_24_CLOCK_RECOVERY_TIMING_LOOP_GAIN1,0x00);
    writereg(RF22_REG_25_CLOCK_RECOVERY_TIMING_LOOP_GAIN0,0x36);
    writereg(RF22_REG_2C_OOK_COUNTER_VALUE_1,0x30);
    writereg(RF22_REG_2D_OOK_COUNTER_VALUE_2,0x23);    //not required for fsk (OOK counter value)
    writereg(RF22_REG_2E_SLICER_PEAK_HOLD,0x2B);         //??
    writereg(RF22_REG_58,0x80);
    writereg(RF22_REG_69_AGC_OVERRIDE1,0x60);
    writereg(RF22_REG_6E_TX_DATA_RATE1,0x04);
    writereg(RF22_REG_6F_TX_DATA_RATE0,0xEA);
    writereg(RF22_REG_70_MODULATION_CONTROL1,0x2c);
    writereg(RF22_REG_71_MODULATION_CONTROL2,0x21);//ook = 0x21 //fsk = 0x22
    writereg(RF22_REG_72_FREQUENCY_DEVIATION,0x02);
    writereg(RF22_REG_3E_PACKET_LENGTH,TX_DATA_LONG); //packet length     
}
int main()
{
    wait(1);                     // wait for POR to complete   //change the timing later
    cs=1;                          // chip must be deselected
    wait(1);                    //change the time later
    spi.format(8,0);
    spi.frequency(10000000);       //10MHz SCLK    
    if (readreg(RF22_REG_00_DEVICE_TYPE) == 0x08) pc.printf("spi connection valid\n");
    else pc.printf("error in spi connection\n");

    init_short();

    
    //init complete
    pc.printf("init complete.....\n");
    while(1)
    {
        pc.printf("press t to send or r to receive....\n");
        if(pc.getc()=='t')
        {
            wait(0.02);                                                           // pl. update this value  or even avoid it!!!                  
            //extract values from short_beacon[]
            uint8_t byte_counter = 0;
            struct Short_beacon{
                uint8_t Voltage[1];
                uint8_t AngularSpeed[2];
                uint8_t SubsystemStatus[1];
                uint8_t Temp[3];
                uint8_t ErrorFlag[1];
                }Shortbeacon = { {0x88}, {0x99, 0xAA} , {0xAA},{0xAA,0xDD,0xEE}, {0x00} };
            
            //filling hk data
            uint8_t short_beacon[] = { 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77,Shortbeacon.Voltage[0],Shortbeacon.AngularSpeed[0], Shortbeacon.AngularSpeed[1],Shortbeacon.SubsystemStatus[0],Shortbeacon.Temp[0],Shortbeacon.Temp[1],Shortbeacon.Temp[2],Shortbeacon.ErrorFlag[0]};
            //tx settings begin
            //setModeIdle();
            writereg(RF22_REG_07_OPERATING_MODE1,0x01);        //ready mode
            //fillTxBuf(data, len);
            clearTxBuf();  
        
            //Set to Tx mode
            writereg(RF22_REG_07_OPERATING_MODE1,0x09);
            
            while(byte_counter!=15){
                //Check for fifoThresh
                while((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x20) != 0x20);
                //writing again
                cs = 0;
                spi.write(0xFF);   
                for(int i=7; i>=0 ;i--)
                {
                    //pc.printf("%d\n",byte_counter);
                    if((short_beacon[byte_counter] & (uint8_t) pow(2.0,i))!=0)
                    //if((short_beacon[byte_counter] & mask[i]) != 0)
                {
                    spi.write(0xFF);
                    spi.write(0xFF);
                }
                else
                {
                    spi.write(0x00);
                    spi.write(0x00);
                    
                }
                }
                cs = 1;
                byte_counter++;
                
            }  
            //rf22.waitPacketSent();
            while((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x04) != 0x04)pc.printf(" chck short pkt sent!\n");  
            pc.printf("short packet sent...\n");
            
            wait(0.1);
            //long tx starts
            int i = 0;                           //for loops
            int u = 0;                           //universal count for hk array
            int bar = 0; 
            init_long();
            uint8_t long_beacon_data[TX_DATA_LONG];
            for(int i=0;i<TX_DATA_LONG;i++)
                long_beacon_data[i]=i;
            clearTxBuf();                                                             
            clearRxBuf();
/*            //Filling Data into FIFO for the first time
            cs = 0;
            spi.write(0xFF);               //fifo write access
            for(i=0; i< 20; i++) 
            {  
                spi.write(long_beacon_data[i]);
                //pc.printf("0x%X \n",long_beacon_data[u+i]);
            }
            u=i;
            cs = 1;  */  
            //Set to Tx mode
            writereg(RF22_REG_07_OPERATING_MODE1,0x09);
        
            //Check for fifoempty Thresh
            while((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x20) != 0x20);
        
            while(u!=TX_DATA_LONG) {
                if((TX_DATA_LONG - u) >= TIMES)
                    bar = TIMES;
                else
                    bar = (TX_DATA_LONG - u);
        
                //writing again
                cs = 0;
                spi.write(0xFF);                   //FIFO write access
                for(i=0; i<bar; i++){
                    spi.write(long_beacon_data[u + i]);
                    //pc.printf("0x%X \n",long_beacon_data[u+i]);
                    }
                printf("u=%d\n",u);
                u = u + i;
                cs = 1;
                //Check for fifoThresh
                while((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x20) != 0x20);
            }    
            //rf22.waitPacketSent();
            while((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x04) != 0x04)pc.printf(" chck long pkt sent!\n");     
            pc.printf("long packet sent ");
            
        }
        else if(pc.getc()=='r')
        {
            uint8_t short_rx_data[RX_DATA_SHORT];         // for filling the received short data
            uint8_t long_rx_data[RX_DATA_LONG];         // for filling the received long data
            int u=0,i=0;
            int bar = TIMES;
            //rf22.waitAvailable();
            clearTxBuf();                                                             
            clearRxBuf();                                                             
            //setModeRx();
            writereg(RF22_REG_07_OPERATING_MODE1,0x04);//rxon
            while((readreg(RF22_REG_04_INTERRUPT_STATUS2)& 0x10) != 0x10)
            pc.printf("rssi?\n");
            //preamble??
            while(!(readreg(0x04)&0x40))
            pc.printf("detecting preamble\n");
            //checking syncword
            while(!(readreg(RF22_REG_04_INTERRUPT_STATUS2)& 0x80))
            pc.printf("sync?\n");
            //check for fifothreshold
            while(u != RX_DATA_SHORT)//fifo_thresh
            {                
                pc.printf("1 \n");
                if((RX_DATA_SHORT - u) > TIMES)
                {
                    //check for fifo_thresh
                    while((readreg(RF22_REG_03_INTERRUPT_STATUS1)& 0x10) != 0x10)
                        pc.printf("fifo2?\n");
                    bar = TIMES;
                    //reading
                    cs = 0;
                    spi.write(0x7F);
                    for(i=0; i<bar;i++){
                    short_rx_data[u+i] = spi.write(0);
                    //pc.printf("0x%X \n",short_rx_data[u+i]);
                    }
                    u=u+i;
                    pc.printf("u= %d \n",u); 
                    cs = 1;            
                }
                else
                {
                    pc.printf("2\n");
                    wait(0.2);
                    bar = RX_DATA_SHORT- u;
                    //reading
                    cs = 0;
                    spi.write(0x7F);
                    for(i=0; i<bar;i++){
                    short_rx_data[u+i] = spi.write(0);
                    //pc.printf("0x%X \n",short_rx_data[u+i]);        
                    }
                    u=u+i;
                    cs = 1;    
                    pc.printf("u= %d \n",u);
                }        
            }  
            //packet valid??
            while(!(readreg(RF22_REG_03_INTERRUPT_STATUS1)& 0x02))
            pc.printf("checking if short beacon packet is valid\n");  
            pc.printf("short packet valid\n");
            
            init_long();
            u=0; i=0;
            bar = TIMES;
            clearTxBuf();                                                             
            clearRxBuf();                                                             
            //setModeRx();
            writereg(RF22_REG_07_OPERATING_MODE1,0x04); //rxon
            while((readreg(RF22_REG_04_INTERRUPT_STATUS2)& 0x10) != 0x10)
            pc.printf("rssi?\n");
            //preamble??
            while(!(readreg(0x04)&0x40))
            pc.printf("detecting preamble\n");
            //checking syncword
            while(!(readreg(RF22_REG_04_INTERRUPT_STATUS2)& 0x80))
            pc.printf("sync?\n");
            
            while(u != RX_DATA_LONG)//fifo_thresh
            {                
                pc.printf("1 \n");
                if((RX_DATA_LONG - u) > TIMES)
                {
                    //check for fifo_thresh
                    while((readreg(RF22_REG_03_INTERRUPT_STATUS1)& 0x10) != 0x10)
                        pc.printf("fifo2?\n");
                    bar = TIMES;
                    //reading
                    cs = 0;
                    spi.write(0x7F);
                    for(i=0; i<bar;i++){
                    long_rx_data[u+i] = spi.write(0);
                    //pc.printf("0x%X \n",long_rx_data[u+i]);
                    }
                    u=u+i;
                    pc.printf("u= %d \n",u); 
                    cs = 1;            
                }
                else
                {
                    pc.printf("2\n");
                    wait(0.2);
                    bar = RX_DATA_LONG- u;
                    //reading
                    cs = 0;
                    spi.write(0x7F);
                    for(i=0; i<bar;i++){
                    long_rx_data[u+i] = spi.write(0);
                    //pc.printf("0x%X \n",long_rx_data[u+i]);        
                    }
                    u=u+i;
                    cs = 1;    
                    pc.printf("u= %d \n",u);
                }        
            }  
            //packet valid??
            while(!(readreg(RF22_REG_03_INTERRUPT_STATUS1)& 0x02))
            pc.printf("checking if long beacon packet is valid\n");  
            pc.printf("long packet valid\n");
            
            bool shortbeacon[120];
            for(int i = 0; i<120; i++)
            short_rx_data[2*i] == 0xFF ? shortbeacon[i] = 1 :shortbeacon[i] =  0;             
               
            //converting bool to uint_8
            uint8_t s_beacon[15];
            for(int i = 0, m =0 ; i < 15 ; i++ )
            for(int n = 0; n < 8; n++,m++)
            {
                if(shortbeacon[m])
                {
                     s_beacon[i]<<=1;
                     s_beacon[i] |= 0x01;
                }  
                else
                s_beacon[i] <<= 1;
            }
            
            //Printing short beacon data     
            pc.printf("Received short beacon data:\n");        
            pc.printf("Call Sign : ");
            for(int i = 0; i<7 ; i++)
            pc.printf(" %X ",s_beacon[i]);
            
            pc.printf("\n\nVoltage[0] : ");
            pc.printf(" 0x%X \n\n",s_beacon[7]);
            
            pc.printf("AngularSpeed[0] : ");
            pc.printf(" 0x%X \n\n",s_beacon[8]);
            
            pc.printf("AngularSpeed[1] : ");
            pc.printf(" 0x%X \n\n",s_beacon[9]);
            
            pc.printf("SubsystemStatus[0] : ");
            pc.printf(" 0x%X \n\n",s_beacon[10]);
        
            pc.printf("Temp[0] : ");
            pc.printf(" 0x%X \n\n",s_beacon[11]);
            
            pc.printf("Temp[1] : ");
            pc.printf(" 0x%X \n\n",s_beacon[12]);
            
            pc.printf("Temp[2] : ");
            pc.printf(" 0x%X \n\n",s_beacon[13]);
            
            pc.printf("ErrorFlag[0] : ");
            pc.printf(" 0x%X \n\n",s_beacon[14]);
            pc.printf("received headers : \n");
            pc.printf("header1 = 0x%X , header2 = 0x%X , header3 = 0x%X , header4 = 0x%X \n",readreg(0x47),readreg(0x48),readreg(0x49),readreg(0x4A));      
            
            pc.printf("Received long beacon data:\n");
            for(int i=0;i<RX_DATA_LONG;i++) pc.printf("0x%X \n",long_rx_data[i]);  
        }
    }    
}