//without reset feature , with state checks.
#include<iostream>
#include"mbed.h"
#define ADF_IRQ PTA14
#define SPI_MOSI PTE1
#define SPI_MISO PTE3
#define SPI_CLK PTE2
#define SPI_CS_ADF PTA15
//Serial gPC( USBTX, USBRX );
//gPC.baud(1200);
InterruptIn IRQ(ADF_IRQ);
Ticker ticker;
//SPI spi(PTE1, PTE3, PTE2); 
//DigitalOut gCS_ADF(SPI_CS_ADF);
unsigned int Adf_data_counter=0;
unsigned char status =0;
unsigned int cmd_err_cnt=0;
unsigned int state_err_cnt=0;
unsigned int miso_err_cnt=0;
unsigned int hw_reset_err_cnt=0;
bool bcn_flag=0;
bool bbram_flag=0;

bool stop_transmission=false;
bool sent_tmfrom_SDcard;
bool loop_on;
bool ADF_off;
bool buffer_state;
uint8_t signal = 0x00;
uint8_t bbram_buffer[66]={0x19,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x00,0xF4,0xC2,0x10,0xC0,0x00,0x30,0x31,0x07,0x00,0x01,0x00,0x7F,0x00,0x0B,0x37,0x00,0x00,0x40,0x0C,0x00,0x05,0x00,0x00,0x18,0x12,0x34,0x56,0x10,0x10,0xC4,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00};
uint8_t Adf_data[100]={};       //Data to be transmitted
//uint8_t buffer_112[112];
//int initialise_card();
//int disk_initialize();


//void transmitdata(){       // copy the data to be transmitted to bufer_112
//    for(int i=0;i<112;i++){
//        buffer_112[i]=Adf_data[Adf_data_counter];
//        if(100==Adf_data_counter){
//            Adf_data_counter++;
//            stop_transmission= true;
//            break;  
//        }
//     }   
//}

#define bbram_write {\
    gCS_ADF=0;\
    spi.write(0xB0);\
    wait_us(300);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    for(int i=0;i<66;i++){\
        spi.write(bbram_buffer[i]);\
    }\
    gCS_ADF=1;\
}
//------------------------------------------------------------------------
// state checking functions
//bool assrt_phy_off( int, int, int);
//bool assrt_phy_on( int,int,int);
//bool assrt_phy_tx(int,int,int);

#define START_ADDRESS 0x020;
#define MISO_PIN PTE3
/**************Defining Counter Limits**************/
#define THRS 20
#define STATE_ERR_THRS 20
#define PHY_OFF_EXEC_TIME 300
#define PHY_ON_EXEC_TIME 300
#define PHY_TX_EXEC_TIME 600
/******DEFINING COMMANDS*********/
#define CMD_HW_RESET 0xC8
#define CMD_PHY_ON 0xB1
#define CMD_PHY_OFF 0xB0
#define CMD_PHY_TX 0xB5
#define CMD_CONFIG_DEV 0xBB

#define check_status {\
    unsigned char stat=0;\
    gCS_ADF=0;\
    spi.write(0xFF);\
    stat = spi.write(0xFF);\
    gCS_ADF=1;\
    status = stat;\
}

// all three arguments are int
#define assrt_phy_off(return_this) {\
    int cmd_err_cnt = 0;\
    int spi_err_cnt = 0;\
    int state_err_cnt = 0;\
    for(int i = 0 ; i < 40 ;i++){\
        check_status;\
        if(status == 0xB1){\
            return_this = 0;\
            break;\
        }\
        else if(cmd_err_cnt>THRS||spi_err_cnt>THRS){\
            return_this = 1;\
            break;\
        }\
        else if(state_err_cnt>STATE_ERR_THRS){\
            return_this = 1;\
            break;\
        }\
        else if( (status & 0xA0) == 0xA0 ){\
            gCS_ADF=0;\
            spi.write(CMD_PHY_OFF);\
            gCS_ADF=1;\
            wait_us(PHY_OFF_EXEC_TIME);\
            state_err_cnt++;\
        }\
        else if(status&0x80==0x00){\
            wait_ms(5);\
            spi_err_cnt++;\
        }\
        else {\
            wait_ms(1);\
            cmd_err_cnt++;\
        }\
    }\
}




#define initial_adf_check {\
    spi.write(CMD_PHY_OFF);\
    int tempReturn = 0;\
    bool flag = false;\
    while( hw_reset_err_cnt < 2 ){\
        assrt_phy_off( tempReturn);\
        if( !tempReturn ){\
            bbram_write;\
            bbram_flag=1;\
            flag = true;\
            break;\
        }\
        else{\
            hardware_reset(0);\
            hw_reset_err_cnt++;\
            gPC.puts("Resetting hardware\r\n");\
        }\
    }\
    if( flag == false ){\
        gPC.puts("Seems to be SPI problem\r\n");\
    }\
    assrt_phy_off(tempReturn);\
    if(!bbram_flag){\
        bcn_flag=1;\
     }\
}

bool hardware_reset(int bcn_call){
    for(int i= 0; i < 20 ; i++){
        gCS_ADF=0;
        spi.write(CMD_HW_RESET);
        gCS_ADF=1;
        wait_ms(2);// Typically 1 ms
        int count=0;
        int temp_return = 0;
        while(count<10 && miso_err_cnt<10){      
            if(MISO_PIN){
                assrt_phy_off(temp_return);
                if(!temp_return){
                    return 0;
                }
                count++;
            }
            else{
                wait_us(50);
                miso_err_cnt++;
            }
        }
    }
    return 1;
}
//for reseting the transmission call assert function after b5 and b1. after b1 assert_phi_on and after b5 assert_phi_tx. 
//----------------------------------------------------------------------------

# define initiate {\
    gCS_ADF=0;\
    spi.write(0xFF);\
    spi.write(0xFF);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0x08);\
    spi.write(0x14);\
    spi.write(0xFF);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0x08);\
    spi.write(0x15);\
    spi.write(0xFF);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0x09);\
    spi.write(0x24);\
    spi.write(0x20);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0x09);\
    spi.write(0x37);\
    spi.write(0xE0);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0x09);\
    spi.write(0x36);\
    spi.write(0x70);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0x09);\
    spi.write(0x39);\
    spi.write(0x10);\
    gCS_ADF=1;\
}


#define write_data {\
    gCS_ADF=0;\
    spi.write(0x0B);\
    spi.write(0x36);\
    spi.write(0xFF);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    if(buffer_state && last_buffer==false){\
        spi.write(0x18);\
        spi.write(0x20);\
        for(unsigned char i=0; i<112;i++){\
            spi.write(buffer_112[i]);\
        }\
    }\
    else if(last_buffer==false)\
    {\
        spi.write(0x18);\
        spi.write(0x90);\
        for(unsigned char i=0; i<112;i++){\
            spi.write(buffer_112[i]);\
        }\
    }\
    if(last_buffer)\
    {\
     for(unsigned char i=0; i<112;i++){\
            spi.write(buffer_112[i]);\
        }\
        ADF_off = true;\
        gPC.puts("adf_off\r\n");\
    }\
    gCS_ADF=1;\
    buffer_state = !buffer_state;\
}
//void send_tm_from_SD_card(){
//    }
//
void check(){   
    if(IRQ){
        if(!ADF_off){
                write_data;
                ADF_off=true;    
            }
            else{
                write_data;
                snd_tm.transmit_data(buffer_112,&last_buffer);
            }
         }
         else{
            ticker.detach();
            gCS_ADF=0;
            spi.write(0xB1);
            gCS_ADF=1;
            gPC.puts("transmission done\r\n");
            loop_on=false;  
         }   
    }

//
//#define send_data {\
//    gCS_ADF=0;\
//    spi.write(0xBB);\
//    gCS_ADF=1;\
//    gCS_ADF=0;\
//    spi.write(0xFF);\
//    spi.write(0xFF);\
//    gCS_ADF=1;\
//    if(sent_tmfrom_SDcard){\
//        send_tm_from_SD_card();\
//    }else{\
//        transmitdata();\
//    }\
//    write_data;\
//    if(sent_tmfrom_SDcard){\
//        send_tm_from_SD_card();\
//    }else{\
//        transmitdata();\
//    }\
//    write_data;\
//    if(sent_tmfrom_SDcard){\
//        send_tm_from_SD_card();\
//    }else{\
//        transmitdata();\
//    }\
//    gCS_ADF=0;\
//    spi.write(0xB1);\
//    gCS_ADF=1;\
//    wait_us(300);\
//    gCS_ADF=0;\
//    spi.write(0xFF);\
//    spi.write(0xFF);\
//    gCS_ADF=1;\
//    gCS_ADF=0;\
//    spi.write(0xB5);\
//    gCS_ADF=1;\
//    wait_us(300);\
//    gCS_ADF=0;\
//    spi.write(0xFF);\
//    spi.write(0xFF);\
//    gCS_ADF=1;\
//    ticker.attach_us(&check,32000);\
//}

#define send_data {\
    gCS_ADF=0;\
    spi.write(0xBB);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0xFF);\
    spi.write(0xFF);\
    gCS_ADF=1;\
    if(sent_tmfrom_SDcard){\
    }\
    else{\
        snd_tm.transmit_data(buffer_112,&last_buffer);\
    }\
    write_data;\
    if(sent_tmfrom_SDcard){\
    }else{\
        snd_tm.transmit_data(buffer_112,&last_buffer);\
    }\
    write_data;\
    if(sent_tmfrom_SDcard){\
    }else{\
        snd_tm.transmit_data(buffer_112,&last_buffer);\
    }\
    gCS_ADF=0;\
    spi.write(0xB1);\
    gCS_ADF=1;\
    wait_us(300);\
    gCS_ADF=0;\
    spi.write(0xFF);\
    spi.write(0xFF);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0xB5);\
    gCS_ADF=1;\
    wait_us(300);\
    gCS_ADF=0;\
    spi.write(0xFF);\
    spi.write(0xFF);\
    gCS_ADF=1;\
    ticker.attach_us(&check,32000);\
}

void adf_not_SDcard(){
    buffer_state = true;
    last_buffer = false;
    loop_on = true;
    ADF_off = false;
    sent_tmfrom_SDcard = false;
   
 //   signal = COM_MNG_TMTC_SIGNAL_ADF_NSD;
    initial_adf_check;
    initiate;
    send_data;
    
//    gPC.puts("Inside adf transmission\r\n");
//    ADF_non_responsive_timeout.attach(&ADF_non_responsive_fun, 10);

}