// UART ISR
void rx_read(){
    gRX_CURRENT_DATA_NODE->values[gRX_COUNT] = RX1M.getc();
    gFLAGS = gFLAGS | UART_INT_FLAG;
    gCOM_MNG_TMTC_THREAD->signal_set(COM_MNG_TMTC_SIGNAL_UART_INT);
}

// RX_TIMEOUT ISR
void after_receive(){
    gRX_TIMEOUT.detach();
    gFLAGS = gFLAGS | NEW_TC_RECEIVED;
    gCOM_MNG_TMTC_THREAD->signal_set(COM_MNG_TMTC_SIGNAL_UART_INT);
}

// SESSION_TIMOUT ISR
void after_session(){
    gSESSION_TIMEOUT.detach();
    gFLAGS = gFLAGS & (~COM_SESSION_FLAG);
    gCOM_MNG_TMTC_THREAD->signal_set(COM_MNG_TMTC_SIGNAL_UART_INT);
}

#define reset_all {\
    Base_tc *tcp = gHEAD_NODE_TCL;\
    while(tcp != NULL){\
        Base_tc *temp = tcp->next_TC;\
        delete tcp;\
        tcp = temp;\
    }\
    rx_tc_frames = 0;\
    rx_tc_frames = 0;\
    gTOTAL_INCORRECT_SIZE_TC = 0;\
    gTOTAL_CRC_FAIL_TC = 0;\
    gTOTAL_REPEATED_TC = 0;\
    COM_RX_DATA_NODE *dataptr = gRX_HEAD_DATA_NODE;\
    while( dataptr != NULL ){\
        COM_RX_DATA_NODE *temp = dataptr->next_node;\
        delete dataptr;\
        dataptr = temp;\
    }\
    gRX_HEAD_DATA_NODE = new COM_RX_DATA_NODE;\
    gRX_HEAD_DATA_NODE->next_node = NULL;\
    gRX_CURRENT_DATA_NODE = gRX_HEAD_DATA_NODE;\
    gRX_COUNT = 0;\
    /*PENDING : ALL GLOBAL VAARIABLES AND FLAGS*/\
}

#define PUT_RAW_BYTE {\
    if( gRX_COUNT < (RX_BUFFER_LENGTH-1) ){\
        ++gRX_COUNT;\
    }\
    else{\
        gRX_COUNT = 0;\
        gRX_CURRENT_DATA_NODE->next_node = new COM_RX_DATA_NODE;\
        gRX_CURRENT_DATA_NODE = gRX_CURRENT_DATA_NODE->next_node;\
        gRX_CURRENT_DATA_NODE->next_node = NULL;\
    }\
    gRX_TIMEOUT.attach(&after_receive, RX_TIMEOUT_LIMIT);\
}

void COM_MNG_TMTC_FUN(void const *args){
    while(true){
        Thread::signal_wait( COM_MNG_TMTC_SIGNAL_UART_INT );
        if( gFLAGS & UART_INT_FLAG ){
            gFLAGS = gFLAGS & (~UART_INT_FLAG);
            if( !(gFLAGS & COM_SESSION_FLAG) ){
                // PENDING : DISABLE THREADS
                gFLAGS = gFLAGS | COM_SESSION_FLAG;
                gSESSION_TIMEOUT.attach(&after_session, SESSION_TIME_LIMIT);
                gFLAGS = gFLAGS | COM_RX_FLAG;
                PUT_RAW_BYTE;
                // PENDING : MEASURE RSSI
            }
            else if( gFLAGS & COM_RX_FLAG ){
                PUT_RAW_BYTE;
            }
            else{
                gFLAGS = gFLAGS | COM_RX_FLAG;
                PUT_RAW_BYTE;
            }
        }
        else if( (gFLAGS & NEW_TC_RECEIVED) && (gFLAGS & COM_MNG_TMTC_RUNNING_FLAG) ){
            gFLAGS = gFLAGS & (~NEW_TC_RECEIVED);
            gFLAGS = gFLAGS & (~COM_RX_FLAG);

            // DISABLE THE RX1M INTERRUPT
            RX1M.attach(NULL);
            
            while(gRX_COUNT < (RX_BUFFER_LENGTH)){
                gRX_CURRENT_DATA_NODE->values[gRX_COUNT] = 0x00;
                ++gRX_COUNT;
            }
            gRX_COUNT = 0;

            // VERIFY CRC, REPEATED PSC AND UPDATE TOTAL_VALID_TC, INCORRECT SIZE TC, CRC FAIL TC
            raw_data_to_tc();
            if( gTOTAL_VALID_TC > 0 ){
                // CHECK WEATHER TC LIST HAS MISSING TC OR WEATHER LAST FRAME BIT IS HIGH IN THE LAST PSC-TC
                uint8_t tempContinue = 0xFF;
                continueToExecute(tempContinue);
                if(tempContinue == 0x00){
                    // CHECK WEATHER GS VERIFICATION CODE MATCHES
                    uint8_t tempGSver = 0x00;
                    GScodeVerification(tempGSver);
                    if( tempGSver ){
                        gFLAGS = gFLAGS | COM_SESSION_VALIDITY;
                        // PENDING : COM_POWER_ON_TX
                        EXECUTE_OBOSC_ONLY;
                        EXECUTE_TC;
                    }
                    else{
                        gFLAGS = gFLAGS & (~COM_SESSION_VALIDITY);
                        // PENDING : ENABLE THREADS
                        gSESSION_TIMEOUT.detach();
                        gFLAGS = gFLAGS & (~COM_SESSION_FLAG);
                    }
                }
                else{
                    // PENDING : COM_POWER_ON_TX
                    // PENDING : POWER OFF TX
                    RX1M.attach(&rx_read, Serial::RxIrq);
                }
            }
            else if( !(gFLAGS & COM_TX_FLAG) ){
                RX1M.attach(&rx_read, Serial::RxIrq);
                // PENDING : ENABLE THREADS
                gSESSION_TIMEOUT.detach();
                gFLAGS = gFLAGS & (~COM_SESSION_FLAG);
            }
        }
        else if( gFLAGS & COM_PA_HOT_FLAG ){
            uint8_t tempPA = 0xFF;
            isPAhot(tempPA);
            if( tempPA == 0x00 ){
                gCOM_PA_COOLING_TIMER.attach(&after_cooling_pa, COM_PA_COOLING_TIME_LIMIT);
            }
            else{
                gFLAGS = gFLAGS & (~COM_PA_HOT_FLAG);
                gCOM_PA_COOLING_TIMER.detach();
                // PENDING : COM POWER ON TX
                EXECUTE_OBOSC_ONLY;
                EXECUTE_TC;
            }
        }
        else{
            // SOME INVALID SIGNAL RECEIVED
            
            // PENDING : COM_POWER_OFF_TX
            reset_all;
            // PENDING : ENABLE THREADS
            gSESSION_TIMEOUT.detach();
            gFLAGS = gFLAGS & (~COM_SESSION_FLAG);
        }
    }
}

void SCIENCE_FUN(void const *args){
//    SPIpayload.format(8,0);
//    SPIpayload.frequency(1000000);
    for ( int i = 0 ; i < PAYLOAD_BUFFER_LENGTH ; i++ ){
        gPAYLOAD_BUFFER[i] = 1;
    }

    // initialise the buffer for dma
    // SPIpayload.bulkRead_init(VAR_SPACE::payload_dma_buffer, PAYLOAD_DMA_SIZE, &payload_interrupt_fun);
    // start dma read
    // SPIpayload.bulkRead_start();

    // attach DMA interrupt
    while(true){
         gSCIENCE_THREAD->signal_wait(0x01);

//*********************************************************THE TEST
        
        //read rtc time later
        uint64_t RTC_time = 0;
        Science_Data_Compression::complete_compression( gPAYLOAD_BUFFER , RTC_time);
//        SPI_mutex.lock();
//        disk_write(SDcard_lastWritten ,  5);
//        SPI_mutex.unlock();

//**********************************************THE TEST



//        counter_for_payload++;
//        if(counter_for_payload == 10){
//         payload_ticker.detach();
//         ledg = 0;
//         PC.puts("its over\r\n");
//        }
        
        
        
        
//        SPIpayload.bulkRead_start();

    }
}