// 8 Jul
// did flowchart of states

// handle sd card with cdms team

// Jun 6
// WHAT IS TC exec code in L1 ack ? 

#define delete_TC(tc_ptr) {\
    if(tc_ptr == gHEAD_NODE_TCL){\
        gHEAD_NODE_TCL = tc_ptr->next_TC;\
    }\
    delete tc_ptr;\
}

// typeof tm_ptr: Base_tm
// typeof tc_ptr: Base_tc
// typeof temp_xxxx: uint8_t
#define fill_l1_ack(tm_ptr) {\
    uint8_t temp8;\
    tm_ptr->next_TM = NULL;\
    temp8 = 0xA;\
    PUTtmid(tm_ptr->fields, temp8);\
    temp8 = 0x00;\
    PUTshort_or_long_tm(tm_ptr->fields, temp8);\
    tm_ptr->TM_string[0] = TMID_ACK_L1 << 4;\
    tm_ptr->TM_string[1] = gTOTAL_INCORRECT_SIZE_TC & 0xFF;\
    tm_ptr->TM_string[2] = gTOTAL_CRC_FAIL_TC & 0xFF;\
    tm_ptr->TM_string[3] = (gMASTER_STATE << 4) & 0xF0;\
}

#define put_crc_l1_ack(tm_ptr, num_crc) {\
    tm_ptr->TM_string[2] = num_crc & 0xFF;\
    crc_checksum = crc16_gen(tm_ptr->TM_string, TM_SHORT_SIZE-2);\
    tm_ptr->TM_string[TM_SHORT_SIZE-2] = (crc_checksum >> 8) & 0xFF;\
    tm_ptr->TM_string[TM_SHORT_SIZE-1] = crc_checksum & 0xFF;\
}

#define detect_ack(tm_ptr, temp_ack) {\
    uint8_t temp8;\
    if( tm_ptr != NULL ){\
        temp8 = tm_ptr->TM_string[3];\
        if((temp8 == 0xE0) || (temp8 == 0xA0) || (temp8 == 0xC0))\
            temp_ack = 0x01;\
        else\
            temp_ack = 0x00;\
    }\
    else\
        temp_ack = 0x00;\
}

#define isit_obosc(tc_ptr, temp_obosc) {\
    temp_obosc = 0x00;\
    if( GETapid(tc_ptr) == 2 ){\
        if( ((tc_ptr->TC_string[2]) >> 4) == 0xB ){\
            switch( (tc_ptr->TC_string[2]) & 0xf ){\
                case 1:\
                case 2:\
                case 5:\
                case 6:\
                case 15:\
                    temp_obosc = 0x01;\
            }\
        }\
    }\
}

#define isit_sdcard(tc_ptr, temp_sdcard) {\
    temp_sdcard = 0x00;\
    if( GETapid(tc_ptr) == 2 ){\
        if( ( (tc_ptr->TC_string[2]) >> 4) == 0xF ){\
            switch( (tc_ptr->TC_string[2]) & 0xf ){\
                case 0:\
                case 1:\
                case 2:\
                case 3:\
                case 4:\
                    temp_sdcard = 0x01;\
            }\
        }\
    }\
}

#define isPAhot(returnHere){\
    /*PENDING : COMPLETE THIS FUNCTION*/\
    returnHere = 0xFF;\
}

void after_cooling_pa(){
    gCOM_MNG_TMTC_THREAD->signal_set(COM_MNG_TMTC_SIGNAL_UART_INT);
}

/*
@brief:     check for missing tc, also check crc, i.e. 
            if true execution can be started else have to wait
            decide the next state
@param:     none
@return:    bool indicating whether there are missing tc
*/
// PENDING: LAST FRAME BIT
/*
for loop: check for missing tc
if: check for incorrect sized tc
if: check for last frame bit
*/
#define continueToExecute(returnHere) {\
    uint8_t tempReturn = 0x00;\
    for(uint8_t p = PSC_START_VALUE ; p < (gTOTAL_VALID_TC + PSC_START_VALUE) ; ++p){\
        bool flag = false;\
        Base_tc *node_ptr = gHEAD_NODE_TCL;\
        while(node_ptr != NULL){\
            if( (GETpacket_seq_count(node_ptr) == p) && (GETcrc_pass(node_ptr) == 1) ){\
                flag = true;\
                break;\
            }\
            else{\
                node_ptr = node_ptr->next_TC;\
            }\
        }\
        if(flag == false){\
            tempReturn = 0x02;\
            break;\
        }\
    }\
    Base_tc *tcp = gHEAD_NODE_TCL;\
    while(tcp != NULL){\
        if(GETpacket_seq_count(tcp) == (gTOTAL_VALID_TC + PSC_START_VALUE - 1)){\
            if( ( (tcp->TC_string[1]) & 0x20 ) == 0x00 ){\
                tempReturn = tempReturn + 0x01;\
            }\
            break;\
        }\
        tcp = tcp->next_TC;\
    }\
    returnHere = tempReturn;\
}

/*
return 1 if code match
return 0 if code mismatch
*/
#define GScodeVerification(returnHere){\
    Base_tc *testTC = gHEAD_NODE_TCL;\
    uint16_t overflowCount = 0;\
    returnHere = 0;\
    while( (overflowCount < TCL_OVERFLOW_CONSTANT) && (testTC != NULL) ){\
        if( (GETpacket_seq_count(testTC) == PSC_CALLSIGN) && (GETapid(testTC) == APID_CALLSIGN) ){\
            uint8_t temp8 = testTC->TC_string[1];\
            if( temp8 & 0x04 ){\
                for( int i = 2 ; i <= 8 ; ++i ){\
                    if( testTC->TC_string[i] != gGSCODE[i-2] ){\
                        returnHere = 0;\
                        break;\
                    }\
                }\
            }\
            break;\
        }\
        testTC = testTC->next_TC;\
        ++overflowCount;\
    }\
}

/*
@brief:     DELETE THE CRC FAILED TC FROM THE LIST TO FREE-UP MEMORY AND UPDATE 
            THE TOTAL VALID TC AND GENERATE L1_ACK_TM
@param:     none
@return:    none
*/
#define send_l1_ack {\
    Base_tc *current_TC = gHEAD_NODE_TCL;\
    Base_tm *l1_ack = new Short_tm;\
    Base_tm *l1_ack_head = l1_ack;\
    fill_l1_ack(l1_ack);\
    int TC_count = 0;\
    uint16_t crc_checksum = 0;\
    while(current_TC != NULL){\
        /*IF CRC PASS*/\
        if( (GETcrc_pass(current_TC) == 1) ){\
            if(TC_count > 4){\
                /*extend the TM linked list*/\
                TC_count = 0;\
                l1_ack->next_TM = new Short_tm;\
                l1_ack = l1_ack->next_TM;\
                fill_l1_ack(l1_ack);\
                /*PENDING: FILL TC_EXEC_CODE, APPEND CRC TO THE TM*/\
                put_crc_l1_ack( l1_ack, gTOTAL_CRC_FAIL_TC );\
            }\
            /*PSC starts from 7th byte*/\
            l1_ack->TM_string[6+TC_count] = current_TC->TC_string[0];\
            /*TC exec status*/\
            switch(TC_count){\
                case 0:\
                    l1_ack->TM_string[3] |= (GETexec_status(current_TC)) & 0x0F;\
                    break;\
                case 1:\
                    l1_ack->TM_string[4] = (GETexec_status(current_TC) << 4) & 0xF0;\
                    break;\
                case 2:\
                    l1_ack->TM_string[4] |= (GETexec_status(current_TC)) & 0x0F;\
                    break;\
                case 3:\
                    l1_ack->TM_string[5] = (GETexec_status(current_TC) << 4) & 0xF0;\
                    break;\
                case 4:\
                    l1_ack->TM_string[5] |= (GETexec_status(current_TC)) & 0x0F;\
            }\
            ++TC_count;\
        }\
        current_TC = current_TC->next_TC;\
    }\
    /*FILL UP THE REMAINING FIELDS WITH 0x01: 0x00 => problem with GS*/\
    if(TC_count < 5){\
        while(TC_count < 5){\
            l1_ack->TM_string[6+TC_count] = current_TC->TC_string[0];\
            switch(TC_count){\
                case 0:\
                    l1_ack->TM_string[3] |= (GETexec_status(current_TC)) & 0x0F;\
                    break;\
                case 1:\
                    l1_ack->TM_string[4] = (GETexec_status(current_TC) << 4) & 0xF0;\
                    break;\
                case 2:\
                    l1_ack->TM_string[4] |= (GETexec_status(current_TC)) & 0x0F;\
                    break;\
                case 3:\
                    l1_ack->TM_string[5] = (GETexec_status(current_TC) << 4) & 0xF0;\
                    break;\
                case 4:\
                    l1_ack->TM_string[5] |= (GETexec_status(current_TC)) & 0x0F;\
            }\
            ++TC_count;\
        }\
        put_crc_l1_ack(l1_ack, gTOTAL_CRC_FAIL_TC);\
    }\
    gPC.puts("Sending l1 ack\r\n");\
    snd_tm.head_pointer(l1_ack_head);\
    adf_not_SDcard();\
    /*delete the TM*/\
    l1_ack = l1_ack_head;\
    while(l1_ack != NULL){\
        Base_tm *temp = l1_ack->next_TM;\
        delete l1_ack;\
        l1_ack = temp;\
    }\
}

// CDMS TEAM CODE START
#define CDMS_RLY_TMTC(tc_ptr, tm_ptr){\
    tm_ptr = NULL;\
}\
// CDMS TEAM CODE END

// EXECUTE OBOSC
#define execute_obosc_core(tc_ptr, tm_ptr) {\
    uint8_t service_subtype = (tc_ptr->TC_string[2]) & 0x0F;\
    /*including both lower and upper limits*/\
    uint8_t targetL = tc_ptr->TC_string[3];\
    uint8_t targetU = targetL + tc_ptr->TC_string[4] - 1;\
    if( (targetL == 0x00) && (tc_ptr->TC_string[4] == 0) ){\
        /*PENDING: ALL REPORTS BELOW*/\
        switch(service_subtype){\
            case OBOSC_SUB_REP_TCL_D:\
                break;\
            case OBOSC_SUB_REP_LE:\
                break;\
            case OBOSC_SUB_RESET:\
                break;\
            case OBOSC_SUB_REP_TCL:\
                break;\
        }\
    }\
    else{\
        uint16_t temp16 = 2;\
        switch( service_subtype ){\
            case OBOSC_SUB_DISABLE:\
                temp16 = 2;\
                break;\
            case OBOSC_SUB_RETRY:\
                temp16 = 3;\
                break;\
        }\
        Base_tc *tcp = gHEAD_NODE_TCL;\
        while( tcp != NULL ){\
            uint16_t tcPSC = GETpacket_seq_count(tcp);\
            if( (tcPSC >= targetL) && (tcPSC <= targetU) ){\
                PUTexec_status(tcp, temp16);\
            }\
            tcp = tcp->next_TC;\
        }\
    }\
    /*PENDING: generate L234 ACK*/\
    tm_ptr = NULL;\
}

#define EXECUTE_OBOSC_ONLY {\
    for(uint8_t execute_psc = gOBOSC_PSC ; execute_psc < (gTOTAL_VALID_TC+PSC_START_VALUE) ; ++execute_psc){\
        Base_tc* current_TC = gOBOSC_HEAD;\
        while( current_TC != NULL ){\
            if( (GETcrc_pass(current_TC) == 1) && (GETpacket_seq_count(current_TC) == execute_psc) ){\
                uint8_t current_exec_status = GETexec_status(current_TC);\
                if( (current_exec_status == TC_STATE_SUCCESSFULLY_EXECUTED) || (current_exec_status == TC_STATE_DISABLED) )\
                    break;\
                else if( (current_exec_status == TC_STATE_EXECUTION_FAILED) && (GETabort_on_nack(current_TC) == 1) ){\
                    gMASTER_STATE = TCL_STATE_ABORTED;\
                    break;\
                }\
                else if( (current_exec_status == TC_STATE_UNEXECUTED) || (current_exec_status == TC_STATE_MARKED_RETRY) ){\
                    Base_tm* tm_ptr = NULL;\
                    uint8_t temp82 = 0x00;\
                    isit_obosc(current_TC, temp82);\
                    if(temp82 == 0x01){\
                        /*EXECUTION OF OBOSC TC*/\
                        execute_obosc_core(current_TC, tm_ptr);\
                    }\
                    snd_tm.head_pointer(tm_ptr);\
                    adf_not_SDcard();\
                    uint8_t temp83 = 0x00;\
                    detect_ack(tm_ptr, temp83);\
                    if( temp83 == 0x01){\
                        uint16_t temp16 = TC_STATE_SUCCESSFULLY_EXECUTED;\
                        PUTexec_status(current_TC, temp16);\
                    }\
                    else{\
                        uint16_t temp16 = TC_STATE_EXECUTION_FAILED;\
                        PUTexec_status(current_TC, temp16);\
                    }\
                    /*update last executed L1_ack*/\
                    if( tm_ptr != NULL ){\
                        for(int i = 0 ; i < TM_SHORT_SIZE ; ++i){\
                            gLAST_L1_ACK[i] = gLAST_L1_ACK_BUFFER[i];\
                            gLAST_L1_ACK_BUFFER[i] = tm_ptr->TM_string[i];\
                        }\
                    }\
                    /*DELETE THE TM AFTER USE*/\
                    while(tm_ptr != NULL){\
                        Base_tm *temp = tm_ptr->next_TM;\
                        delete tm_ptr;\
                        tm_ptr = temp;\
                    }\
                }\
            }\
            current_TC = current_TC->next_TC;\
        }\
    }\
}

#define EXECUTE_TC {\
    for(uint8_t execute_psc = PSC_START_VALUE ; execute_psc < (PSC_START_VALUE+gTOTAL_VALID_TC) ; ++execute_psc ){\
        /*gLEDG = !gLEDG;*/\
        /*gLEDR = !gLEDR;*/\
        uint8_t tempPAhot = 0xFF;\
        Base_tc* current_TC = gHEAD_NODE_TCL;\
        while(current_TC != NULL){\
            if( (GETcrc_pass(current_TC) == 1) && (GETpacket_seq_count(current_TC) == execute_psc) ){\
                uint8_t current_exec_status = GETexec_status(current_TC);\
                if( (current_exec_status == TC_STATE_SUCCESSFULLY_EXECUTED) || (current_exec_status == TC_STATE_DISABLED) )\
                    break;\
                else if( (current_exec_status == TC_STATE_EXECUTION_FAILED) && (GETabort_on_nack(current_TC) == 1) ){\
                    gMASTER_STATE = TCL_STATE_ABORTED;\
                    break;\
                }\
                else if( (current_exec_status == TC_STATE_UNEXECUTED) || (current_exec_status == TC_STATE_MARKED_RETRY) ){\
                    /*EXECUTION OF TC START*/\
                    uint8_t temp81 = 0x00;\
                    isit_sdcard(current_TC, temp81);\
                    if( temp81 == 0x00 ){\
                        /*EXECUTION OF NON SD-CARD (BOTH OBOSC and CDMS functions)*/\
                        Base_tm *tm_ptr;\
                        uint8_t temp82 = 0x00;\
                        isit_obosc(current_TC, temp82);\
                        if(temp82 == 0x01){\
                            /*EXECUTION OF OBOSC TC*/\
                            execute_obosc_core(current_TC, tm_ptr);\
                        }\
                        else{\
                            /*call CDMS_RLY_TMTC*/\
                            CDMS_RLY_TMTC(current_TC, tm_ptr);\
                        }\
                        /*CHECK FOR HOT PA*/\
                        isPAhot(tempPAhot);\
                        if( tempPAhot == 0x00 ){\
                            gFLAGS = gFLAGS | COM_PA_HOT_FLAG;\
                        }\
                        /*SEND DATA TO GS*/\
                        snd_tm.head_pointer(tm_ptr);\
                        adf_not_SDcard();\
                        uint8_t temp83 = 0x00;\
                        detect_ack(tm_ptr, temp83);\
                        if( temp83 == 0x01){\
                            uint16_t temp16 = TC_STATE_SUCCESSFULLY_EXECUTED;\
                            PUTexec_status(current_TC, temp16);\
                        }\
                        else{\
                            uint16_t temp16 = TC_STATE_EXECUTION_FAILED;\
                            PUTexec_status(current_TC, temp16);\
                        }\
                        /*update last executed L1_ack*/\
                        if( tm_ptr != NULL ){\
                            for(int i = 0 ; i < TM_SHORT_SIZE ; ++i){\
                                gLAST_L1_ACK[i] = gLAST_L1_ACK_BUFFER[i];\
                                gLAST_L1_ACK_BUFFER[i] = tm_ptr->TM_string[i];\
                            }\
                        }\
                        /*DELETE THE TM AFTER USE*/\
                        while(tm_ptr != NULL){\
                            Base_tm *temp = tm_ptr->next_TM;\
                            delete tm_ptr;\
                            tm_ptr = temp;\
                        }\
                    }\
                    else{\
                        /*EXECUTION OF SD-CARD DATA SENDING (OBSRS)*/\
                        /*CHECK FOR HOT PA*/\
                        isPAhot(tempPAhot);\
                        if( tempPAhot == 0x00 ){\
                            gFLAGS = gFLAGS | COM_PA_HOT_FLAG;\
                        }\
                        read_TC(current_TC);\
                    }\
                    /*ABORT ON NACK*/\
                    if( (GETexec_status(current_TC) == TC_STATE_EXECUTION_FAILED) && (GETabort_on_nack(current_TC) == 1) ){\
                        gMASTER_STATE = TCL_STATE_ABORTED;\
                    }\
                }\
            }\
            current_TC = current_TC->next_TC;\
        }\
        if( !(execute_psc == (PSC_START_VALUE+gTOTAL_VALID_TC-1)) ){\
            if( tempPAhot == 0 ){\
                gCOM_PA_COOLING_TIMER.attach(&after_cooling_pa, COM_PA_COOLING_TIME_LIMIT);\
                /*PENDING : POWER OFF COMM TX*/\
                RX1M.attach(&rx_read, Serial::RxIrq);\
                gFLAGS = gFLAGS & (~COM_MNG_TMTC_RUNNING_FLAG);\
                break;\
            }\
        }\
        else if( gMASTER_STATE == TCL_STATE_ABORTED ){\
            /*PENDING : POWER OFF COM TX*/\
            RX1M.attach(&rx_read, Serial::RxIrq);\
            gFLAGS = gFLAGS & (~COM_MNG_TMTC_RUNNING_FLAG);\
            break;\
        }\
        else{\
            /*PENDING : COM POWER OFF TX*/\
            reset_all;\
            /*PENDING : ENABLE THREADS*/\
            gSESSION_TIMEOUT.detach();\
            gFLAGS = gFLAGS & (~COM_SESSION_FLAG);\
            break;\
        }\
    }\
}