#include "tx.h"
#include <stdio.h>

Ticker loop;
Serial pc(USBTX, USBRX);        //tx,rx
SPI spi(D11, D12, D13);              // mosi, miso, sclk
DigitalOut cs(D10);                //slave select or chip select

Timer t;

void P_BCN_INIT()
{
    BCN_INIT_STATUS = 1;
    //check initialization parameters
    Init_BEACON_HW();
    //t.start();
    BCN_INIT_STATUS = 0;
}
void P_BCN_FEN()
{
    BCN_FEN = 1;
}
void P_BCN_TX_MAIN()
{
    pc.printf("line 25");
    BCN_TX_MAIN_STATUS = 1;
    
    if(BCN_FEN == 1)
    {
        pc.printf("line 30");
        if(BCN_TX_EN == 1)
        {
            pc.printf("line 33");
            //Measure and store BCN temperature in BCN_TS_BUFFER
            BCN_TS_BUFFER = check_Temperature();
            pc.printf("\n\ntemperature = %d\n\n",BCN_TS_BUFFER);
            pc.printf("line 36");
            //Get BCN_HK data from BCN HW(SPI) //Store BCN_HK data in BCN_HK_BUFFER
            if(BCN_STANDBY == 1 )
            {
                pc.printf("line 40");
                Set_BCN_TX_STATUS(BCN_TX_STANDBY);
                BCN_TX_MAIN_STATUS = 0;
                
                // break;
            }
            else
            {
                //pc.printf("in BCN_TX_STANDBY != 1\r\n");
                pc.printf("line 49");
                    t.start();
                    int begin = t.read_us();
                    //pc.printf("line 52");
                    SHORT_BCN_TX();
                    LONG_BCN_TX();
                    //pc.printf("line 55");
                    t.stop();
                    int end = t.read_us();
                    pc.printf("\n\nThe time required for short and long is %d seconds\r\n\n", end-begin);
                    pc.printf("Short and Long packets sent\r\n");
                    //include LONG_BCN_TX also
                    if(Check_ACK_RECEIVED() == 1)
                    {
                        Set_BCN_TX_STATUS(BCN_TX_SUCCESS);
                        BCN_TX_MAIN_STATUS = 0;
                        // break;
                        
                    }
                    else
                    {
                        Set_BCN_TX_STATUS(BCN_TX_FAILURE);
                        BCN_TX_MAIN_STATUS = 0;
                        // break;
                        
                    }
             }
        }
        else
        {
            Set_BCN_TX_STATUS(BCN_TX_DISABLED);
            BCN_TX_MAIN_STATUS = 0;
            // break;
            
        }
    }
    else
    {
        Set_BCN_TX_STATUS(BCN_RF_SILENCE);  //Window of RF Silence: None of the Txs should be on.
        BCN_TX_MAIN_STATUS = 0;
        // break;
    }
}

void Set_BCN_TX_STATUS(uint8_t STATUS)
{
    BCN_TX_STATUS = STATUS;
}

int check_Temperature()
{   
    int temperature;
    //P_BCN_INIT();
    writereg(RF22_REG_0F_ADC_CONFIGURATION,0x80);            //128 = 10000000
    writereg(RF22_REG_12_Temperature_Sensor_Calibration,0x20); //160 == 10100000 32 == 00100000
    wait(1);
    temperature = readreg(RF22_REG_11_ADC_Value);
    temperature = (float)temperature*0.5 - 64;
    return temperature;
}
void SHORT_BCN_TX()
{
    writereg(RF22_REG_6E_TX_DATA_RATE,0x01);
    writereg(RF22_REG_6F_TX_DATA_RATE,0x4F);//160bps
    writereg(RF22_REG_3E_PACKET_LENGTH,SHORT_TX_DATA); //short packet length
    /*
    init();
    //init complete
    pc.printf("init complete.....press t to send\n");
    while(pc.getc()=='t')
    {   */
    //button.rise(&interrupt_func);         //interrupt enabled ( rising edge of pin 9)
    wait(0.02);                                                           // pl. update this value  or even avoid it!!!                  
    int i=0;
    
    //extract values from short_beacon[]
    struct Short_beacon
    {
        uint8_t Voltage[1];
        uint8_t AngularSpeed[2];
        uint8_t SubsystemStatus[1];
        uint8_t Temp[3];
        uint8_t ErrorFlag[1];
    }Shortbeacon = { {0x88}, {0x99, 0xAA} , {0xAA},{0xAA,0xDD,0xEE}, {0x00} };
    
    //filling hk data
    uint8_t short_beacon[] = { 0xAB, 0x8A, 0xE2, 0xBB, 0xB8, 0xA2, 0x8E,Shortbeacon.Voltage[0],Shortbeacon.AngularSpeed[0], Shortbeacon.AngularSpeed[1],Shortbeacon.SubsystemStatus[0],Shortbeacon.Temp[0],Shortbeacon.Temp[1],Shortbeacon.Temp[2],Shortbeacon.ErrorFlag[0]};
    //uint8_t short_beacon[] = { 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77,Shortbeacon.Voltage[0],Shortbeacon.AngularSpeed[0], Shortbeacon.AngularSpeed[1],Shortbeacon.SubsystemStatus[0],Shortbeacon.Temp[0],Shortbeacon.Temp[1],Shortbeacon.Temp[2],Shortbeacon.ErrorFlag[0]};
    
    /*uint8_t short_beacon[15];
    for(int i = 0;i<15;i++)
    {
        short_beacon[i] = 0xAA;
    }*/
    
    //writereg(RF22_REG_07_OPERATING_MODE1,0x01);        //ready mode       ??    
    clearTxBuf();     
    //writing data first time
    int byte = 0;
    cs = 0;
    spi.write(0xFF);   
    //pc.printf("line 151");
    for (int byte_counter = 0; byte_counter <15 ; byte_counter++)
    {
        for(int j = 3; j >= 0 ; j--)
        {
            if((short_beacon[byte_counter] & (uint8_t) pow(2.0,(j*2+1)))!= pow(2.0,(j*2+1)))
            {
                byte=0x00;
            }
            else
            { 
                byte=0xF0;
            }  
            if((short_beacon[byte_counter] & (uint8_t) pow(2.0,j*2))!= pow(2.0,j*2))
            {
                byte=byte | 0x00;
            }
            else
            { 
               byte=byte | 0x0F;
            }
            spi.write(byte);
         }
    }   
    
    cs = 1;
    //pc.printf("line 177\n");
    //Set to Tx mode
    writereg(RF22_REG_07_OPERATING_MODE1,0x09);
      
    //Check for fifoThresh
    while((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x20) != 0x20);
    //pc.printf("fifothresh1?\n");
    //pc.printf("line 184\n");
    //rf22.waitPacketSent();
    while((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x04) != 0x04);
        //pc.printf(" chk pkt sent!\r\n");     
    //pc.printf("Short packet sent\r\n");
    
    writereg(RF22_REG_07_OPERATING_MODE1,0x00);        //standby mode
    
}
void LONG_BCN_TX()
{
    writereg(RF22_REG_6E_TX_DATA_RATE,0x04);
    writereg(RF22_REG_6F_TX_DATA_RATE,0xEA);
    writereg(RF22_REG_3E_PACKET_LENGTH,LONG_TX_DATA); //long packet length
    wait(0.02);                                                           // pl. update this value  or even avoid it!!!                  
    //extract values from long_beacon[]
    
    //uint8_t Long_beacon[] = { 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77,Longbeacon.Voltage[0],Longbeacon.AngularSpeed[0], Longbeacon.AngularSpeed[1],Longbeacon.SubsystemStatus[0],Longbeacon.Temp[0],Longbeacon.Temp[1],Longbeacon.Temp[2],Longbeacon.ErrorFlag[0]};
    
    uint8_t Long_beacon[75];
    for(int i = 0;i<75;)
    {
        Long_beacon[i++] = 0xAB;Long_beacon[i++] = 0xCD;Long_beacon[i++] = 0xAB;Long_beacon[i++] = 0xCD;Long_beacon[i++] = 0x00;
    }
    
    //setModeIdle();
    writereg(RF22_REG_07_OPERATING_MODE1,0x01);        //ready mode    
    clearTxBuf();     
    //writing data first time
    cs = 0;
    spi.write(0xFF);   
    for(int i=0; i<60;i++)
    {
        spi.write(Long_beacon[i]);
    }
    cs = 1;
    
    //Set to Tx mode
    writereg(RF22_REG_07_OPERATING_MODE1,0x09);

    //Check for fifoThresh
    while((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x20) != 0x20);
    //pc.printf("fifothresh1?\n");
    //writing data first time
    cs = 0;
    spi.write(0xFF);   
    for(int i=60; i<75;i++)
    {
        spi.write(Long_beacon[i]);
    }
    cs = 1;
    wait(0.01);
    //Check for fifoThresh
    while((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x20) != 0x20);
    //pc.printf("fifothresh2?\n");      
    //rf22.waitPacketSent();
    while((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x04) != 0x04);
        //pc.printf(" chk pkt sent!]\r\n");     
    pc.printf("Long packet sent\r\n");
    writereg(RF22_REG_07_OPERATING_MODE1,0x00);        //standby mode
}
void reset_uC()
{
    printf("reset uC");
}
void writereg(uint8_t reg,uint8_t val)
{
    int read_val =0; cs = 0;spi.write(reg | 0x80);spi.write(val);cs = 1;// wait(1);read_val = readreg(reg);if(read_val != val) {reset_uC();pc.printf("value for 0x%X written incorrectly to the uC\n",reg);} 
}
uint8_t readreg(uint8_t reg)
{
    int val;cs = 0;spi.write(reg & ~0x80);val = spi.write(0);cs = 1;return val;
}
void clearTxBuf()
{
    writereg(RF22_REG_08_OPERATING_MODE2,0x01);
    writereg(RF22_REG_08_OPERATING_MODE2,0x00);
}
int setFrequency(double centre,float afcPullInRange)
{
//freq setting begins 
    uint8_t fbsel = 0x40;
    uint8_t afclimiter;
    if (centre >= 480.0) {
        centre /= 2;
        fbsel |= 0x20;
        afclimiter = afcPullInRange * 1000000.0 / 1250.0;
    } else {
        if (afcPullInRange < 0.0 || afcPullInRange > 0.159375)
            return false;
        afclimiter = afcPullInRange * 1000000.0 / 625.0;
    }
    centre /= 10.0;
    double integerPart = floor(centre);
    double fractionalPart = centre - integerPart;
 
    uint8_t fb = (uint8_t)integerPart - 24; // Range 0 to 23
    fbsel |= fb;
    uint16_t fc = fractionalPart * 64000;
    writereg(RF22_REG_73_FREQUENCY_OFFSET1, 0);  // REVISIT
    writereg(RF22_REG_74_FREQUENCY_OFFSET2, 0);
    writereg(RF22_REG_75_FREQUENCY_BAND_SELECT, fbsel);
    writereg(RF22_REG_76_NOMINAL_CARRIER_FREQUENCY1, fc >> 8);
    writereg(RF22_REG_77_NOMINAL_CARRIER_FREQUENCY0, fc & 0xff);
    writereg(RF22_REG_2A_AFC_LIMITER, afclimiter);
    return 0;
}
void Init_BEACON_HW()
{
    cs=1;                          // chip must be deselected
    //wait(1);                    //change the time later
    spi.format(8,0);
    spi.frequency(10000000);       //10MHz SCLK
    
    //should either have a flag for invalid SPI or discard this for actual case or add reset
    if (readreg(RF22_REG_00_DEVICE_TYPE) == 0x08)
        pc.printf("spi connection valid\r\n");
    else
        pc.printf("error in spi connection\r\n");
    //reset()
    
    
    writereg(RF22_REG_07_OPERATING_MODE1,0x80);        //sw_reset
    wait(1);                    //takes time to reset                                  

    clearTxBuf();                                                                                                                         
    
    writereg(RF22_REG_07_OPERATING_MODE1,0x00);        //standby mode
       
    //txfifoalmostempty
    writereg(RF22_REG_7D_TX_FIFO_CONTROL2,30);

    //Packet-engine registers
    writereg(RF22_REG_30_DATA_ACCESS_CONTROL,0x00);     //RF22_REG_30_DATA_ACCESS_CONTROL, RF22_ENPACRX | RF22_ENPACTX | RF22_ENCRC | RF22_CRC_CRC_16_IBM
    //&0x77 = diasable packet rx-tx handling
    
    writereg(RF22_REG_33_HEADER_CONTROL2,0x08);    //RF22_REG_33_HEADER_CONTROL2, RF22_HDLEN_4 | RF22_SYNCLEN_2
    writereg(RF22_REG_34_PREAMBLE_LENGTH,0x00);       //RF22_REG_34_PREAMBLE_LENGTH, nibbles); preamble length = 8;
   //may be redundant since packethandler is disabled

    writereg(RF22_REG_0B_GPIO_CONFIGURATION0,0x15); // TX state                        ??
    writereg(RF22_REG_0C_GPIO_CONFIGURATION1,0x12); // RX state                        ??

    //interrupts
    // spiWrite(RF22_REG_05_INTERRUPT_ENABLE1, RF22_ENTXFFAEM |RF22_ENRXFFAFULL | RF22_ENPKSENT |RF22_ENPKVALID| RF22_ENCRCERROR);
    // spiWrite(RF22_REG_06_INTERRUPT_ENABLE2, RF22_ENPREAVAL);

    setFrequency(435.00015625,0.05);//435.000156.25, observed = 434.99818100

    //This may not be required
    if((readreg(RF22_REG_02_DEVICE_STATUS)& 0x08)!= 0x00)
        {pc.printf("frequency not set properly\r\n");reset_uC();}
        
    //frequency set

    //setModemConfig(FSK_Rb2_4Fd36);       FSK_Rb2_4Fd36,       ///< FSK, No Manchester, Rb = 2.4kbs,  Fd = 36kHz
    //setmodemregisters
    //0x1b, 0x03, 0x41, 0x60, 0x27, 0x52, 0x00, 0x07, 0x40, 0x0a, 0x1e, 0x80, 0x60, 0x13, 0xa9, 0x2c, 0x22, 0x3a = FSK_RB2_4FD36
    //0xc8, 0x03, 0x39, 0x20, 0x68, 0xdc, 0x00, 0x6b, 0x2a, 0x08, 0x2a, 0x80, 0x60, 0x13, 0xa9, 0x2c, 0x21, 0x08 = OOK,2.4, 335
    writereg(RF22_REG_1C_IF_FILTER_BANDWIDTH,0xdf);
    writereg(RF22_REG_1F_CLOCK_RECOVERY_GEARSHIFT_OVERRIDE,0x03);
    writereg(RF22_REG_20_CLOCK_RECOVERY_OVERSAMPLING_RATE,0x39);
    writereg(RF22_REG_21_CLOCK_RECOVERY_OFFSET2,0x20);                     
    writereg(RF22_REG_22_CLOCK_RECOVERY_OFFSET1,0x68);           //updated 20 to 25 reg values from excel sheet for 1.2 Khz freq. deviation,fsk
    writereg(RF22_REG_23_CLOCK_RECOVERY_OFFSET0,0xdc);
    writereg(RF22_REG_24_CLOCK_RECOVERY_TIMING_LOOP_GAIN1,0x00);
    writereg(RF22_REG_25_CLOCK_RECOVERY_TIMING_LOOP_GAIN0,0x6B);
    writereg(RF22_REG_2C_OOK_COUNTER_VALUE_1,0x2C);
    writereg(RF22_REG_2D_OOK_COUNTER_VALUE_2,0x11);    //not required for fsk (OOK counter value)
    writereg(RF22_REG_2E_SLICER_PEAK_HOLD,0x2A);         //??
    writereg(RF22_REG_58,0x80);
    writereg(RF22_REG_69_AGC_OVERRIDE1,0x60);
    
    
    //writereg(RF22_REG_6E_TX_DATA_RATE_0.125_1,0x09);//written later
    //writereg(RF22_REG_6F_TX_DATA_RATE_0.125_0,0xd5);//written later
    
    writereg(RF22_REG_70_MODULATION_CONTROL1,0x20);//changed from 0x2c to 0x20 since machester is not required
    writereg(RF22_REG_71_MODULATION_CONTROL2,0x21);//ook = 0x21 //fsk = 0x22
    
    //writereg(RF22_REG_72_FREQUENCY_DEVIATION,0x50);
    //required for OOK???
    
    //set tx power
    writereg(RF22_REG_6D_TX_POWER,0x07);    //20dbm
    //why 0x06?? 0x07 is for max//is the previous bits required?
    
    //writereg(RF22_REG_3E_PACKET_LENGTH,SHORT_TX_DATA); //short packet length //written later 
}
bool Check_ACK_RECEIVED()
{
    //logic:
    if((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x04) == 0x04)  //bit is set if the data packet is sent correctly
    {
        printf("Packet sent: ACK received\r\n");
        return 1;   //for ACK received: yes

    }
    else
    {
        pc.printf("Packet not sent\r\n");
        return 0;     //actual value
        //return 1;       //to make this function work in any condition  //Why??

    }
}
int main()
{
    
    pc.printf("entered main");
    int temp, final_temp;
    
    P_BCN_INIT(); 
    pc.printf("completed bcn_init");
        
    P_BCN_FEN();
    pc.printf("press 't' to start...");
    //while(1)
    //{
    t.start();
    int begin = t.read_us();
    //SHORT_BCN_TX();
    //LONG_BCN_TX();
    P_BCN_TX_MAIN();
    t.stop();
    int end = t.read_us();
    pc.printf("\n\nThe time taken : %d seconds\r\n\n", end-begin);
    pc.printf("packets sent\r\n");
    //P_BCN_TX_MAIN();
    //}
    
}