#define flushData_appendTC(bytes, outState) {\
    uint16_t tc_type = 2;\
    if( (bytes == TC_SHORT_SIZE) && (outState == 7) ){\
        tc_type = 0;\
    }\
    else if( (bytes == TC_LONG_SIZE) && (outState == 7) ){\
        tc_type = 1;\
    }\
    else{\
        ++gTOTAL_INCORRECT_SIZE_TC;\
    }\
    if( tc_type == 0 ){\
        uint16_t crc_checksum = crc16_gen(rx_tempString, TC_SHORT_SIZE-2);\
        if( ( (crc_checksum & 0xFF) == rx_tempString[TC_SHORT_SIZE-1]) && ( ((crc_checksum >> 8) & 0xFF) == rx_tempString[TC_SHORT_SIZE-2] ) ){\
            uint16_t temp16;\
            Base_tc *temp_ptr = gHEAD_NODE_TCL;\
            bool repeat_flag = false;\
            uint8_t testPSC = rx_tempString[0];\
            while(temp_ptr != NULL){\
                if( GETpacket_seq_count(temp_ptr) == testPSC ){\
                    repeat_flag = true;\
                    break;\
                }\
                temp_ptr = temp_ptr->next_TC;\
            }\
            if( repeat_flag == false ){\
                if( rx_tc_frames == 0 ){\
                    gHEAD_NODE_TCL = new Short_tc;\
                    gHEAD_NODE_TCL->next_TC = NULL;\
                    gLAST_NODE_TCL = gHEAD_NODE_TCL;\
                }\
                else{\
                    gLAST_NODE_TCL->next_TC = new Short_tc;\
                    gLAST_NODE_TCL = gLAST_NODE_TCL;\
                    gLAST_NODE_TCL->next_TC = NULL;\
                }\
                for(int i = 0 ; i < TC_SHORT_SIZE ; ++i){\
                    gLAST_NODE_TCL->TC_string[i] = rx_tempString[i];\
                }\
                PUTshort_or_long(gLAST_NODE_TCL, tc_type);\
                temp16 = 1;\
                PUTcrc_pass(gLAST_NODE_TCL, temp16);\
                temp16 = 0;\
                PUTexec_status(gLAST_NODE_TCL, temp16);\
                ++gTOTAL_VALID_TC;\
            }\
            else{\
                ++gTOTAL_REPEATED_TC;\
            }\
        }\
        else{\
            ++gTOTAL_CRC_FAIL_TC;\
        }\
    }\
    else if( tc_type == 1 ){\
        uint16_t crc_checksum = crc16_gen(rx_tempString, TC_LONG_SIZE-2);\
        if( ( (crc_checksum & 0xFF) == rx_tempString[TC_LONG_SIZE-1]) && ( ((crc_checksum >> 8) & 0xFF) == rx_tempString[TC_LONG_SIZE-2] ) ){\
            uint16_t temp16;\
            Base_tc *temp_ptr = gHEAD_NODE_TCL;\
            bool repeat_flag = false;\
            uint8_t testPSC = rx_tempString[0];\
            while(temp_ptr != NULL){\
                if( GETpacket_seq_count(temp_ptr) == testPSC ){\
                    repeat_flag = true;\
                    break;\
                }\
                temp_ptr = temp_ptr->next_TC;\
            }\
            if( repeat_flag == false ){\
                if( rx_tc_frames == 0 ){\
                    gHEAD_NODE_TCL = new Long_tc;\
                    gHEAD_NODE_TCL->next_TC = NULL;\
                    gLAST_NODE_TCL = gHEAD_NODE_TCL;\
                }\
                else{\
                    gLAST_NODE_TCL->next_TC = new Long_tc;\
                    gLAST_NODE_TCL = gLAST_NODE_TCL->next_TC;\
                    gLAST_NODE_TCL->next_TC = NULL;\
                }\
                for(int i = 0 ; i < TC_LONG_SIZE ; ++i){\
                    gLAST_NODE_TCL->TC_string[i] = rx_tempString[i];\
                }\
                PUTshort_or_long(gLAST_NODE_TCL, tc_type);\
                temp16 = 1;\
                PUTcrc_pass(gLAST_NODE_TCL, temp16);\
                temp16 = 0;\
                PUTexec_status(gLAST_NODE_TCL, temp16);\
                ++gTOTAL_VALID_TC;\
            }\
            else{\
                ++gTOTAL_REPEATED_TC;\
            }\
        }\
        else{\
            ++gTOTAL_CRC_FAIL_TC;\
        }\
    }\
    ++rx_tc_frames;\
}

unsigned int rx_tc_frames = 0;
unsigned char rx_tempString[TC_LONG_SIZE+1];

void raw_data_to_tc(void){
    bool frame_started = false;
    bool chain_started = false;
    bool flush_called = false;

    uint32_t bytes_read = 0;
    uint8_t state7e = 0;
    uint8_t outState = 0;
    uint32_t outByte = 0;
    uint32_t byteCount = 0;
    
    gTOTAL_VALID_TC = 0;
    
    gOBOSC_PSC = PSC_START_VALUE + gTOTAL_VALID_TC - 1;
    gOBOSC_HEAD = gLAST_NODE_TCL;
    
    COM_RX_DATA_NODE *data_node = gRX_HEAD_DATA_NODE;
    // read byte by byte
    while( data_node != NULL ){
        for(int iBuf = 0 ; iBuf < RX_BUFFER_LENGTH ; ++iBuf ){
            uint8_t test_this = data_node->values[iBuf];
            ++bytes_read;
    
            // read bit by bit
            for(int i = 7 ; i >= 0 ; --i){
                unsigned char tempBit = (test_this >> i) & 1;
                bool skipIteration = false;
    
                if( tempBit == 1 ){
                    switch( state7e ){
                        case 0:
                            state7e = 0;
                            break;
                        case 1:
                            state7e = 2;
                            break;
                        case 2:
                            state7e = 3;
                            break;
                        case 3:
                            state7e = 4;
                            break;
                        case 4:
                            state7e = 5;
                            break;
                        case 5:
                            state7e = 6;
                            break;
                        case 6:
                            state7e = 7;
                            break;
                        case 7:
                            // error reset
                            state7e = 0;
                            chain_started = false;
                            frame_started = false;
                            byteCount = 0;
                            outByte = 0;
                            outState = 0;
                            skipIteration = true;
                            break;
                    }
                }
                else{
                    switch( state7e ){
                        case 0:
                        case 1:
                        case 2:
                        case 3:
                        case 4:
                        case 5:
                            state7e = 1;
                            break;
                        case 6:
                            state7e = 1;
                            skipIteration = true;
                            break;
                        case 7:
                            state7e = 0;
                            // detected 7e
                            if( !chain_started ){
                                chain_started = true;
                                frame_started = true;
                                byteCount = 0;
                                outByte = 0;
                                outState = 0;
                                skipIteration = true;
                            }
                            else{
                                flush_called = true;
                                flushData_appendTC(byteCount, outState);
                                byteCount = 0;
                                outState = 0;
                                outByte = 0;
                                skipIteration = true;
                            }
                            break;
                    }
                }
                if( (!skipIteration) && (frame_started) ){
                    // write bit to output
                    switch( outState ){
                        case 0:
                            outState = 1;
                            rx_tempString[outByte] = tempBit << 7;
                            break;
                        case 1:
                            outState = 2;
                            rx_tempString[outByte] += tempBit << 6;
                            break;
                        case 2:
                            outState = 3;
                            rx_tempString[outByte] += tempBit << 5;
                            break;
                        case 3:
                            outState = 4;
                            rx_tempString[outByte] += tempBit << 4;
                            break;
                        case 4:
                            outState = 5;
                            rx_tempString[outByte] += tempBit << 3;
                            break;
                        case 5:
                            outState = 6;
                            rx_tempString[outByte] += tempBit << 2;
                            break;
                        case 6:
                            outState = 7;
                            rx_tempString[outByte] += tempBit << 1;
                            break;
                        case 7:
                            outState = 0;
                            rx_tempString[outByte] += tempBit;
                            ++outByte;
                            // exceeded tc length discard
                            if(outByte > 135){
                                ++gTOTAL_INCORRECT_SIZE_TC;
                                outByte = 0;
                            }
                            ++byteCount;
                            break;
                    }
                }
            }
        }
        COM_RX_DATA_NODE *temp = data_node->next_node;
        delete data_node;
        data_node = temp;
    }
    if( (!flush_called) && (gTOTAL_INCORRECT_SIZE_TC == 0) ){
        ++gTOTAL_INCORRECT_SIZE_TC;
    }
    gRX_HEAD_DATA_NODE = new COM_RX_DATA_NODE;
    gRX_HEAD_DATA_NODE->next_node = NULL;
    gRX_CURRENT_DATA_NODE = gRX_HEAD_DATA_NODE;
    gRX_COUNT = 0;
    
    if( gOBOSC_HEAD != NULL ){
        gOBOSC_HEAD = gOBOSC_HEAD->next_TC;
        if( gOBOSC_HEAD != NULL ){
            ++gOBOSC_PSC;
        }
    }
    
    // PENDING: SORT THE LINKED LIST ACCORDING TO PSC VALUE
}