// TC TM
    #define TC_SHORT_SIZE 11
    #define TC_LONG_SIZE 135
    #define TM_LONG_SIZE 134
    #define TM_SHORT_SIZE 13

// COM_RX
    #define RX_BUFFER_LENGTH 60
    // 60+4 = 64

struct data_node{
   uint8_t values[RX_BUFFER_LENGTH];
   struct data_node* next_node;
};
typedef struct data_node COM_RX_DATA_NODE;

//TELECOMMAND:

/*
exec_status:
0: unexecuted
1: successfully executed
2: Execution Failed
3: Disabled
4: Marked For retry
*/
#define TC_STATE_UNEXECUTED 0x00
#define TC_STATE_SUCCESSFULLY_EXECUTED 0x01
#define TC_STATE_EXECUTION_FAILED 0x02
#define TC_STATE_DISABLED 0x03
#define TC_STATE_MARKED_RETRY 0x04

//MASKS
#define SHORT_LONG_TC_MASK 0x10
#define CRC_MASK 0x08
#define EXEC_STATUS_MASK 0x07

//USE ONLY THE BELOW MACROS TO MODIFY 'flags' VARIABLE
//x should be a Base_tc pointer
#define GETshort_or_long_tc(x) ( ( (x->flags) & SHORT_LONG_TC_MASK ) >> 4 )
#define GETcrc_pass(x) ( ( (x->flags) & CRC_MASK ) >> 3 )
#define GETabort_on_nack(x) ( ( (x->TC_string[1]) & 0x08 ) >> 3 )
#define GETapid(x) ( ( (x->TC_string[1]) & 0xA0 ) >> 6 )
#define GETexec_status(x) ( (x->flags) & EXEC_STATUS_MASK )
#define GETpacket_seq_count(x) (x->TC_string[0])

//x should be a Base_tc pointer
//y should be a 16-bit number with relevant data in LSB
//use in a seperate line with ; at the end: similar to a function
#define PUTshort_or_long(x,y) x->flags = ( (x->flags) & ~(SHORT_LONG_TC_MASK)) | ( (y << 4) & SHORT_LONG_TC_MASK )
#define PUTcrc_pass(x,y) x->flags = ( (x->flags) & ~(CRC_MASK)) | ( (y << 3) & CRC_MASK)
#define PUTexec_status(x,y) x->flags = ( (x->flags) & ~(EXEC_STATUS_MASK)) | ( y & EXEC_STATUS_MASK)

//PARENT TELECOMMAND CLASS
class Base_tc{
public:
    uint8_t flags;
    uint8_t *TC_string;
    Base_tc *next_TC;

    virtual ~Base_tc(){}
};

//DERIVED CLASS - SHORT TC
class Short_tc : public Base_tc{
private:
    uint8_t fix_str[TC_SHORT_SIZE];
public:
    Short_tc(){
        TC_string = fix_str;
        flags = 0;
    }

    ~Short_tc(){}
};

//DERIVED CLASS - LONG TC
class Long_tc : public Base_tc{
private:
    uint8_t fix_str[TC_LONG_SIZE];
public:
    Long_tc(){
        TC_string = fix_str;
        flags = 0;
    }

    ~Long_tc(){}
};

// TELEMETRY:
// MASKS
#define SHORT_LONG_TM_MASK 0x10
#define TMID_MASK 0x0F

//x should be 'fields' variable defined in the Base_tm
#define GETshort_or_long_tm(x) ((x & SHORT_LONG_TM_MASK) >> 4)
#define GETtmid(x) (x & TMID_MASK)

//x should be 'fields' variable defines in the Base_tm
//y should be an 8-bit number with relevent data at LSB
#define PUTshort_or_long_tm(x,y) x = (x & ~(SHORT_LONG_TM_MASK)) | ((y<<4) & SHORT_LONG_TM_MASK)
#define PUTtmid(x,y) x = (x & ~(TMID_MASK)) | (y & TMID_MASK)

// PARENT TELEMETRY CLASS
class Base_tm{
public:
    uint8_t fields;
    uint8_t *TM_string;
    Base_tm *next_TM;

    virtual ~Base_tm(){}
};

// DERIVED CLASS : Long tm [type 0]
// type 0
class Long_tm : public Base_tm{
private:
    uint8_t fix_str[TM_LONG_SIZE];
public:
    Long_tm(){
        this->TM_string = fix_str;
        // type 0
        fields = 0;
    }

    ~Long_tm(){}
};

// DERIVED CLASS : Short tm [type 1]
// type 1
class Short_tm : public Base_tm{
private:
    uint8_t fix_str[TM_SHORT_SIZE];
public:
    Short_tm(){
        this->TM_string = fix_str;
        // type 1
        fields = 0x10;
    }

    ~Short_tm(){}
};
