
// **************DEFINITIONS*********************
// COM_RX
    #define RX_TIMEOUT_LIMIT 1.0
    #define COM_RX_UART_TX PTE20
    #define COM_RX_UART_RX PTE21

// COMMON SPI
    #define SPI_MOSI PTE1
    #define SPI_MISO PTE3
    #define SPI_CLK PTE2
    #define SPI_CS_ADF PTA15
    #define SPI_CS_SDC PTE22
    #define SPI_CS_RTC PTE29

// ADF INTERRUPUT
    #define ADF_IRQ PTA14

// TC LIST
    #define TCL_STATE_INCOMPLETE 0x00
    #define TCL_STATE_EXECUTING 0x01
    #define TCL_STATE_COMPLETED 0x03
    #define TCL_STATE_ABORTED 0x02
    /*
    0: IDLE OR WAITING FOR TCL COMPLETION
    1: EXECUTING AFTER COMPLETION OF TCL
    2: COMPLETED EXECUTION OF TCL
    3: IDLE DUE TO ABORT ON NACK
    */

// LIST OF FLAGS
    #define UART_INT_FLAG 0x0001
    #define NEW_TC_RECEIVED 0x0002
    #define COM_SESSION_FLAG 0x0004
    #define COM_RX_FLAG 0x0008
    #define COM_MNG_TMTC_RUNNING_FLAG 0x0010
    #define COM_SESSION_VALIDITY 0x0020
    #define ALL_CRC_PASS_FLAG 0x0040
    #define COM_PA_HOT_FLAG 0x0080
    #define COM_TX_FLAG 0x0100

// COM_MNG_TMTC THREAD
    #define SESSION_TIME_LIMIT 1200
    #define COM_MNG_TMTC_SIGNAL_UART_INT 0x01
    #define COM_MNG_TMTC_SIGNAL_ADF_NSD 0x02
    #define COM_MNG_TMTC_SIGNAL_ADF_SD 0x03

// COM_MNG_TMTC
    #define COM_PA_COOLING_TIME_LIMIT 20

    // call sign
    #define PSC_CALLSIGN 0x00
    #define APID_CALLSIGN 0x00

    // max value of telecommands in a tcl
    #define TCL_OVERFLOW_CONSTANT 256

    // starting value of packet sequence count at each pass
    #define PSC_START_VALUE 1

    // APID list
    #define APID_BAE 1
    #define APID_CDMS 2
    #define APID_SPEED 3

    // HIGH PRIORITY TC - priority list
    // not correct values here
    #define HPTC1 5
    #define HPTC2 6
    // Add more entries above

    // SIZE of tc in bytes
    #define TC_SHORT_SIZE 11
    #define TC_LONG_SIZE 135

    // TMID list
    #define TMID_ACK_L1 0xA

// OBOSC SERVICE SUBTYPE
    #define OBOSC_SUB_DISABLE 0x01
    #define OBOSC_SUB_RETRY 0x05
    #define OBOSC_SUB_REP_TCL_D 0x06
    #define OBOSC_SUB_REP_TCL 0x08
    #define OBOSC_SUB_REP_LE 0x0F
    #define OBOSC_SUB_RESET 0x07

// PAYLOAD
    #define PAYLOAD_BUFFER_LENGTH 2190

// ****************GLOBAL VARIABLES******************
// DEBUG
//Serial gPC( USBTX, USBRX );
//DigitalOut gLEDR(LED_RED);
//DigitalOut gLEDG(LED_GREEN);

// COM_RX
//RawSerial RX1M( COM_RX_UART_TX, COM_RX_UART_RX );
COM_RX_DATA_NODE *gRX_HEAD_DATA_NODE = NULL;
COM_RX_DATA_NODE *gRX_CURRENT_DATA_NODE = NULL;
// uint8_t *gRX_CURRENT_PTR = NULL;
uint32_t gRX_COUNT = 0;
uint16_t gTOTAL_INCORRECT_SIZE_TC = 0x00;
uint16_t gTOTAL_CRC_FAIL_TC = 0x00;
uint16_t gTOTAL_REPEATED_TC = 0x00;

// COMMON SPI
//SPI spi( SPI_MOSI, SPI_MISO, SPI_CLK );
//DigitalOut gCS_ADF(SPI_CS_ADF);
//DigitalOut gCS_SDC(SPI_CS_SDC);
//DigitalOut gCS_RTC(SPI_CS_RTC);
//Mutex SPI_mutex;

// TC LIST
Base_tc* gHEAD_NODE_TCL = NULL;
Base_tc* gLAST_NODE_TCL = NULL;
uint8_t gMASTER_STATE = TCL_STATE_INCOMPLETE;
uint16_t gFLAGS = 0x0000;

// COM_MNG_TMTC THREAD
//Thread* gCOM_MNG_TMTC_THREAD = NULL;
//Timeout gRX_TIMEOUT;
//Timeout gSESSION_TIMEOUT;

// COM_MNG_TMTC

// PA cooling timeout
//Timeout gCOM_PA_COOLING_TIMER;

// GS code for verification
const uint8_t gGSCODE[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

uint8_t gTOTAL_VALID_TC = 0x00;
// USE LAST_L1_ACK FOR GENERATING REPORT
uint8_t gLAST_L1_ACK[TM_SHORT_SIZE];
uint8_t gLAST_L1_ACK_BUFFER[TM_SHORT_SIZE];
uint8_t gOBOSC_PSC = PSC_START_VALUE;
Base_tc* gOBOSC_HEAD = NULL;

// SCIENCE_THREAD
//Thread* gSCIENCE_THREAD = NULL;
uint8_t gPAYLOAD_BUFFER[PAYLOAD_BUFFER_LENGTH];
