#include "mbed.h"
#include "sMotor.h"
#include "ultrasonic.h"
 
float CAT_COOLDOWN = 4.0; // Number of seconds of inactivity before power saving mode
 
Serial pc(USBTX, USBRX);
Serial Blue(p28,p27);
sMotor motor(p9, p10, p11, p12); // creates new stepper motor: IN1, IN2, IN3, IN4
DigitalOut laser(p20); 
DigitalOut led2(LED2);
 
int step_speed = 1100; // set default motor speed
volatile int dir = 0; //0 is CW, 1 is CCW
 
volatile int C = 30; 
volatile int numstep; // defines basic turn distance -- 256 steps == 360 degrees
volatile bool stationary = 1; 
volatile bool isrand = 0; 
volatile bool manual = 0;
volatile bool power;
volatile bool powerSave; // If 1, the laser is turned off until detected motion
volatile int  bnum = 0;
volatile int  bhit;
volatile int catMoves = 0;
Ticker catTicker;
//state used to remember previous characters read in a button message
enum statetype {start = 0, got_exclm, got_S, got_B, got_num, got_hit};
statetype state = start;
// State used to keep track of cat activity
int c_inactive = 0; int c_some = 1; int c_uptime = 2; int c_active = 3;
volatile int catState = c_active;
//Interrupt routine to parse message with one new character per serial RX interrupt
void parse_message() {
    led2 = !led2;
    switch (state) {
        case start:
            if (Blue.getc()=='!') state = got_exclm;
            else state = start;
            break;
        case got_exclm:
            if (Blue.getc() == 'B') state = got_B;
            else state = start;
            break;
        case got_B:
            bnum = Blue.getc();
            state = got_num;
            break;
        case got_num:
            bhit = Blue.getc();
            state = got_hit;
            break;
        case got_hit:
            if (Blue.getc() == char(~('!' + 'B' + bnum + bhit))) {
                switch (bnum) {
                    case '1': //number button 1
                        isrand = 0;
                        manual = 0;
                        stationary = 1; 
                        break;
                    case '2': //number button 2
                        stationary = 0; 
                        manual = 0;
                        isrand = 0; 
                        numstep = C; 
                        break;
                    case '3': //number button 3
                        stationary = 0;
                        manual = 0;
                        isrand = 1;
                        break;
                    case '4': //number button 4
                        power = !power;
                        break;
                    case '5': //button 5 up arrow
                        powerSave = 1;
                        printf("powerSave mode is %d\r\n", powerSave);
                        break;
                    case '6': //button 6 down arrow
                        powerSave = 0;
                        printf("powerSave mode is %d\r\n", powerSave);
                        break;
                    case '7':
                        stationary = 0;
                        isrand = 0;
                        manual = 1; 
                        dir = 0;
                        numstep = 1;
                        break;
                    case '8':
                        stationary = 0; 
                        isrand = 0;
                        manual = 1; 
                        dir = 1;
                        numstep = 1;
                        break;
                }
            }
            state = start;
            break;
        default:
            Blue.getc();
            state = start;
    }
}

// Interrupt that takes effect when motion is detected
float feet = 0;
void mDetect(int distance)
{
    float oldFeet = feet;
    feet = distance / 305.0;
    if (abs(oldFeet - feet) >= .2) {    // The difference is greater than a margin of error
            if (catState < c_uptime) catState++;
            if (catState == c_active) catMoves++; // The initial motion sensed does not count
            printf("\tMotion detected at %.3f!\n\r", feet);
        }
}

/* Set the trigger pin to D8 and the echo pin to D9.
    Updates every .1 seconds, timeout after 1
    second, function when the distance changes */
ultrasonic mu(p6, p7, .1, 1, &mDetect);

void activityBeep() {
    if (catMoves < 2) {
        catState = c_inactive;
        printf("Cat is inactive.\n\r");
        } else printf("\t\tCat moved %d times since timer began.\n\r", catMoves);
    catMoves = 0;
}
 
int main() {
 
    //Credits
    printf("\nCat Tower - Test Program\r\n");
    printf("\n\r");
 
    // Screen Menu
    printf("Default Speed: %d\n\r",step_speed);
    printf("Use Adafruit Bluefruit buttons to select mode\n\r");
    
    // attach interrupt function for each new Bluetooth serial character
    Blue.attach(&parse_message,Serial::RxIrq);
    
    powerSave = 0;
 
    int temp1 = 0;
    int temp2 = 0;
    
    while (1) {
        mu.checkDistance();
        if (catState == c_uptime) {
                printf("Beginning inactivity timer\n\r");
                // Activate countdown on cat activity
                catTicker.attach(&activityBeep, CAT_COOLDOWN); // function and interval in seconds
                catState = c_active;
            }
        if (powerSave == 0 || catState == c_active) { // If it is not in power save mode or the cat is active
            laser = power;
            if (stationary != 1) {
                
                if (isrand == 1) {
                    temp2 = rand() % C+1;
                    numstep = temp2 - temp1;
                    if (numstep < 0) {
                        dir = 0;
                    } else if (numstep > 0) {
                        dir = 1;
                    }
                    temp1 = temp2;
                    numstep = abs(numstep);
                } 
                
                if (manual == 1) {
                    dir = dir;
                } else { 
                    dir =  1 - dir;
                }
                
                motor.step(numstep, dir, step_speed); // number of steps, direction, speed 
            }
        } else laser = 0;
    }
}