#ifndef MONITOR_H
#define MONITOR_H

#include "mbed.h"

//definitions
#define DEVS 2
#define DEBUG 1
#define SAMPLES 5

typedef struct _xbee{
    uint16_t id;
    float temp;
    float volt;
    float amps;
    float vibs;
    uint8_t eflag; //error flag
} xbee;

//globals
extern Serial pc;
extern Serial coordinator;

//functions
float get_temp(uint8_t MSB, uint8_t LSB);
float get_volt(uint8_t MSB, uint8_t LSB);
float get_amps(uint8_t MSB, uint8_t LSB);
float get_vibs(uint8_t MSB, uint8_t LSB);
#endif