#include "monitor.h"

float get_temp(uint8_t MSB, uint8_t LSB){
    float data =  MSB*256 + LSB;
    float temp = 100*data/1024;
    return temp;
}

float get_volt(uint8_t MSB, uint8_t LSB){
    float R1 = 30000.0; //onboard resistor 1 value
    float R2 = 7500.0; //onboard resistor 2 value
    float data =  MSB*256 + LSB;
    float volt = (3.3*data/1024)/(R2/(R1+R2)); 
    return volt;
}

float get_amps(uint8_t MSB, uint8_t LSB){
    float data =  MSB*256 + LSB;
    float amps = (3.3*data/1024 - 1.65)/0.066*10;
    return amps;
    //return 0;
}

float get_vibs(uint8_t MSB, uint8_t LSB){
    float data =  MSB*256 + LSB;
    float vibs = 100*data/1024;
    return vibs;
    //return 0;
}