#include "mbed.h"
#include "monitor.h"

Serial pc(USBTX, USBRX);
Serial coordinator(p9, p10);

xbee nodes[DEVS];
//globals
float data[DEVS][4][SAMPLES]; //array to hold all of the data for averaging
float avgs[DEVS][4];  //array to hold averages
uint16_t source; //source id of the node sending data 
//most and least significant bytes of data
uint8_t MSB;
uint8_t LSB;
int num_samples = 0;
//functions 
void check_nodes();
void average();
uint8_t error_check();

int main() 
{
    //loop instantiates and ids all of the nodes in the network
    for(int i=0; i<DEVS; i++)
        nodes[i].id = i+1;
    
    //loop continually checks for data from the nodes
    while(1) {
        check_nodes();
        if(num_samples==SAMPLES){
            average();
            if(error_check()){
                //do something
            }
            num_samples = 0;
            //wait(1);
        }
        num_samples++;          
    }
}

//retrieves a data packet and parses it, then calls the functions to calculate 
//the data
void check_nodes(){
    //check for the begining of the packet
    if(coordinator.readable() && coordinator.getc()==0x7E){
        //discard unecessary bytes from the packet
        coordinator.getc(); //payload length is 2 bytes
        coordinator.getc(); //this is always a constant so it is uneccesary
        coordinator.getc(); //packet type (packets are always data type)
        coordinator.getc();
        //find the source node (-1 to adjust for indexing as coordinator
        //is always node 0
        
        source = coordinator.getc() - 1;
        //pc.printf("%d\r\n", source);
        //discard more unecesary bytes
        for(int i=0; i<5; i++)
            coordinator.getc();
        
        //temperature
        MSB = coordinator.getc();
        LSB = coordinator.getc();
        nodes[source].temp = get_temp(MSB, LSB);
        data[source][0][num_samples] = nodes[source].temp;
        
        //voltage
        MSB = coordinator.getc();
        LSB = coordinator.getc();
        nodes[source].volt = get_volt(MSB, LSB);
        data[source][1][num_samples] = nodes[source].volt;
        
        //current
        MSB = coordinator.getc();
        LSB = coordinator.getc();
        nodes[source].amps = get_amps(MSB, LSB);
        data[source][2][num_samples] = nodes[source].amps;
        
        //vibrations
        MSB = coordinator.getc();
        LSB = coordinator.getc();
        nodes[source].vibs = get_vibs(MSB, LSB);
        data[source][3][num_samples] = nodes[source].vibs;
        
        if(DEBUG){
            //print statements
            pc.printf("TEMP %d: %0.1fC ", nodes[source].id, nodes[source].temp);
            pc.printf("VOLT %d: %0.1fV ", nodes[source].id, nodes[source].volt);
            pc.printf("AMPS %d: %0.1fmA ", nodes[source].id, nodes[source].amps);
            pc.printf("VIBS %d: %0.1fB\r\n", nodes[source].id, nodes[source].vibs);
        }
  
    } 
}

//calculates the averages of the data then sends them to the gui
void average(){
    for(int i=0; i<2; i++){
        float sum = 0;
        for(int j=0; j<SAMPLES; j++){
            sum = sum + data[source][i][j];
        }
        avgs[source][i] = sum;
    }
}

uint8_t error_check(){
    return 0;
}