#include "mbed.h"
#include "string.h"

Serial pc(SERIAL_TX, SERIAL_RX);
Serial sim808(D1,D0);
Timer  send_t;

#define buf_max 200
volatile int First_Int = 0;
volatile int Rcv_End = 0;
char sim_buf[buf_max];
const char *senddata="Bluetooth test\r\n";
char CtrlZ = 0x1A;

void CLR_Buf(void);
int Find(char *a);
void Wait_Connect(void);

void SIM808_IRQHandler(void)                    
{    
    sim_buf[First_Int++] = sim808.getc();
    if(sim_buf[First_Int] == 0X0A) 
    {
      Rcv_End = 1;
    } 
} 

int main()
{
    sim808.attach(&SIM808_IRQHandler);
    pc.printf("SIM808 BlueTooth Test!\r\n");
    pc.printf("Çë´ò¿ªÊÖ»úÀ¶ÑÀ´®¿ÚÖúÊÖ!\r\n");
    
    sim808.printf("AT+BTPOWER=1\r\n");//¿ªÆôÀ¶ÑÀµçÔ´
    wait(0.1);
    sim808.printf("AT+BTUNPAIR=0\r\n");//É¾³ýÅä¶ÔµÄÀ¶ÑÀÉèÖÃ
    pc.printf("SIM808Ä£¿é¿ªÊ¼ÊÕË÷À¶ÑÀÉè±¸,ÇëÈ·ÈÏÊÖ»úÀ¶ÑÀ´¦ÓÚ¿É±»·¢ÏÖ\r\n");
    
    CLR_Buf();
    Rcv_End = 0;
    
    do
    {
        pc.printf("ÊÕË÷Éè±¸ÖÐ............\r\n");
        sim808.printf("AT+BTSCAN=1,10\r\n");        //ÊÕË÷¸½½üµÄÀ¶ÑÀÉè±¸£¬ÊÕË÷Ê±¼ä10S
        wait(10);
    }while(Rcv_End == 1 && strstr((const char*)sim_buf,"+BTSCAN: 0")==NULL); //µÈ´ýÊÕË÷µ½Éè±¸²ÅÍË³ö
    
    CLR_Buf();
    Rcv_End = 0;
    
    do
    {
        pc.printf("Åä¶ÔÖÐ............\r\n");
        sim808.printf("AT+BTPAIR=0,1\r\n");
        wait(0.2); 
        sim808.printf("AT+BTPAIR=1,1\r\n");
        wait(0.1);
    }while(Rcv_End == 1 && strstr((const char*)sim_buf,"+BTPAIR: 1")==NULL);//Åä¶Ô³É¹¦
    
    CLR_Buf();
    Rcv_End = 0;
    
    pc.printf("SIM808Ä£¿éÀ¶ÑÀÅä¶Ô³É¹¦!\r\n");
    wait(1);
    pc.printf("Çë´ò¿ªÀ¶ÑÀÖúÊÖÁ¬½ÓSIM808!\r\n");
    wait(1);
    
    Wait_Connect();
    sim808.printf("AT+ACPT=1\r\n");
    wait(1);
    if(Find("OK")|Rcv_End == 1)
    {
        pc.printf("Éè±¸Á¬½Ó³É¹¦!\r\n");
        
        CLR_Buf();
      Rcv_End = 0;
        
        send_t.start();
        while(1);
        {
            if(send_t.read()>5)
            {
                sim808.printf("AT+BTSPPSEND\r\n");
                wait(0.1);
                sim808.printf((char *)senddata);
                sim808.printf("%c",CtrlZ);
                send_t.start();
                CLR_Buf();
            }
        }
  }
    else
    {
        pc.printf("Éè±¸Á¬½ÓÊ§°Ü!\r\n");
    }
}




void CLR_Buf(void)
{
    uint16_t k;
    for(k=0;k<buf_max;k++)      //½«»º´æÄÚÈÝÇåÁã
    {
        sim_buf[k] = 0x00;
    }
    First_Int = 0;              //½ÓÊÕ×Ö·û´®µÄÆðÊ¼´æ´¢Î»ÖÃ
}

int Find(char *a)
{ 
  if(strstr(sim_buf,a)!=NULL)
        return 1;
    else
            return 0;
}

void Wait_Connect(void)
{
    int i;
    i = 0;
    CLR_Buf();
  while(i == 0)                 
    {
        CLR_Buf();        
        wait(1);        
        if(Find("+BTCONNECTING:"))
        {
            i = 1;
            break;
        }
        
        pc.printf("ÇëÔÚÀ¶ÑÀÖúÊÖÖÐÁ¬½ÓÉè±¸!\r\n");
    }
}