#include "mbed.h"
#include "string.h"

Serial pc(SERIAL_TX, SERIAL_RX);
Serial sim808(D1,D0);
Timer  send_t;

#define buf_max 200
volatile int First_Int = 0;
volatile int Rcv_End = 0;
char sim_buf[buf_max];
char *p1,*p2;
const char *senddata="Bluetooth test\r\n";

void CLR_Buf(void);
int Find(char *a);
//void Wait_CREG(void);

void SIM808_IRQHandler(void)                    
{    
    sim_buf[First_Int++] = sim808.getc();
    if(sim_buf[First_Int] == 0X0A) 
    {
      Rcv_End = 1;
    } 
} 

int main()
{
    sim808.attach(&SIM808_IRQHandler);
    pc.printf("SIM808 BlueTooth Test!\r\n");
    pc.printf("Çë´ò¿ªÊÖ»úÀ¶ÑÀ´®¿ÚÖúÊÖ!\r\n");
    pc.printf("SIM808Ä£¿éÁ¬½ÓÖÐ...\r\n");
    
    sim808.printf("AT+BTPOWER=1\r\n");//¿ªÆôÀ¶ÑÀµçÔ´
    wait(0.1);
    sim808.printf("AT+BTUNPAIR=0\r\n");//É¾³ýÅä¶ÔµÄÀ¶ÑÀÉèÖÃ
    pc.printf("SIM808Ä£¿é¿ªÊ¼ÊÕË÷À¶ÑÀÉè±¸,ÇëÈ·ÈÏÊÖ»úÀ¶ÑÀ´¦ÓÚ¿É±»·¢ÏÖ\r\n");
    
    CLR_Buf();
    Rcv_End = 0;
    
    do
    {
        pc.printf("ÊÕË÷Éè±¸ÖÐ............\r\n");
        sim808.printf("AT+BTSCAN=1,10\r\n");   //ÊÕË÷¸½½üµÄÀ¶ÑÀÉè±¸£¬ÊÕË÷Ê±¼ä10S
    }while(Rcv_End == 1 && strstr((const char*)sim_buf,"+BTSCAN: 0")==NULL);   //µÈ´ýÊÕË÷µ½Éè±¸²ÅÍË³ö
    
    CLR_Buf();
    Rcv_End = 0;
    
    do
    {
        pc.printf("Á¬½ÓÉè±¸ÖÐ............\r\n");
        sim808.printf("AT+BTPAIR=0,1\r\n");//Á¬½ÓµÚÒ»¸öÊÕË÷µ½µÄÉè±¸ 
        wait(0.2); 
        sim808.printf("AT+BTPAIR=1,1\r\n");//ÏìÓ¦Á¬½Ó
        wait(0.1);//µÈ´ý½ÓÊÕÊý¾ÝÍê³É
    }while(Rcv_End == 1 && strstr((const char*)sim_buf,"+BTPAIR: 1")==NULL);//Æ¥Åä³É¹¦
    
    CLR_Buf();
    Rcv_End = 0;
    
    pc.printf("SIM808Ä£¿éÀ¶ÑÀÆ¥Åä³É¹¦\r\n");
    pc.printf("Çë´ò¿ªÊÖ»úÀ¶ÑÀ´®¿ÚÖúÊÖ\r\n");
    
    sim808.printf("AT+BTGETPROF=1\r\n");//»ñÈ¡À¶ÑÀ·þÎñÁÐ±í
    sim808.printf("AT+BTCONNECT=1,4\r\n");//»ñÈ¡À¶ÑÀ·þÎñÁÐ±í
    pc.printf("SIM808Ä£¿éÀ¶ÑÀ½¨Á¢SPP·þÎñ³É¹¦\r\n");
    
    CLR_Buf();
    Rcv_End = 0;
    
    send_t.start();
    while(1);
    {
        if(send_t.read()>5)
        {
            sim808.printf("AT+BTSPPSEND\r\n");
            sim808.printf((char *)senddata);
            send_t.start();
            CLR_Buf();
        }
    }
}




void CLR_Buf(void)
{
    uint16_t k;
    for(k=0;k<buf_max;k++)      //½«»º´æÄÚÈÝÇåÁã
    {
        sim_buf[k] = 0x00;
    }
    First_Int = 0;              //½ÓÊÕ×Ö·û´®µÄÆðÊ¼´æ´¢Î»ÖÃ
}

int Find(char *a)
{ 
  if(strstr(sim_buf,a)!=NULL)
        return 1;
    else
            return 0;
}

//void Wait_CREG(void)
//{
//  int i;
//  int k;
//  i = 0;
//  CLR_Buf();
//  while(i == 0)                   
//  {
//      CLR_Buf();        
//      sim808.printf("AT+CREG?");
//      sim808.printf("\r\n");
//      wait(1);        
//      for(k=0;k<buf_max;k++)                  
//      {
//          if(sim_buf[k] == ':')
//          {
//              if((sim_buf[k+4] == '1')||(sim_buf[k+4] == '5'))
//              {
//                  i = 1;
//                break;
//              }
//          }
//      }
//      pc.printf("×¢²áÖÐ.....\r\n");
//  }
//}

//void Second_AT_Command(char *b,char *a,u8 wait_time)         
//{
//  uint8_t i;
//  char *c;
//  c = b;                                      //±£´æ×Ö·û´®µØÖ·µ½c
//  CLR_Buf2(); 
//  i = 0;
//  while(i == 0)                    
//  {
//      if(!Find(a)) 
//      {
//          if(Timer0_start == 0)
//          {
//              b = c;                          //½«×Ö·û´®µØÖ·¸øb
//              for (; *b!='\0';b++)
//              {
//                  while(USART_GetFlagStatus(USART2, USART_FLAG_TC)==RESET);
//                  USART_SendData(USART2,*b);//UART2_SendData(*b);
//              }
//              UART2_SendLR(); 
//              Times = 0;
//              shijian = wait_time;
//              Timer0_start = 1;
//         }
//    }
//    else
//      {
//          i = 1;
//          Timer0_start = 0;
//      }
//  }
//  CLR_Buf2(); 
//}