#ifndef MLX90614_H
#define MLX90614_H
#include "mbed.h"


class MLX90614 {

public:
    MLX90614(I2C *i2c);
   ~MLX90614();

    float ambientTemp();
    float objectTemp();

protected:

    float readTemp(uint8_t reg);

private:

    I2C *i2c_;
    static const int default_addr = 0x00;
    static const int T_ambient = 0x06;
    static const int T_obj1 = 0x07;
    static const int ram_access = 0x00;

};
#endif