#include "MLX90614.h"

MLX90614::MLX90614(I2C *i2c) : i2c_(i2c) {
}

float MLX90614::readTemp(uint8_t reg) {
    char cmd[3] = { 0 };
    cmd[0] = ram_access | reg;
    i2c_->write(default_addr, cmd, 1, true); 
    i2c_->read(default_addr, cmd, 3);
    return 0.02f * static_cast<float>(((cmd[1] & 0x7F) << 8) | cmd[0]) - 273.15f;
}


float MLX90614::ambientTemp(){
    return readTemp(T_ambient);
}

float MLX90614::objectTemp(){
    return readTemp(T_obj1);
}