#ifndef _FILES_H_
#define _FILES_H_

#include "mbed.h"
#include "d7a.h"

enum {
    // Alarm
    ALARM_FILE_ID       = 224,
    SIMUL_FILE_ID,
    
    // RFU
    RFU_FILE_ID_226, 
    RFU_FILE_ID_227, 
    RFU_FILE_ID_228, 
    RFU_FILE_ID_229, 

    // New cfg
    LIGHT_CFG_FILE_ID   = 230,
    VOLT_CFG_FILE_ID,
    RFU_CFG_FILE_ID_232, 
    RFU_CFG_FILE_ID_233, 
    RFU_CFG_FILE_ID_234, 

    // New value
    LIGHT_VALUE_FILE_ID = 235,
    VOLT_VALUE_FILE_ID, 
    RFU_VALUE_FILE_ID_237, 
    RFU_VALUE_FILE_ID_238, 
    RFU_VALUE_FILE_ID_239, 

    // Nucleo-64 default list
    MAG_CFG_FILE_ID     = 240,
    ACC_CFG_FILE_ID,
    GYR_CFG_FILE_ID,
    PRE_CFG_FILE_ID,   // 243
    HUM_CFG_FILE_ID,
    TEM1_CFG_FILE_ID,
    TEM2_CFG_FILE_ID,
    MAG_VALUE_FILE_ID, // 247
    ACC_VALUE_FILE_ID,
    GYR_VALUE_FILE_ID,
    PRE_VALUE_FILE_ID, // 250
    HUM_VALUE_FILE_ID,
    TEM1_VALUE_FILE_ID,
    TEM2_VALUE_FILE_ID,// 253
};

#define GENERIC_FILE(name,data)         TYPEDEF_STRUCT_PACKED{\
                                            data\
                                        } name##_t;\
                                        extern name##_t f_##name;
                                    
#define GENERIC_FILE_INIT(name,...)     name##_t f_##name = {\
                                            __VA_ARGS__\
                                        }
                                        
#define GENERIC_FILE_MAP(fid,name)      { (void*)fid, (void*)&f_##name }

// Types of reporting
typedef enum 
{
    REPORT_ALWAYS,
    REPORT_ON_DIFFERENCE,
    REPORT_ON_THRESHOLD,
    
} report_type_t;

// Sensor reporting configuration
TYPEDEF_STRUCT_PACKED 
{
    uint8_t  report_type;       // Type of report asked
    uint32_t period;            // Measure period (ms)
    uint32_t max_period;        // Maximum time between reports (s)
    uint32_t max_diff;          // Maximum difference allowed between two reported values
    int32_t  threshold_high;    // High threshold value triggering a report
    int32_t  threshold_low;     // Low threshold value triggering a report
    
} sensor_config_t;

// Firmware revision for the Dash7board
GENERIC_FILE(dev_rev, d7a_revision_t rev;);
GENERIC_FILE(simul, uint32_t divider;);
GENERIC_FILE(tem1_cfg, sensor_config_t cfg;);
GENERIC_FILE(volt_cfg, sensor_config_t cfg;);

uint32_t fs_write_file(const uint8_t file_id,
                        const uint16_t offset,
                        const uint16_t size,
                        const uint8_t* const content);
                        
uint32_t fs_read_file( const uint8_t file_id,
                        const uint16_t offset,
                        const uint16_t size,
                        uint8_t* buf);

#endif // _FILE_SYS_H_
