#include "files.h"
#include "dbg.h"
#include "sensors.h"

GENERIC_FILE_INIT(dev_rev,
    .rev.manufacturer_id     = 0x01BC50C7,
    /// Device ID: Arbitrary number, at user/customer choice
    .rev.device_id           = 0x00000010,
    /// Hardware Board ID:
    .rev.hw_version          = 0x00000152,
    /// Firmware Version: made of
    ///  - major,minor and patch indexes
    ///  - fw_id : "build-flavour"
    ///  FW_ID | MAJOR | MINOR | PATCH | HASH |
    //     1B  |  1B   |  1B   |   2B  |  4B  |
#if defined(TARGET_STM32L152RE)
    #ifdef TARGET_HAS_IKS01A1    
    .rev.fw_version.id       = 0,
    #else // simulated sensors
    .rev.fw_version.id       = 1,
    #endif // TARGET_HAS_IKS01A1
#elif defined(TARGET_STM32L432KC)
    .rev.fw_version.id       = 2,
#else
    #error "Please choose or add the right platform."
#endif
    .rev.fw_version.major    = 1,
    .rev.fw_version.minor    = 0,
    .rev.fw_version.patch    = 0,
    .rev.fw_version.hash     = 0x00000000,
    /// "file-system" signature
    .rev.fs_crc              = 0x00000000,
);

GENERIC_FILE_INIT(simul,
    .divider = 500, // Boot value
);



GENERIC_FILE_INIT(tem1_cfg,
    .cfg.report_type = REPORT_ALWAYS,
    .cfg.period = 5000,
    .cfg.max_period = 5,
    .cfg.max_diff = 100,
    .cfg.threshold_high = 3500,
    .cfg.threshold_low = 2000,
);

GENERIC_FILE_INIT(volt_cfg,
    .cfg.report_type = REPORT_ALWAYS,
    .cfg.period = 20000, // ms
    .cfg.max_period = 60, // sec
    .cfg.max_diff = 10, // percent
    .cfg.threshold_high = 0, // disabled
    .cfg.threshold_low = 100, // disabled
);

#define FILE_QTY    3

static const void* file_map[FILE_QTY][2] = {
    GENERIC_FILE_MAP(TEM1_CFG_FILE_ID, tem1_cfg),
    GENERIC_FILE_MAP(SIMUL_FILE_ID, simul),
    GENERIC_FILE_MAP(VOLT_CFG_FILE_ID, volt_cfg),
};

void* file_get( uint8_t file_id )
{    
    for (uint8_t i=0 ; i<FILE_QTY ; i++)
    {
        if ((uint8_t)file_map[i][0] == file_id)
        {
            return (void*)file_map[i][1];
        }
    }
    
    ASSERT(false, "File %d does not exist\r\n");
    
    return NULL;
}

uint32_t fs_write_file(const uint8_t file_id,
                        const uint16_t offset,
                        const uint16_t size,
                        const uint8_t* const content)
{
    uint32_t file = 0;
    
    DPRINT("WF %d\r\n", file_id);
        
    // Retrieve pointer to file
    file = (uint32_t)file_get(file_id);
        
    if (!file)
    {
        return 0;
    }
    
    // Write the new data
    memcpy((void*)(file+offset), (void*)content, size);
  
    return size;
}

uint32_t fs_read_file( const uint8_t file_id,
                        const uint16_t offset,
                        const uint16_t size,
                        uint8_t* buf)
{
    uint32_t file = 0;
    
    DPRINT("RF %d\r\n", file_id);
    
    // Retrieve pointer to file
    file = (uint32_t)file_get(file_id);
    
    if (!file)
    {
        return 0;
    }
    
    // Read data
    memcpy((void*)buf, (void*)(file+offset), size);
    
    return size;
}
