#include "mbed.h"
#include "simul.h"
#include "dbg.h"


unsigned int m_z=12434,m_w=33254;
 
unsigned int rnd() {
    m_z = 36969 * (m_z & 65535) + (m_z >>16);
    m_w = 18000 * (m_w & 65535) + (m_w >>16);
    return ((m_z <<16) + m_w);
}

uint32_t g_simul_divider = 500;

void simul_update_param(uint32_t value)
{
    g_simul_divider = value;
}

bool simul_sensor_value(int32_t* buf, uint32_t nb_values, int32_t min, int32_t max)
{
    for (uint8_t i = 0; i < nb_values; i++)
    {
        int32_t new_value;
        
        uint32_t r = rnd()%g_simul_divider;
        
        if (r)
        {
            if (r%2)
            {
                new_value = buf[i] + 1;
            }
            else
            {
                new_value = buf[i] - 1;
            }
            
            if (new_value > max)
            {
                new_value = max;
            }
            
            if (new_value < min)
            {
                new_value = min;
            }
        }
        else
        {
            new_value = (rnd()%(max - min)) + min;
        }
        
        buf[i] = new_value;
    }
    
    return false;
}

