![]()
# Initially based on the Blinky Mbed OS example

This project is one example of the CITY1082 assignment one: Environmental Control System

Tested with Mbed online compiler and mbed Studio untested with cli but should be fine.

## Application functionality

The `main()` function is one of two threads in the application. 
After reset and initialisation it toggles the state of a digital output connected 
to an LED on the board periodically, reads the temperature and light level sensors,
sets or activates any heating and lighting controls connected to the microcontroller,
updates the display data using a vt100 terminal emulator console, then repeats the
loop.
A second thread `consoleThread()` accepts keyboard input from the terminal emulator
and processes any characters received:
  '<sp>'  Set max and minimum threshold values for heating temperature and
          light levels.
  '<tab>' Shift focus between thresholds to adjust them individually.
  'MH'    Toggle Auto/Manual for heating
      'H' when in manual mode toggle heating on or off
  'ML'    Toggle Auto/Manual for lighting
      'L' when in manual mode toggle lighting on or off
  'T'     Set the current Time and Date (DD/MM/YYYY HH:MM:SS)
 
  simple line editor to accept numeric values typed on keyboard (needs some 
  error checking of input values to avoid mistypes causing mbed to crash).
 

## Building and running

1. Connect a USB cable between the USB port on the board and the host computer.
2. Online compiler - click compile and save to board
   mbed Studio - click build and run terminal emulator is built in (115200 baud).

## Expected output
The LED on your target turns on and off every 500 milliseconds. VT100 terminal
emulator display shows current settings and readng from sensors.


## Troubleshooting
If you have problems, you can review the [documentation](https://os.mbed.com/docs/latest/tutorials/debugging.html) for suggestions on what could be wrong and how to fix it.

## Related Links

* [Mbed OS Stats API](https://os.mbed.com/docs/latest/apis/mbed-statistics.html).
* [Mbed OS Configuration](https://os.mbed.com/docs/latest/reference/configuration.html).
* [Mbed OS Serial Communication](https://os.mbed.com/docs/latest/tutorials/serial-communication.html).
* [Mbed OS bare metal](https://os.mbed.com/docs/mbed-os/latest/reference/mbed-os-bare-metal.html).
* [Mbed boards](https://os.mbed.com/platforms/).

### License and contributions

The software is provided under Apache-2.0 license. Contributions to this project are accepted under the same license. Please see contributing.md for more info.

This project contains code from other projects. The original license text is included in those source files. They must comply with our license guide.
