#include "mbed.h"
#include <cmsis_os.h>

void buzzThrd(void const *args);
void getIpThrd(void const *args);

osThreadDef(getIpThrd, osPriorityNormal, DEFAULT_STACK_SIZE);
osThreadDef(buzzThrd, osPriorityRealtime, DEFAULT_STACK_SIZE);

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
DigitalIn vibrate(p5);

osThreadId getIpThrdId, buzzThrdId;

void getIpThrd(void const *args)
{
  //  int count = 0;
    while(1) 
    {   
        myled1 = 1;
        myled4 = vibrate;
        if (vibrate == 1)
        {
            myled4 = vibrate;
            buzzThrdId = osThreadCreate(osThread(buzzThrd), NULL);
            myled3 = 0;
        }
        /*
        if(vibrate == 1) count++;
        if(count!=0)
        {
            buzzThrdId = osThreadCreate(osThread(buzzThrd), NULL);
            count = 0;
        }
        */
    }
}

void buzzThrd(void const *args)
{
    myled3 = 1;
    myled1 = 0;
    myled2 = 1;
    osDelay(5000);
    myled2 = 0;
   // myled4 = vibrate;
    osThreadTerminate(buzzThrdId);
}

int main() 
{
    osKernelInitialize (); 
    getIpThrdId = osThreadCreate(osThread(getIpThrd), NULL);
    //osThreadCreate(osThread(buzzThrd), NULL);  
   
    while(1)
    {
        osThreadYield();
    } 
    
}
