/* Freescale Semiconductor Inc.
 * (c) Copyright 2004-2005 Freescale Semiconductor, Inc.
 * (c) Copyright 2001-2004 Motorola, Inc. 
 *
 * mbed Microcontroller Library
 * (c) Copyright 2009-2012 ARM Limited.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef TSISENSOR_H
#define TSISENSOR_H

#define SLIDER_LENGTH           40 //LENGTH in mm
#define ELECTRODE_NUM           2

/*Chose the correct TSI channel for the electrode number*/
#define ELECTRODE0   TSI_CH9
#define ELECTRODE1   TSI_CH10
#define ELECTRODE2   TSI_CH13
#define ELECTRODE3   TSI_CH1
#define ELECTRODE4   TSI_CH2
#define ELECTRODE5   TSI_CH3
#define ELECTRODE6   TSI_CH4
#define ELECTRODE7   TSI_CH5
#define ELECTRODE8   TSI_CH6
#define ELECTRODE9   TSI_CH7
#define ELECTRODE10  TSI_CH8
#define ELECTRODE11  TSI_CH11
#define ELECTRODE12  TSI_CH12
#define ELECTRODE13  TSI_CH0
#define ELECTRODE14  TSI_CH14
#define ELECTRODE15  TSI_CH15

// TSI Channel THRESHOLD
#define THRESHOLD0   100
#define THRESHOLD1   100
#define THRESHOLD2   100
#define THRESHOLD3   100
#define THRESHOLD4   100
#define THRESHOLD5   100
#define THRESHOLD6   100
#define THRESHOLD7   100
#define THRESHOLD8   100
#define THRESHOLD9   100
#define THRESHOLD10  100
#define THRESHOLD11  100
#define THRESHOLD12  100
#define THRESHOLD13  100
#define THRESHOLD14  100
#define THRESHOLD15  100


/**
* TSISensor example
*
* @code
* #include "mbed.h"
* #include "TSISensor.h"
* 
* int main(void) {
*     PwmOut led(LED_GREEN);
*     TSISensor tsi;
*     
*     while (true) {
*         led = 1.0 - tsi.readPercentage();
*         wait(0.1);
*     }
* }
* @endcode
*/
class TSISensor {
public:
    /**
     *   Initialize the TSI Touch Sensor
     */
    TSISensor();

    /**
     * Read Touch Sensor percentage value
     *
     * @returns percentage value between [0 ... 1]
     */
    float readPercentage();

    /**
     * Read Touch Sensor distance
     *
     * @returns distance in mm. The value is between [0 ... 40]
     */
    uint8_t readDistance();

    uint8_t Pressed(uint8_t ch);
    float readTSI(uint8_t ch);
    uint16_t readTSI_u16(uint8_t ch);

private:
    void sliderRead(void);
    void selfCalibration(void);
};

#endif
