#include "mbed.h"
#include "TSISensor.h"

int main(void) {
    PwmOut led1(LED_BLUE);
    PwmOut led2(LED_GREEN);

    TSISensor tsi;

    led1.period_ms(1);
    led2.period_ms(1);

    while (true) {
        printf("\r\n");
        for(uint8_t i = 0; i < ELECTRODE_NUM; i++)
            printf("%d:%d-%f ", tsi.Pressed(i), tsi.readTSI_u16(i),tsi.readTSI(i));

        led1 = 1-tsi.readTSI(0);
        led2 = 1-tsi.readTSI(1);

        wait(0.1);
    }
}
