/*****************************************************************************

 referenceTraj.c

 created: 00/11/21  by  Preparing SnIFF
Liu Hong

 $Revision: 1.2 $  $Author: liu $    $Date: 2001/03/15 12:44:12 $   

 (C) by Institute of Robotics and Mechatronics, DLR

 Description:

   Please place your comment here !!!
        
 Contains:         
 
 Dependencies:     

 Target platforms: unspecified

 *****************************************************************************/


//#include <stdio.h>            /* Changed by mhjin. */
#include  "math.h"             /* Changed by mhjin. */
//#include "FingCtrlFrame.h"    /* Changed by mhjin. */
//#include "ctrlCommon.h"
#include "referenceTraj.h"
//#include "matrix.h"           /* Changed by mhjin. */
//#include "dingyi.h"           /* Changed by mhjin. */

void reference_trajectory(int INIT,                  /* init start */
                          double TS,                  /* sampling time */
                          double SP,                  /* interval  */
                          double *Tacc,               /* acceleration time */
                          PREF ref,                  /* static variable */
                          float *MAX_STEP,           /* max step limitation */
                          float *posRe,              /* real position */
                          float *posFl,              /* desire position */
                          float *trajRef )           /* ref. Traj. 0..2 -> q_d, 3..5-> v_d, 6..8->a_d */
{
   /* desire trajectory definition      */
   int i;
   float  h[3], md_para[3], N[3], N1[3], K[3];
   //   float det_M[3], det_L[3]; 
   float det_N[3];
   /*   float MAX_STEP[3];*/
   /*    float t[3]={0,0,0}; */
   /*    static int init_counter=0; */
   /*static float L[3]={0,0,0}, M[3]={0,0,0}; */
   //   float T1[3], t1[3]; 
   
    /*
     init_counter += 1;
     if( init_counter <= 1){
          for(i=0; i<=2; i++){
                t[i] = SP - (*(Tacc+i));
                M[i] = (*(posRe + i));
            L[i] = M[i];
            det_M[i] = 0.0;
          }
     }else{
          init_counter = 1;
     }
    */
   //    for(i=0; i<=2; i++){
       //       det_L[i] = ref->det_L[i];   /* reading para */
       //       det_M[i] = ref->det_M[i];   /* reading para */
       //       t1[i] =    ref->t1[i];          /* reading para */
       //       T1[i] =    ref->T1[i];          /* reading para */
   //    }
    /* following is for trajectory test */
    if(INIT == TRUE){
       for(i=0; i<=2; i++){
          ref->t[i] = SP - (*(Tacc+i));
          ref->M[i] = (*(posRe + i));
          ref->N[i] = (*(posRe + i)); /* final position */
          ref->L[i] = ref->M[i];
          ref->det_M[i] = 0.0;
    //      ref->det_L[i] = 0.0;            // Add by mhjin
          *(trajRef + i) = posRe[i];
          *(trajRef + 3 + i) = 0.0; 
          *(trajRef + 6 + i) = 0.0;
    //      ref->T1[i]=1.0/SP;          // Add by mhjin
    //      ref->t[i]= -(*(Tacc+i)) - TS;   // Add by mhjin
    //      ref->t1[i] = 1/(*(Tacc+i)); // Add by mhjin
       }
    }else{
       for(i=0; i<=2; i++){ 
          ref->t[i] += TS;
          if(ref->t[i] < (*(Tacc+i)/*- 0.0001*/)){
             h[i]=0.5*(1.0+ref->t[i]*ref->t1[i]);
             md_para[i]=ref->det_M[i]*(*(Tacc+i))*ref->T1[i]+ref->det_L[i];
             *(trajRef + i) = ((md_para[i])*(2.0-h[i])*h[i]*h[i]-2.0*ref->det_L[i])*h[i]+ref->L[i]+ref->det_L[i];
             *(trajRef + 3 + i) = ((md_para[i])*(1.5-h[i])*2.0*h[i]*h[i]-ref->det_L[i])*ref->t1[i];
             *(trajRef + 6 + i) = (md_para[i])*(1.0-h[i])*3.0*h[i]*ref->t1[i]*ref->t1[i];
          }else if(ref->t[i] < (SP - *(Tacc+i) - TS/* + 0.0001*/)){     //  Bug in here. 0.1ms
             h[i]=ref->t[i]*ref->T1[i];
             *(trajRef + i) = (ref->det_M[i]*h[i]+ref->L[i]);
             *(trajRef + 3 + i) = ref->det_M[i]*ref->T1[i];
             *(trajRef + 6 + i) = 0.0;
          }else{
             /*             MAX_STEP[i] = fg->glb->c1.mxm.MaxStep[i];*/
             h[i]=ref->t[i]*ref->T1[i];
             *(trajRef + i) = (ref->det_M[i]*h[i]+ref->L[i]);
             *(trajRef + 3 + i) = ref->det_M[i]*ref->T1[i];
             *(trajRef + 6 + i) = 0.0;
             N1[i] = ref->N[i] ; /* last time final position  */
             N[i] = *(posFl + i);
             det_N[i] = N[i] - N1[i]; /*  absolute max speed */
             if(det_N[i] >= MAX_STEP[i]){
                N[i] = N1[i] + MAX_STEP[i];
             }else if (det_N[i] <= -MAX_STEP[i]){
                N[i] = N1[i] - MAX_STEP[i];
             }
             ref->N[i] = N[i]; /* old final position */
             
             K[i] = *(trajRef + i);
             ref->L[i] = ref->M[i]; 
             ref->M[i] = N[i];   
             ref->det_L[i] = K[i] - ref->L[i]; 
             ref->det_M[i] = ref->M[i] - ref->L[i]; 
             if(SP <= 2.0*(*(Tacc+i))) SP = 2.0*(*(Tacc+i)); 
             ref->T1[i]=1.0/SP;
             ref->t[i]= -(*(Tacc+i)) - TS;
             ref->t1[i] = 1/(*(Tacc+i));
          }
       }
    }
}


void arm_reference_trajectory(int INIT,                  /* init start */
                          double TS,                  /* sampling time */
                          double SP,                  /* interval  */
                          double *Tacc,               /* acceleration time */
                          PARMREF ref,                  /* static variable */
                          float *MAX_STEP,           /* max step limitation */
                          float *posRe,              /* real position */
                          float *posFl,              /* desire position */
                          float *trajRef )           /* ref. Traj. 0..2 -> q_d, 3..5-> v_d, 6..8->a_d */
{
   /* desire trajectory definition      */
   int i;
   float  h[5], md_para[5], N[5], N1[5], K[5];
   float det_N[5];
   
    /* following is for trajectory test */
    if(INIT == TRUE){
       for(i=0; i<5; i++){
          ref->t[i] = SP - (*(Tacc+i));
          ref->M[i] = (*(posRe + i));
          ref->N[i] = (*(posRe + i)); /* final position */
          ref->L[i] = ref->M[i];
          ref->det_M[i] = 0.0;
    //      ref->det_L[i] = 0.0;            // Add by mhjin
          *(trajRef + i) = posRe[i];
          *(trajRef + 5 + i) = 0.0; 
          *(trajRef + 10 + i) = 0.0;
    //      ref->T1[i]=1.0/SP;          // Add by mhjin
    //      ref->t[i]= -(*(Tacc+i)) - TS;   // Add by mhjin
    //      ref->t1[i] = 1/(*(Tacc+i)); // Add by mhjin
       }
    }else{
       for(i=0; i<5; i++){ 
          ref->t[i] += TS;
          if(ref->t[i] < (*(Tacc+i)/*- 0.0001*/)){
             h[i]=0.5*(1.0+ref->t[i]*ref->t1[i]);
             md_para[i]=ref->det_M[i]*(*(Tacc+i))*ref->T1[i]+ref->det_L[i];
             *(trajRef + i) = ((md_para[i])*(2.0-h[i])*h[i]*h[i]-2.0*ref->det_L[i])*h[i]+ref->L[i]+ref->det_L[i];
             *(trajRef + 5 + i) = ((md_para[i])*(1.5-h[i])*2.0*h[i]*h[i]-ref->det_L[i])*ref->t1[i];
             *(trajRef + 10 + i) = (md_para[i])*(1.0-h[i])*3.0*h[i]*ref->t1[i]*ref->t1[i];
          }else if(ref->t[i] < (SP - *(Tacc+i) - TS/* + 0.0001*/)){     //  Bug in here. 0.1ms
             h[i]=ref->t[i]*ref->T1[i];
             *(trajRef + i) = (ref->det_M[i]*h[i]+ref->L[i]);
             *(trajRef + 5 + i) = ref->det_M[i]*ref->T1[i];
             *(trajRef + 10 + i) = 0.0;
          }else{
             /*             MAX_STEP[i] = fg->glb->c1.mxm.MaxStep[i];*/
             h[i]=ref->t[i]*ref->T1[i];
             *(trajRef + i) = (ref->det_M[i]*h[i]+ref->L[i]);
             *(trajRef + 5 + i) = ref->det_M[i]*ref->T1[i];
             *(trajRef + 10 + i) = 0.0;
             N1[i] = ref->N[i] ; /* last time final position  */
             N[i] = *(posFl + i);
             det_N[i] = N[i] - N1[i]; /*  absolute max speed */
             if(det_N[i] >= MAX_STEP[i]){
                N[i] = N1[i] + MAX_STEP[i];
             }else if (det_N[i] <= -MAX_STEP[i]){
                N[i] = N1[i] - MAX_STEP[i];
             }
             ref->N[i] = N[i]; /* old final position */
             
             K[i] = *(trajRef + i);
             ref->L[i] = ref->M[i]; 
             ref->M[i] = N[i];   
             ref->det_L[i] = K[i] - ref->L[i]; 
             ref->det_M[i] = ref->M[i] - ref->L[i]; 
             if(SP <= 2.0*(*(Tacc+i))) SP = 2.0*(*(Tacc+i)); 
             ref->T1[i]=1.0/SP;
             ref->t[i]= -(*(Tacc+i)) - TS;
             ref->t1[i] = 1/(*(Tacc+i));
          }
       }
    }
}

