#ifndef REFERENCETRAJ_H
#define REFERENCETRAG_H

#define TRUE    1
#define FALSE   0

typedef struct _REF {
    double T1[3];   /* ?????????? time  t */
    double t1[3];   /* ?????????? time  t */
    double t[3];        /* current time     t */
    float M[3];     /* Desire Position  C */
    float N[3];     /* Desire Position  C */
    float L[3];     /* Last Position    B */
    float det_M[3]; /*              C - B */
    float det_L[3]; /*              A - B */
} REF, *PREF;


//********** arm
typedef struct _ARMREF {
    double T1[5];   /* ?????????? time  t */
    double t1[5];   /* ?????????? time  t */
    double t[5];        /* current time     t */
    float M[5];     /* Desire Position  C */
    float N[5];     /* Desire Position  C */
    float L[5];     /* Last Position    B */
    float det_M[5]; /*              C - B */
    float det_L[5]; /*              A - B */
} ARMREF, *PARMREF;
//********** arm


void reference_trajectory(int INIT,                  /* init start */
                          double TS,                  /* sampling time */
                          double SP,                  /* interval  */
                          double *Tacc,               /* acceleration time */
                          PREF ref,                  /* static variable */
                          float *MAX_STEP,           /* max step limitation */
                          float *posRe,              /* real position */
                          float *posFl,              /* desire position */
                          float *trajRef );          /* ref. Traj. 0..2 -> q_d, 3..5-> v_d, 6..8->a_d */


/////////////////////////////////////////////////////////////////
//******* arm trajectory
void arm_reference_trajectory(int INIT,                  /* init start */
                          double TS,                  /* sampling time */
                          double SP,                  /* interval  */
                          double *Tacc,               /* acceleration time */
                          PARMREF ref,                  /* static variable */
                          float *MAX_STEP,           /* max step limitation */
                          float *posRe,              /* real position */
                          float *posFl,              /* desire position */
                          float *trajRef );          /* ref. Traj. 0..2 -> q_d, 3..5-> v_d, 6..8->a_d */


#endif