#ifndef STRUCTS_H
#define STRUCTS_H

//#include "CANnucleo.h"
#include "mbed.h"
#include "FastPWM.h"


typedef struct{
    DigitalOut *enable;
    DigitalOut *led;
    FastPWM *pwm_u, *pwm_v, *pwm_w;
    } GPIOStruct;
    
typedef struct{
    
    }COMStruct;
    
typedef struct{
    int adc1_raw, adc2_raw, adc3_raw;
    float i_a, i_b, i_c;
    float v_bus;
    float theta_mech, theta_elec;
    float dtheta_mech, dtheta_elec, dtheta_elec_filt;
    float theta_mech1, theta_elec1;                       //shaorui add for joint position read theta_joint_raw_pre
    float dtheta_mech1, dtheta_elec1, dtheta_elec_filt1;  //shaorui add for joint position read
    float theta_joint, theta_joint_raw, theta_joint_raw_pre,theta_joint_raw_fil; //hjb added
    float i_d, i_q, i_q_filt, i_d_filt;                               // D/Q currents
    float v_d, v_q;                                         // D/Q voltages
    float dtc_u, dtc_v, dtc_w;                              // Terminal duty cycles
    float v_u, v_v, v_w;                                    // Terminal voltages
    float k_d, k_q, ki_d, ki_q, alpha;                      // Current loop gains, current reference filter coefficient
    float d_int, q_int;                                     // Current error integrals
    int adc1_offset, adc2_offset;                           // ADC offsets
    float i_d_ref, i_q_ref, i_d_ref_filt, i_q_ref_filt;     // Current references
    int loop_count;                                         // Degubbing counter
    int timeout;                                            // Watchdog counter
    int mode;
    int ovp_flag;                                           // Over-voltage flag
    float p_des, v_des, kp, kd, t_ff;                       // Desired position, velocity, gians, torque   
    float v_ref, fw_int;                                     // output voltage magnitude, field-weakening integral
    float cogging[128];
    int current_sector;
    int otw_flag;                                           // Over-temp warning
    float i_max;
    float inverter_tab[128];
    int oc_flag;
    float angle,angle1;//shaorui add  for test
    float init1, init2,cha;  
    int c,sidebct; 
    int sidebct1;
    int Ncycle;
    float Ncycle_mod, Mech_mod;
    } ControllerStruct;

typedef struct{
    double temperature;                                              // Estimated temperature
    float temp_measured;
    float q_in, q_out;
    float resistance;
    float k;
    float trust;
    float delta_t;
    
    float theta_m, theta_est;
    float thetadot_m, thetadot_est;
    float i_d_m, i_d_est;
    float i_q_m, i_q_est;
    float i_d_dot, i_q_dot;
    float e_d, e_q;
    float e_d_int, e_q_int;
    } ObserverStruct;
    
#endif
