#ifndef MA700SENSOR_H
#define MA700SENSOR_H
#include "structs.h"
class PositionSensor1 {
public:
    virtual void Sample(float dt) = 0;
    virtual float GetMechPosition() {return 0.0f;}
    virtual float GetMechPositionFixed() {return 0.0f;}
    virtual float GetElecPosition() {return 0.0f;}
    virtual float GetMechVelocity() {return 0.0f;}
    virtual float GetElecVelocity() {return 0.0f;}
    virtual void ZeroPosition(void) = 0;
    virtual int GetRawPosition(void) = 0;
    virtual void SetElecOffset(float offset) = 0;
    virtual int GetCPR(void) = 0;
    virtual  void WriteLUT(int new_lut[128]) = 0;
    virtual int Gettest() {return 0;}
    virtual int Gettest1() {return 0;}
    virtual int Gettest2() {return 0;}
    virtual void ReadLUT(void)=0;
    //virtual void WriteRegister( ControllerStruct * controller)=0;
};
  
 /* 
class PositionSensorEncoder: public PositionSensor {
public:
    PositionSensorEncoder(int CPR, float offset, int ppairs);
    virtual void Sample(float dt);
    virtual float GetMechPosition();
    virtual float GetElecPosition();
    virtual float GetMechVelocity();
    virtual float GetElecVelocity();
    virtual void ZeroPosition(void);
    virtual void SetElecOffset(float offset);
    virtual int GetRawPosition(void);
    virtual int GetCPR(void);
    virtual  void WriteLUT(int new_lut[128]); 
private:
    InterruptIn *ZPulse;
    DigitalIn *ZSense;
    //DigitalOut *ZTest;
    virtual void ZeroEncoderCount(void);
    virtual void ZeroEncoderCountDown(void);
    int _CPR, flag, rotations, _ppairs, raw;
    //int state;
    float _offset, MechPosition, MechOffset, dir, test_pos, oldVel, out_old, velVec[40];
    int offset_lut[128];
};
*/

class PositionSensorMA700: public PositionSensor1{
public:
    PositionSensorMA700(int CPR, float offset, int ppairs);
    virtual void Sample(float dt);
    virtual float GetMechPosition();
    virtual float GetMechPositionFixed();
    virtual float GetElecPosition();
    virtual float GetMechVelocity();
    virtual float GetElecVelocity();
    virtual int GetRawPosition();
    virtual void ZeroPosition();
    virtual void SetElecOffset(float offset);
    virtual void SetMechOffset(float offset);
    virtual int GetCPR(void);
    virtual void WriteLUT(int new_lut[128]);
    virtual int Gettest();
    virtual int Gettest1(); 
    virtual int Gettest2(); 
    virtual void WriteRegister( ControllerStruct * controller);
    virtual void ReadLUT(void);
private:
    float position, ElecPosition,JointOffset , ElecOffset, MechPosition, MechOffset, modPosition, oldModPosition, oldVel, velVec[40], MechVelocity, ElecVelocity, ElecVelocityFilt;
    int raw, _CPR, rotations, old_counts, _ppairs, first_sample;
    SPI *spi;
    DigitalOut *cs;
    int readAngleCmd;
    int BCT;
    int ETXY;
    int BCTREAD;
    int ETXYREAD;
    int _test;
    int _test1;
    int _test2;
    int offset_lut[128];
   
};

#endif