#include "mbed.h" 
#include "MFRC522.h"

// FRDM-K64F (Freescale) Pin for MFRC522 reset 
#define MF_RESET    PTD0 
#define SERIAL_1

DigitalOut LedGreen(LED2); 
PwmOut servo(PTC3);
Serial pc(USBTX, USBRX); // serial comm on the FRDM board
//MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET); 
MFRC522    RfChip   (PTD2, PTD3, PTD1, PTE25, PTD0); 
 
int main(void) 
{ 
    int fulluid=0; 
   pc.baud(9600);
   
   printf("Welcome to Project RFIDO, I hope you enjoy your experience!!!...\n\r");
   
   RfChip.PCD_Init(); 
 
   while (true) 
  { 
     LedGreen = 1; 
 
     // Look for new cards 
     if ( ! RfChip.PICC_IsNewCardPresent()) 
     { 
       wait_ms(200); 
       continue; 
     } 
 
     // Select one of the cards 
     if ( ! RfChip.PICC_ReadCardSerial()) 
     { 
   
       wait_ms(200); 
       continue; 
     } 
      LedGreen = 0;
      int a=0; int b=0; int c=0;int d=0; int e=0; int f=0;int g=0; int h=0;   
        
     // Print Card UID 
     printf("Card UID:"); 
     //blue.printf("Card UID:");
     for (uint8_t i = 0; i < RfChip.uid.size; i++) 
     { 
      printf(" %X02 ", RfChip.uid.uidByte[i]);
      
      //blue.printf(" %X02 ", RfChip.uid.uidByte[i]);
      a = RfChip.uid.uidByte[0];
      b = RfChip.uid.uidByte[1];
      c = RfChip.uid.uidByte[2];
      d = RfChip.uid.uidByte[3];
      e = RfChip.uid.uidByte[4];
      f = RfChip.uid.uidByte[5];
      g = RfChip.uid.uidByte[6];
      h = RfChip.uid.uidByte[7];
     
     }  
      
      fulluid = a+b+c+d+e+f+g+h;
      printf("\n\r"); 
    
     
    
     //Print Card Type
    if(a==153)  
    { 
         printf("\r\nWelcome Fido, Enjoy your tasty feast!");
        
     }
     
     else
     {
        printf("\r\nUnrecognized tag");
        printf("\r\nSCRAM YOU FILTHY ANIMAL!!!");
     }     
     
     printf("\n\r"); 
     
     
     //blue.printf("\n\r"); 
     
     // Print RFID Card type 
     uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak); 
     printf("PICC Type: %s \n\n\r\r", RfChip.PICC_GetTypeName(piccType));
     
     wait_ms(200); 
     
     while (fulluid==721)
    {
    
        servo.period(0.020f);   
        servo.pulsewidth_ms(2); // servo position determined by a pulsewidth between 1-2ms
        wait(15);
        servo.pulsewidth_ms(1.5f);
        fulluid=0;
    }
  }
} 
    
  
 
