#include "Rocket.h"

void Rocket::init(int x, int y, int size, int speed){
    _x = x;
    _y = y;
    _size = size;
    
    _velocity.x = speed;
    _velocity.y = speed;
}

void Rocket::draw(N5110 &lcd){
    lcd.drawRect(_x,_y,_size,_size,FILL_BLACK);
}

void Rocket::update(Position2D pokeball_pos){
    if (
        (_x <= pokeball_pos.x) && (_y <= pokeball_pos.y) )
        {
            _x += _velocity.x;
            _y += _velocity.y;}
    if (
        (_x > pokeball_pos.x) && (_y < pokeball_pos.y) )
        {
        _x -= _velocity.x;
        _y += _velocity.y;}
    if (
        (_x > pokeball_pos.x) && (_y > pokeball_pos.y) )
        {
        _x -= _velocity.x;
        _y -= _velocity.y;}
    if (
        (_x < pokeball_pos.x) && (_y > pokeball_pos.y) )
        {
        _x += _velocity.x;
        _y -= _velocity.y;}      
            
    if (_y < 1) _y = 1;
    if (_x < 1) _x = 1;
    if (_x > WIDTH - 1) _x = WIDTH - 1;
    if (_y > HEIGHT - 1) _y = HEIGHT - 1;      
}

void Rocket::set_velocity(Position2D v){
    _velocity.x = v.x;
    _velocity.y = v.y;
}

void Rocket::set_pos(Position2D p){
    _x = p.x;
    _y = p.y;
}

void Rocket::rocket_crash(){
    _x = rand() % 84 ;
    _y = rand() % 48 ;
}

Position2D Rocket::get_velocity(){ return {_velocity.x,_velocity.y}; }


int Rocket::get_size() { return _size; }
    

Position2D Rocket::get_pos() { return {_x,_y}; }