#include "Pokemon.h"

void Pokemon::init(int x, int y, int size, int speed){
    _x = x;
    _y = y;
    _size = size;
    
    _velocity.x = speed;
    _velocity.y = speed;
}

void Pokemon::draw(N5110 &lcd){
    lcd.drawRect(_x,_y,_size,_size,FILL_BLACK);
}

void Pokemon::update(){
    _x += _velocity.x;
    _y += _velocity.y;
}

void Pokemon::set_velocity(Position2D v){
    _velocity.x = v.x;
    _velocity.y = v.y;
}

void Pokemon::set_pos(Position2D p){
    _x = p.x;
    _y = p.y;
}

void Pokemon::pokemon_caught(){
    _x = rand() % 84 ;
    _y = rand() % 48 ;
}


Position2D Pokemon::get_velocity(){ return {_velocity.x,_velocity.y}; }

Position2D Pokemon::get_pos() { return {_x,_y}; }

int Pokemon::get_size() { return _size; }
    

