#include "Pokeball.h"

void Pokeball::init(int x, int y, int radius){
    _x = x;
    _y = y;
    _radius = radius;
    _speed = 1;//default speed


}

void Pokeball::draw(N5110 &lcd) {
    //printf("Ball: Draw\n");
    lcd.drawCircle(_x, _y, _radius, FILL_BLACK); 
}

void Pokeball::update(UserInput input){
    _speed = 4;
    switch(input.d){
        case N: _y -= _speed; break;
        case NE: _y -= _speed; _x += _speed; break;
        case E: _x += _speed; break;
        case SE: _y += _speed; _x += _speed; break;
        case S: _y += _speed; break;
        case SW: _y += _speed; _x -= _speed; break;
        case W: _x -= _speed; break;
        case NW: _y -= _speed; _x -= _speed; break;
        dafault: break;
    }
    
    if (_y - _radius < 1) _y = _radius + 1;
    if (_x - _radius < 1) _x = _radius + 1;
    if (_x + _radius > WIDTH - 1) _x = WIDTH - _radius - 1;
    if (_y + _radius > HEIGHT - 1) _y = HEIGHT - _radius - 1;
}

void Pokeball::update_vol(){
    _radius += 2;
}

void Pokeball::pokemon_caught(){
    _x = 30;
    _y = 20 ;
}    

Position2D Pokeball::get_pos() { return {_x,_y}; }

int Pokeball::get_radius() { return _radius; }    