#ifndef POKEENGINE_H
#define POKEENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Pokeball.h"
#include "Pokemon.h"
#include "Rocket.h"
#include "Utils.h"

class PokeEngine{
    public:
        PokeEngine();  // pass in the lcd object from the main file
        void init(int ball_x, int ball_y, int ball_radius, int pokemong_x, int pokemon_y, int pokemon_size, int speed);
        void init_rocket(int x, int y,int size, int speed);
        int update(UserInput input);
        void draw(N5110 &lcd);    
       void check_lives(int lives);
        int get_lives();
        int get_score();

    private:
        Pokeball _pokeball;
        Pokemon _pokemon;
        Rocket _rocket;
        void check_catching_collision();  
        void check_wall_collision();
        void check_crash();
        int _lives,_score;
};
        
#endif