
#include "PokeEngine.h"

PokeEngine::PokeEngine(){ _lives = 4; }    

void PokeEngine::init(int ball_x, int ball_y, int ball_radius, int pokemon_x, int pokemon_y, int pokemon_size, int speed){
    _pokeball.init(ball_x, ball_y, ball_radius);
    _pokemon.init(pokemon_x, pokemon_y, pokemon_size, speed);
    _score = 0;
}

void PokeEngine::init_rocket(int x, int y, int size, int speed){
    _rocket.init(x,y,size, speed);    
}

int PokeEngine::update(UserInput input){
    _pokeball.update(input);
    Position2D ball_pos = _pokeball.get_pos();
    _pokemon.update();
    _rocket.update(ball_pos);
   
    check_wall_collision();
    check_catching_collision();
    check_crash();
    return _lives;
}

void PokeEngine::draw(N5110 &lcd) {
    //printf("Pong Engine: Draw\n");
    // draw the elements in the LCD buffer
    // pitch
    lcd.drawLine(0,0,WIDTH-1,0,1);  // top
    lcd.drawLine(WIDTH-1,0,WIDTH-1,HEIGHT-1,1);  // back wall
    lcd.drawLine(0,HEIGHT-1,WIDTH-1,HEIGHT-1,1); // bottom
    lcd.drawLine(0,0,0,HEIGHT-1,1);
    _pokeball.draw(lcd);
    _pokemon.draw(lcd);
    _rocket.draw(lcd);
}

void PokeEngine::check_wall_collision() {
    //printf("Pong Engine: Check Wall Collision\n");
    // read current ball attributes
    Position2D pokemon_pos = _pokemon.get_pos();
    Position2D pokemon_velocity = _pokemon.get_velocity();
    int size = _pokemon.get_size();

    // check if hit top wall
    if (pokemon_pos.y <= 1) {  //  1 due to 1 pixel boundary
        pokemon_pos.y = 1;  // bounce off ceiling without going off screen
        pokemon_velocity.y = -pokemon_velocity.y;  // flip velocity
    } else if (pokemon_pos.y + size >= (HEIGHT-1) ) {
        // hit bottom
        pokemon_pos.y = (HEIGHT-1) - size;  // stops ball going off screen
        pokemon_velocity.y = -pokemon_velocity.y;    // flip velcoity 
    } else if (pokemon_pos.x + size >= (WIDTH-1) ) {
        // hit right wall
        pokemon_pos.x = (WIDTH-1) - size;  // stops ball going off screen
        pokemon_velocity.x = -pokemon_velocity.x;    // flip velcoity 
    } else if (pokemon_pos.x <= 1) {  //  1 due to 1 pixel boundary
        pokemon_pos.x = 1;  // bounce off ceiling without going off screen
        pokemon_velocity.x = -pokemon_velocity.x;  // flip velocity
    }

    // update ball parameters
    _pokemon.set_velocity(pokemon_velocity);
    _pokemon.set_pos(pokemon_pos);
}

void PokeEngine::check_catching_collision() {
    Position2D pokemon_pos = _pokemon.get_pos();
    Position2D pokeball_pos = _pokeball.get_pos();  // paddle

    // see if ball has hit the paddle by checking for overlaps
    if (
        (pokemon_pos.y >= pokeball_pos.y - _pokeball.get_radius()) && //top
        (pokemon_pos.y <= pokeball_pos.y + _pokeball.get_radius() ) && //bottom
        (pokemon_pos.x >= pokeball_pos.x - _pokeball.get_radius()) && //left
        (pokemon_pos.x <= pokeball_pos.x + _pokeball.get_radius() )  //right
    ) {
        // if it has,the pokemon is caught.
        _pokemon.pokemon_caught();
        _score++;
    }
}


void PokeEngine::check_crash() {
    int left_lives = _lives;
    Position2D rocket_pos = _rocket.get_pos();
    int rocket_size = _rocket.get_size();
    Position2D pokeball_pos = _pokeball.get_pos();  // paddle

     // see if ball has hit the paddle by checking for overlaps
    if (
        (rocket_pos.y >= pokeball_pos.y - _pokeball.get_radius()) && //top
        (rocket_pos.y <= pokeball_pos.y + _pokeball.get_radius() ) && //bottom
        (rocket_pos.x >= pokeball_pos.x - _pokeball.get_radius()) && //left
        (rocket_pos.x <= pokeball_pos.x + _pokeball.get_radius() )  //right
    ) {
        // if it has,the pokemon is caught.
        _rocket.rocket_crash();
        _lives--;
        }
}


    int PokeEngine::get_lives() { return _lives;}
    
    int PokeEngine::get_score() { return _score; }
    
    void  PokeEngine::check_lives(int lives) { _lives = lives ;}

