
///////////// includes /////////////////////
#include "mbed.h"
#include "platform/mbed_thread.h"
#include "Joystick.h"
#include "N5110.h"
#include "ShiftReg.h"  
#include "PokeEngine.h"
#include "Utils.h"
//#include <cstdlib>
#include "Tone.h"
///////////// defines /////////////////////
#define PADDLE_WIDTH 2
#define PADDLE_HEIGHT 8
#define BALL_SIZE 2
#define BALL_SPEED 3
///////////// objects ///////////////////
N5110 lcd(p14,p8,p9,p10,p11,p13,p21);
Joystick joystick(p20,p19);
DigitalIn buttonA(p29);
BusOut leds(LED4,LED3,LED2,LED1);
ShiftReg seven_seg;
AnalogIn pot(p17); 
PokeEngine poke;
Tone dac(p18);
///////////// prototypes ///////////////////
void init();
void welcome();
void render();
void gameover();
void display_lives(int lives);

const int note_background []= {
    NOTE_FS3, NOTE_FS3, NOTE_CS4, NOTE_B3, NOTE_A3,
    NOTE_GS3, NOTE_GS3, NOTE_GS3, NOTE_B3, NOTE_A3, NOTE_GS3,
    NOTE_A3, NOTE_A4, NOTE_GS4, NOTE_A4, NOTE_GS4, NOTE_A4,
    NOTE_A3, NOTE_A4, NOTE_GS4, NOTE_A4, NOTE_GS4, NOTE_A4,
    
    NOTE_FS3, NOTE_FS3, NOTE_CS4, NOTE_B3, NOTE_A3,
    NOTE_GS3, NOTE_GS3, NOTE_GS3, NOTE_B3, NOTE_A3, NOTE_GS3,
    NOTE_A3, NOTE_A4, NOTE_GS4, NOTE_A4, NOTE_GS4, NOTE_A4,
    NOTE_A3, NOTE_A4, NOTE_GS4, NOTE_A4, NOTE_GS4, NOTE_A4,
    
    NOTE_FS3, NOTE_FS3, NOTE_CS4, NOTE_B3, NOTE_A3,
    NOTE_GS3, NOTE_GS3, NOTE_GS3, NOTE_B3, NOTE_A3, NOTE_GS3,
    NOTE_FS3, NOTE_FS3, NOTE_A4, NOTE_GS4, NOTE_A4, NOTE_GS4, NOTE_A4,
    NOTE_FS3, NOTE_FS3, NOTE_A4, NOTE_GS4, NOTE_A4, NOTE_GS4, NOTE_A4,
    
    NOTE_FS3, NOTE_FS3, NOTE_CS4, NOTE_B3, NOTE_A3,
    NOTE_GS3, NOTE_GS3, NOTE_GS3, NOTE_B3, NOTE_A3, NOTE_GS3,
    NOTE_FS3, NOTE_FS3, NOTE_A4, NOTE_GS4, NOTE_A4, NOTE_GS4, NOTE_A4,
    NOTE_FS3, NOTE_FS3, NOTE_A4, NOTE_GS4, NOTE_A4, NOTE_GS4, NOTE_A4,
    
    NOTE_FS3, NOTE_FS3, NOTE_CS4, NOTE_B3, NOTE_A3,
    NOTE_GS3, NOTE_GS3, NOTE_GS3, NOTE_B3, NOTE_A3, NOTE_GS3,
    NOTE_FS3, NOTE_FS3, NOTE_A4, NOTE_GS4, NOTE_A4, NOTE_GS4, NOTE_A4,
};

const int duration_background[] = {
    4,8,8,4,4,
    4,8,8,4,4,
    4,4,8,8,8,8,
    4,4,8,8,8,8,
    
    4,8,8,4,4,
    4,8,8,4,4,
    4,4,8,8,8,8,
    4,4,8,8,8,8,
    
    4,8,8,4,4,
    4,8,8,4,4,
    4,4,8,8,8,8,
    4,4,8,8,8,8,
    
    4,8,8,4,4,
    4,8,8,4,4,
    4,4,8,8,8,8,
    4,4,8,8,8,8,
    
    4,8,8,4,4,
    4,8,8,4,4,
    4,4,8,8,8,8,
};
/*
const int duration_array[] = {
    4,8,8,4,4,
    4,8,8,4,4,
    4,4,8,8,8,8,
    4,4,8,8,8,8,
    
    4,8,8,4,4,
    4,8,8,4,4,
    4,4,8,8,8,8,
    4,4,8,8,8,8,
    
    4,8,8,4,4,
    4,8,8,4,4,
    4,4,8,8,8,8,
    4,4,8,8,8,8,
    
    4,8,8,4,4,
    4,8,8,4,4,
    4,4,8,8,8,8,
    4,4,8,8,8,8,
    
    4,8,8,4,4,
    4,8,8,4,4,
    4,4,8,8,8,8,
};

const int note_array[] = {
    NOTE_FS3, NOTE_FS3, NOTE_CS4, NOTE_B3, NOTE_A3,
    NOTE_GS3, NOTE_GS3, NOTE_GS3, NOTE_B3, NOTE_A3, NOTE_GS3,
    NOTE_A3, NOTE_A4, NOTE_GS4, NOTE_A4, NOTE_GS4, NOTE_A4,
    NOTE_A3, NOTE_A4, NOTE_GS4, NOTE_A4, NOTE_GS4, NOTE_A4,
    
    NOTE_FS3, NOTE_FS3, NOTE_CS4, NOTE_B3, NOTE_A3,
    NOTE_GS3, NOTE_GS3, NOTE_GS3, NOTE_B3, NOTE_A3, NOTE_GS3,
    NOTE_A3, NOTE_A4, NOTE_GS4, NOTE_A4, NOTE_GS4, NOTE_A4,
    NOTE_A3, NOTE_A4, NOTE_GS4, NOTE_A4, NOTE_GS4, NOTE_A4,
    
    NOTE_FS3, NOTE_FS3, NOTE_CS4, NOTE_B3, NOTE_A3,
    NOTE_GS3, NOTE_GS3, NOTE_GS3, NOTE_B3, NOTE_A3, NOTE_GS3,
    NOTE_FS3, NOTE_FS3, NOTE_A4, NOTE_GS4, NOTE_A4, NOTE_GS4, NOTE_A4,
    NOTE_FS3, NOTE_FS3, NOTE_A4, NOTE_GS4, NOTE_A4, NOTE_GS4, NOTE_A4,
    
    NOTE_FS3, NOTE_FS3, NOTE_CS4, NOTE_B3, NOTE_A3,
    NOTE_GS3, NOTE_GS3, NOTE_GS3, NOTE_B3, NOTE_A3, NOTE_GS3,
    NOTE_FS3, NOTE_FS3, NOTE_A4, NOTE_GS4, NOTE_A4, NOTE_GS4, NOTE_A4,
    NOTE_FS3, NOTE_FS3, NOTE_A4, NOTE_GS4, NOTE_A4, NOTE_GS4, NOTE_A4,
    
    NOTE_FS3, NOTE_FS3, NOTE_CS4, NOTE_B3, NOTE_A3,
    NOTE_GS3, NOTE_GS3, NOTE_GS3, NOTE_B3, NOTE_A3, NOTE_GS3,
    NOTE_FS3, NOTE_FS3, NOTE_A4, NOTE_GS4, NOTE_A4, NOTE_GS4, NOTE_A4,
};
*/
//volatile int g_gameover_flag = 0;
//void gameover_isr();

int main() {

    init();
    welcome(); 
    render();
    int fps = 10;
    int lives = 4;
    //poke.check_lives(lives);
    display_lives(lives);
     while (lives != 0) {  // keep looping while lives remain
        // read the joystick input and store in a struct
        UserInput input = {joystick.get_direction(),joystick.get_mag()};
        lives = poke.update(input);   // update the game engine based on input
        printf("lives = %d ", lives);
        display_lives(lives);         // display lives on LEDs    
        render();                     // draw frame on screen
        thread_sleep_for(1000/fps);         // and wait for one frame period - ms
        }
    //int n = sizeof(note_array)/sizeof(int);
    //dac.play_melody(n,note_array,duration_array,72.0,true);
    gameover();
/*    while (1) {

        // check if flag is set i.e. interrupt has occured
        if (g_timer_flag) {
            g_timer_flag = 0;  // if it has, clear the flag
            printf("Tick \n");
            // DO TASK HERE
        }

        // put the MCU to sleep until an interrupt wakes it up
        sleep();

    }*/
    
}

void init() {
    lcd.clear();
    seven_seg.write(0x00);  // turn of 7-seg display
    lcd.init();
    lcd.setContrast(0.4);
    joystick.init();
    dac.init();

    poke.init(70,10,5,20,10,3,2);
    poke.init_rocket(50,40,4,2);
}

void welcome() { // splash screen
    lcd.printString("  Pokemon go!    ",0,1);  
    lcd.printString("    Press A   ",0,4);
    lcd.refresh();
    //t n_background = sizeof(note_background)/sizeof(int);
    //c.play_melody(n_background,note_background,duration_background,72.0,true);
        while (buttonA.read() == 0) {
        leds = 0b1111;
        thread_sleep_for(100);
        leds = 0b0000;
        thread_sleep_for(100);   
    }
}

void render() {  // clear screen, re-draw and refresh
    lcd.clear();  
    poke.draw(lcd);
    lcd.refresh();
}
    
void display_lives(int lives) {
    if (lives == 4) {
        leds = 0b1111;
        seven_seg.write(0x66);
    } else if (lives == 3) {
        leds = 0b1110;
        seven_seg.write(0x4F);
    } else if (lives == 2) {
        leds = 0b1100;
        seven_seg.write(0x5B);
    } else if (lives == 1) {
        leds = 0b1000;
        seven_seg.write(0x06);
    } else {
        leds = 0b0000;
        seven_seg.write(0x3F);
    }
}

void gameover() { // splash screen 
    //for (int i = 1; i < 10; i++) {
    while(1){      
        lcd.clear();
        int score = poke.get_score();
        char char_score = score + '0';
       // char *char_score = new char[2];
        //for (int i = 0; i < 2; i++){
        // char_score[i] = score;}
        lcd.printString("  Game Over ",0,0);  
        lcd.printString(" Your score: ",0,2);
        lcd.printChar(char_score,42,4);
        lcd.refresh();
        leds = 0b1111;
        thread_sleep_for(250);
        lcd.clear();
        lcd.refresh();
        leds = 0b0000;
        thread_sleep_for(250);   
    }
}

/*void gameover_isr()
{
    g_gameover_flag = 1;   // set flag in ISR
}*/